/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3KeyWrapScheme;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class S3CryptoModuleBase<T extends MultipartUploadContext>
extends S3CryptoModule<T> {
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final CryptoConfiguration cryptoConfig;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final S3CryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final Map<String, T> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final S3Direct s3;

    protected S3CryptoModuleBase(S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, ClientConfiguration clientConfig, CryptoConfiguration cryptoConfig, S3CryptoScheme cryptoScheme) {
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.cryptoConfig = cryptoConfig;
        this.s3 = s3;
        this.cryptoScheme = cryptoScheme;
        this.contentCryptoScheme = cryptoScheme.getContentCryptoScheme();
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.s3.abortMultipartUpload(req);
        this.multipartUploadContexts.remove(req.getUploadId());
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, File file, ContentCryptoMaterial instruction) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (file != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            metadata.setContentType(mimetypes.getMimetype(file));
        }
        return instruction.toObjectMetadata(metadata);
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(AmazonWebServiceRequest req) {
        if (req instanceof MaterialsDescriptionProvider) {
            return this.newContentCryptoMaterial(this.kekMaterialsProvider, ((MaterialsDescriptionProvider)((Object)req)).getMaterialsDescription(), this.cryptoConfig.getCryptoProvider());
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider());
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Map<String, String> materialsDescription, Provider provider) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials(materialsDescription);
        return this.buildContentCryptoMaterial(kekMaterials, provider);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Provider provider) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials();
        return this.buildContentCryptoMaterial(kekMaterials, provider);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials kekMaterials, Provider provider) {
        SecretKey cek = this.generateCEK();
        byte[] iv = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoScheme.getSecureRandom().nextBytes(iv);
        SecuredCEK cekSecured = this.secureCEK(cek, kekMaterials, provider);
        return new ContentCryptoMaterial(kekMaterials.getMaterialsDescription(), cekSecured.encrypted, cekSecured.keyWrapAlgorithm, this.contentCryptoScheme.createCipherLite(cek, iv, 1, provider));
    }

    protected final SecretKey generateCEK() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            generator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    protected final SecuredCEK secureCEK(SecretKey toBeEncrypted, EncryptionMaterials materials, Provider cryptoProvider) {
        Key kek = materials.getKeyPair() != null ? materials.getKeyPair().getPublic() : materials.getSymmetricKey();
        S3KeyWrapScheme kwScheme = this.cryptoScheme.getKeyWrapScheme();
        String keyWrapAlgo = kwScheme.getKeyWrapAlgorithm(kek);
        try {
            if (keyWrapAlgo != null) {
                Cipher cipher = cryptoProvider == null ? Cipher.getInstance(keyWrapAlgo) : Cipher.getInstance(keyWrapAlgo, cryptoProvider);
                cipher.init(3, kek, this.cryptoScheme.getSecureRandom());
                return new SecuredCEK(cipher.wrap(toBeEncrypted), keyWrapAlgo);
            }
            byte[] toBeEncryptedBytes = toBeEncrypted.getEncoded();
            String algo = kek.getAlgorithm();
            Cipher cipher = cryptoProvider != null ? Cipher.getInstance(algo, cryptoProvider) : Cipher.getInstance(algo);
            cipher.init(1, kek);
            return new SecuredCEK(cipher.doFinal(toBeEncryptedBytes), null);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to encrypt symmetric key: " + e.getMessage(), e);
        }
    }

    protected final PutObjectRequest wrapWithCipher(PutObjectRequest request, ContentCryptoMaterial cekMaterial) {
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("x-amz-unencrypted-content-md5", metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.addUserMetadata("x-amz-unencrypted-content-length", Long.toString(plaintextLength));
            metadata.setContentLength(this.ciphertextLength(plaintextLength));
        }
        request.setMetadata(metadata);
        request.setInputStream(this.newS3CipherLiteInputStream(request, cekMaterial, plaintextLength));
        request.setFile(null);
        return request;
    }

    private CipherLiteInputStream newS3CipherLiteInputStream(PutObjectRequest req, ContentCryptoMaterial cekMaterial, long plaintextLength) {
        try {
            InputStream is = req.getInputStream();
            if (req.getFile() != null) {
                is = new RepeatableFileInputStream(req.getFile());
            }
            if (plaintextLength > -1L) {
                is = new LengthCheckInputStream(is, plaintextLength, false);
            }
            return new CipherLiteInputStream(is, cekMaterial.getCipherLite(), 2048);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    protected final long plaintextLength(PutObjectRequest request, ObjectMetadata metadata) {
        if (request.getFile() != null) {
            return request.getFile().length();
        }
        if (request.getInputStream() != null && metadata.getRawMetadataValue("Content-Length") != null) {
            return metadata.getContentLength();
        }
        return -1L;
    }

    public final S3CryptoScheme getS3CryptoScheme() {
        return this.cryptoScheme;
    }

    protected final PutObjectRequest upateInstructionPutRequest(PutObjectRequest request, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
            request.setMetadata(metadata);
        }
        metadata.setContentLength(bytes.length);
        metadata.addUserMetadata("x-amz-crypto-instr-file", "");
        request.setKey(request.getKey() + ".instruction");
        request.setMetadata(metadata);
        request.setInputStream(is);
        request.setFile(null);
        return request;
    }

    protected final PutObjectRequest createInstructionPutRequest(String bucketName, String key, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString().getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(bytes.length);
        metadata.addUserMetadata("x-amz-crypto-instr-file", "");
        return new PutObjectRequest(bucketName, key + ".instruction", is, metadata);
    }

    final <X extends AmazonWebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
        return request;
    }

    private static class SecuredCEK {
        final byte[] encrypted;
        final String keyWrapAlgorithm;

        SecuredCEK(byte[] encryptedKey, String keyWrapAlgorithm) {
            this.encrypted = encryptedKey;
            this.keyWrapAlgorithm = keyWrapAlgorithm;
        }
    }
}

