/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudsearchv2.AmazonCloudSearch;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.BuildSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.CreateDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DefineSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteAnalysisSchemeResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteExpressionResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterRequest;
import com.amazonaws.services.cloudsearchv2.model.DeleteSuggesterResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAnalysisSchemesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeExpressionsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersRequest;
import com.amazonaws.services.cloudsearchv2.model.DescribeSuggestersResult;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearchv2.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesRequest;
import com.amazonaws.services.cloudsearchv2.model.ListDomainNamesResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateAvailabilityOptionsResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateScalingParametersResult;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearchv2.model.UpdateServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearchv2.model.transform.BaseExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.BuildSuggestersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.BuildSuggestersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineAnalysisSchemeRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineAnalysisSchemeResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineSuggesterRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DefineSuggesterResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteAnalysisSchemeRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteAnalysisSchemeResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteSuggesterRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DeleteSuggesterResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAnalysisSchemesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAnalysisSchemesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAvailabilityOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeAvailabilityOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeDomainsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeExpressionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeExpressionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeIndexFieldsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeIndexFieldsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeScalingParametersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeScalingParametersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeSuggestersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DescribeSuggestersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.DisabledOperationExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.IndexDocumentsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.IndexDocumentsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.InvalidTypeExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ListDomainNamesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ListDomainNamesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateAvailabilityOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateAvailabilityOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateScalingParametersRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateScalingParametersResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearchv2.model.transform.UpdateServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class AmazonCloudSearchClient
extends AmazonWebServiceClient
implements AmazonCloudSearch {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonCloudSearchClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudSearchClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudSearchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudSearchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidTypeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DisabledOperationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BaseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudsearch.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudsearchv2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudsearchv2/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnalysisSchemesResult describeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAnalysisSchemesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAnalysisSchemesRequest> request = null;
        Response<DescribeAnalysisSchemesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAnalysisSchemesRequestMarshaller().marshall(describeAnalysisSchemesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAnalysisSchemesResultStaxUnmarshaller(), executionContext);
            DescribeAnalysisSchemesResult describeAnalysisSchemesResult = response.getAwsResponse();
            return describeAnalysisSchemesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexFieldResult deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteIndexFieldRequest> request = null;
        Response<DeleteIndexFieldResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteIndexFieldRequestMarshaller().marshall(deleteIndexFieldRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteIndexFieldResultStaxUnmarshaller(), executionContext);
            DeleteIndexFieldResult deleteIndexFieldResult = response.getAwsResponse();
            return deleteIndexFieldResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAvailabilityOptionsResult updateAvailabilityOptions(UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateAvailabilityOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateAvailabilityOptionsRequest> request = null;
        Response<UpdateAvailabilityOptionsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateAvailabilityOptionsRequestMarshaller().marshall(updateAvailabilityOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateAvailabilityOptionsResultStaxUnmarshaller(), executionContext);
            UpdateAvailabilityOptionsResult updateAvailabilityOptionsResult = response.getAwsResponse();
            return updateAvailabilityOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIndexFieldsResult describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeIndexFieldsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeIndexFieldsRequest> request = null;
        Response<DescribeIndexFieldsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeIndexFieldsRequestMarshaller().marshall(describeIndexFieldsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeIndexFieldsResultStaxUnmarshaller(), executionContext);
            DescribeIndexFieldsResult describeIndexFieldsResult = response.getAwsResponse();
            return describeIndexFieldsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineExpressionResult defineExpression(DefineExpressionRequest defineExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DefineExpressionRequest> request = null;
        Response<DefineExpressionResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DefineExpressionRequestMarshaller().marshall(defineExpressionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DefineExpressionResultStaxUnmarshaller(), executionContext);
            DefineExpressionResult defineExpressionResult = response.getAwsResponse();
            return defineExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceAccessPoliciesResult updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateServiceAccessPoliciesRequest> request = null;
        Response<UpdateServiceAccessPoliciesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateServiceAccessPoliciesRequestMarshaller().marshall(updateServiceAccessPoliciesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateServiceAccessPoliciesResultStaxUnmarshaller(), executionContext);
            UpdateServiceAccessPoliciesResult updateServiceAccessPoliciesResult = response.getAwsResponse();
            return updateServiceAccessPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineSuggesterResult defineSuggester(DefineSuggesterRequest defineSuggesterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineSuggesterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DefineSuggesterRequest> request = null;
        Response<DefineSuggesterResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DefineSuggesterRequestMarshaller().marshall(defineSuggesterRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DefineSuggesterResultStaxUnmarshaller(), executionContext);
            DefineSuggesterResult defineSuggesterResult = response.getAwsResponse();
            return defineSuggesterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnalysisSchemeResult deleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAnalysisSchemeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteAnalysisSchemeRequest> request = null;
        Response<DeleteAnalysisSchemeResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteAnalysisSchemeRequestMarshaller().marshall(deleteAnalysisSchemeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteAnalysisSchemeResultStaxUnmarshaller(), executionContext);
            DeleteAnalysisSchemeResult deleteAnalysisSchemeResult = response.getAwsResponse();
            return deleteAnalysisSchemeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDocumentsResult indexDocuments(IndexDocumentsRequest indexDocumentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(indexDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<IndexDocumentsRequest> request = null;
        Response<IndexDocumentsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new IndexDocumentsRequestMarshaller().marshall(indexDocumentsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new IndexDocumentsResultStaxUnmarshaller(), executionContext);
            IndexDocumentsResult indexDocumentsResult = response.getAwsResponse();
            return indexDocumentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSuggestersResult describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSuggestersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeSuggestersRequest> request = null;
        Response<DescribeSuggestersResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeSuggestersRequestMarshaller().marshall(describeSuggestersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeSuggestersResultStaxUnmarshaller(), executionContext);
            DescribeSuggestersResult describeSuggestersResult = response.getAwsResponse();
            return describeSuggestersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScalingParametersResult updateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateScalingParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateScalingParametersRequest> request = null;
        Response<UpdateScalingParametersResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateScalingParametersRequestMarshaller().marshall(updateScalingParametersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateScalingParametersResultStaxUnmarshaller(), executionContext);
            UpdateScalingParametersResult updateScalingParametersResult = response.getAwsResponse();
            return updateScalingParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainNamesResult listDomainNames(ListDomainNamesRequest listDomainNamesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDomainNamesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListDomainNamesRequest> request = null;
        Response<ListDomainNamesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListDomainNamesRequestMarshaller().marshall(listDomainNamesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListDomainNamesResultStaxUnmarshaller(), executionContext);
            ListDomainNamesResult listDomainNamesResult = response.getAwsResponse();
            return listDomainNamesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineIndexFieldResult defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DefineIndexFieldRequest> request = null;
        Response<DefineIndexFieldResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DefineIndexFieldRequestMarshaller().marshall(defineIndexFieldRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DefineIndexFieldResultStaxUnmarshaller(), executionContext);
            DefineIndexFieldResult defineIndexFieldResult = response.getAwsResponse();
            return defineIndexFieldResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResult createDomain(CreateDomainRequest createDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateDomainRequest> request = null;
        Response<CreateDomainResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateDomainRequestMarshaller().marshall(createDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateDomainResultStaxUnmarshaller(), executionContext);
            CreateDomainResult createDomainResult = response.getAwsResponse();
            return createDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSuggesterResult deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSuggesterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteSuggesterRequest> request = null;
        Response<DeleteSuggesterResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteSuggesterRequestMarshaller().marshall(deleteSuggesterRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteSuggesterResultStaxUnmarshaller(), executionContext);
            DeleteSuggesterResult deleteSuggesterResult = response.getAwsResponse();
            return deleteSuggesterResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExpressionResult deleteExpression(DeleteExpressionRequest deleteExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteExpressionRequest> request = null;
        Response<DeleteExpressionResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteExpressionRequestMarshaller().marshall(deleteExpressionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteExpressionResultStaxUnmarshaller(), executionContext);
            DeleteExpressionResult deleteExpressionResult = response.getAwsResponse();
            return deleteExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAvailabilityOptionsResult describeAvailabilityOptions(DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAvailabilityOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeAvailabilityOptionsRequest> request = null;
        Response<DescribeAvailabilityOptionsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeAvailabilityOptionsRequestMarshaller().marshall(describeAvailabilityOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeAvailabilityOptionsResultStaxUnmarshaller(), executionContext);
            DescribeAvailabilityOptionsResult describeAvailabilityOptionsResult = response.getAwsResponse();
            return describeAvailabilityOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineAnalysisSchemeResult defineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(defineAnalysisSchemeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DefineAnalysisSchemeRequest> request = null;
        Response<DefineAnalysisSchemeResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DefineAnalysisSchemeRequestMarshaller().marshall(defineAnalysisSchemeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DefineAnalysisSchemeResultStaxUnmarshaller(), executionContext);
            DefineAnalysisSchemeResult defineAnalysisSchemeResult = response.getAwsResponse();
            return defineAnalysisSchemeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildSuggestersResult buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(buildSuggestersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<BuildSuggestersRequest> request = null;
        Response<BuildSuggestersResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new BuildSuggestersRequestMarshaller().marshall(buildSuggestersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new BuildSuggestersResultStaxUnmarshaller(), executionContext);
            BuildSuggestersResult buildSuggestersResult = response.getAwsResponse();
            return buildSuggestersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceAccessPoliciesResult describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeServiceAccessPoliciesRequest> request = null;
        Response<DescribeServiceAccessPoliciesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeServiceAccessPoliciesRequestMarshaller().marshall(describeServiceAccessPoliciesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeServiceAccessPoliciesResultStaxUnmarshaller(), executionContext);
            DescribeServiceAccessPoliciesResult describeServiceAccessPoliciesResult = response.getAwsResponse();
            return describeServiceAccessPoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteDomainRequest> request = null;
        Response<DeleteDomainResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteDomainRequestMarshaller().marshall(deleteDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DeleteDomainResultStaxUnmarshaller(), executionContext);
            DeleteDomainResult deleteDomainResult = response.getAwsResponse();
            return deleteDomainResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExpressionsResult describeExpressions(DescribeExpressionsRequest describeExpressionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeExpressionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeExpressionsRequest> request = null;
        Response<DescribeExpressionsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeExpressionsRequestMarshaller().marshall(describeExpressionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeExpressionsResultStaxUnmarshaller(), executionContext);
            DescribeExpressionsResult describeExpressionsResult = response.getAwsResponse();
            return describeExpressionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainsResult describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeDomainsRequest> request = null;
        Response<DescribeDomainsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeDomainsRequestMarshaller().marshall(describeDomainsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeDomainsResultStaxUnmarshaller(), executionContext);
            DescribeDomainsResult describeDomainsResult = response.getAwsResponse();
            return describeDomainsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingParametersResult describeScalingParameters(DescribeScalingParametersRequest describeScalingParametersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeScalingParametersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeScalingParametersRequest> request = null;
        Response<DescribeScalingParametersResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeScalingParametersRequestMarshaller().marshall(describeScalingParametersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeScalingParametersResultStaxUnmarshaller(), executionContext);
            DescribeScalingParametersResult describeScalingParametersResult = response.getAwsResponse();
            return describeScalingParametersResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDomainNamesResult listDomainNames() throws AmazonServiceException, AmazonClientException {
        return this.listDomainNames(new ListDomainNamesRequest());
    }

    @Override
    public DescribeDomainsResult describeDomains() throws AmazonServiceException, AmazonClientException {
        return this.describeDomains(new DescribeDomainsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

