/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DescribeJobRequestMarshaller
implements Marshaller<Request<DescribeJobRequest>, DescribeJobRequest> {
    @Override
    public Request<DescribeJobRequest> marshall(DescribeJobRequest describeJobRequest) {
        if (describeJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeJobRequest> request = new DefaultRequest<DescribeJobRequest>(describeJobRequest, "AmazonGlacier");
        String target = "Glacier.DescribeJob";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", describeJobRequest.getAccountId() == null ? "" : StringUtils.fromString(describeJobRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", describeJobRequest.getVaultName() == null ? "" : StringUtils.fromString(describeJobRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replace("{jobId}", describeJobRequest.getJobId() == null ? "" : StringUtils.fromString(describeJobRequest.getJobId()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length != 2 || nameValuePair[1].isEmpty()) continue;
                request.addParameter(nameValuePair[0], nameValuePair[1]);
            }
        }
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        return request;
    }
}

