/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth.profile;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.profile.internal.AbstractProfilesConfigFileScanner;
import com.amazonaws.auth.profile.internal.Profile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfilesConfigFileWriter {
    private static final Log LOG = LogFactory.getLog(ProfilesConfigFileWriter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToFile(File destination, boolean overwrite, Profile ... profiles) {
        FileWriter writer;
        if (destination.exists() && !overwrite) {
            throw new AmazonClientException("The destination file already exists. Set overwrite=true if you want to clobber the existing content and completely re-write the file.");
        }
        try {
            writer = new FileWriter(destination, false);
        }
        catch (IOException ioe) {
            throw new AmazonClientException("Unable to open the destination file.", ioe);
        }
        try {
            ProfilesConfigFileWriterHelper writerHelper = new ProfilesConfigFileWriterHelper(writer, profiles);
            writerHelper.writeWithoutExistingContent();
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ioe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyOrInsertProfiles(File destination, Profile ... profiles) {
        boolean inPlaceModify = destination.exists();
        File stashLocation = null;
        if (inPlaceModify) {
            boolean stashed = false;
            try {
                stashLocation = new File(destination.getParentFile(), destination.getName() + ".bak." + UUID.randomUUID().toString());
                stashed = destination.renameTo(stashLocation);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("The original credentials file is stashed to loaction (%s).", stashLocation.getAbsolutePath()));
                }
            }
            finally {
                if (!stashed) {
                    throw new AmazonClientException("Failed to stash the existing credentials file before applying the changes.");
                }
            }
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(destination);
            ProfilesConfigFileWriterHelper writerHelper = new ProfilesConfigFileWriterHelper(writer, profiles);
            if (inPlaceModify) {
                Scanner existingContent = new Scanner(stashLocation);
                writerHelper.writeWithExistingContent(existingContent);
            } else {
                writerHelper.writeWithoutExistingContent();
            }
        }
        catch (Exception e) {
            if (inPlaceModify) {
                boolean restored = false;
                try {
                    if (!destination.delete()) {
                        LOG.debug((Object)"Unable to remove the credentials file before restoring the original one.");
                    }
                    restored = stashLocation.renameTo(destination);
                }
                finally {
                    if (!restored) {
                        throw new AmazonClientException("Unable to restore the original credentials file. File content stashed in " + stashLocation.getAbsolutePath());
                    }
                }
            }
            throw new AmazonClientException("Unable to modify the credentials file. (The original file has been restored.)", e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static class ProfilesConfigFileWriterHelper
    extends AbstractProfilesConfigFileScanner {
        private final Writer writer;
        private final Map<String, Profile> newProfiles;
        private final StringBuilder buffer = new StringBuilder();
        private final Map<String, Set<String>> existingProfiles = new HashMap<String, Set<String>>();

        public ProfilesConfigFileWriterHelper(Writer writer, Profile ... newProfiles) {
            LinkedHashMap<String, Profile> newProfilesMap = new LinkedHashMap<String, Profile>();
            for (Profile newProfile : newProfiles) {
                newProfilesMap.put(newProfile.getProfileName(), newProfile);
            }
            this.writer = writer;
            this.newProfiles = newProfilesMap;
        }

        public void writeWithoutExistingContent() {
            this.buffer.setLength(0);
            this.existingProfiles.clear();
            this.run(new Scanner(""));
        }

        public void writeWithExistingContent(Scanner existingContent) {
            this.buffer.setLength(0);
            this.existingProfiles.clear();
            this.run(existingContent);
        }

        protected void onEmptyOrCommentLine(String line) {
            this.buffer(line);
        }

        protected void onProfileStartingLine(String newProfileName, String line) {
            this.existingProfiles.put(newProfileName, new HashSet());
            this.flush();
            this.writeLine(line);
        }

        protected void onProfileEndingLine(String prevProfileName) {
            Profile modifiedProfile = this.newProfiles.get(prevProfileName);
            if (modifiedProfile != null) {
                for (Map.Entry<String, String> entry : modifiedProfile.getProperties().entrySet()) {
                    String propertyKey = entry.getKey();
                    String propertyValue = entry.getValue();
                    if (this.existingProfiles.get(prevProfileName).contains(propertyKey)) continue;
                    this.writeProperty(propertyKey, propertyValue);
                }
            }
            this.flush();
        }

        protected void onProfileProperty(String profileName, String propertyKey, String propertyValue, boolean isSupportedProperty, String line) {
            if (this.existingProfiles.get(profileName) == null) {
                this.existingProfiles.put(profileName, new HashSet());
            }
            this.existingProfiles.get(profileName).add(propertyKey);
            if (!isSupportedProperty) {
                this.writeLine(line);
                return;
            }
            this.flush();
            if (this.newProfiles.containsKey(profileName)) {
                String newValue = this.newProfiles.get(profileName).getPropertyValue(propertyKey);
                if (newValue != null) {
                    this.writeProperty(propertyKey, newValue);
                }
            } else {
                this.writeLine(line);
            }
        }

        protected void onEndOfFile() {
            for (Profile newProfile : this.newProfiles.values()) {
                if (this.existingProfiles.containsKey(newProfile.getProfileName())) continue;
                this.writeProfile(newProfile);
                this.writeLine("");
            }
            try {
                this.writer.flush();
            }
            catch (IOException ioe) {
                throw new AmazonClientException("Unable to write to the target file to persist the profile credentials.", ioe);
            }
        }

        private void writeProfile(Profile profile) {
            this.writeProfileName(profile.getProfileName());
            for (Map.Entry<String, String> entry : profile.getProperties().entrySet()) {
                this.writeProperty(entry.getKey(), entry.getValue());
            }
        }

        private void writeProfileName(String profileName) {
            this.writeLine(String.format("[%s]", profileName));
        }

        private void writeProperty(String propertyKey, String propertyValue) {
            this.writeLine(String.format("%s=%s", propertyKey, propertyValue));
        }

        private void writeLine(String line) {
            this.append(String.format("%s%n", line));
        }

        private void append(String str) {
            try {
                this.writer.append(str);
            }
            catch (IOException ioe) {
                throw new AmazonClientException("Unable to write to the target file to persist the profile credentials.", ioe);
            }
        }

        private void flush() {
            if (this.buffer.length() != 0) {
                this.append(this.buffer.toString());
                this.buffer.setLength(0);
            }
        }

        private void buffer(String line) {
            this.buffer.append(String.format("%s%n", line));
        }
    }
}

