/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticloadbalancing.model.AccessLog;
import com.amazonaws.services.elasticloadbalancing.model.CrossZoneLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.LoadBalancerAttributes;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLoadBalancerAttributesRequestMarshaller
implements Marshaller<Request<ModifyLoadBalancerAttributesRequest>, ModifyLoadBalancerAttributesRequest> {
    @Override
    public Request<ModifyLoadBalancerAttributesRequest> marshall(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        LoadBalancerAttributes loadBalancerAttributesLoadBalancerAttributes;
        if (modifyLoadBalancerAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyLoadBalancerAttributesRequest> request = new DefaultRequest<ModifyLoadBalancerAttributesRequest>(modifyLoadBalancerAttributesRequest, "AmazonElasticLoadBalancing");
        request.addParameter("Action", "ModifyLoadBalancerAttributes");
        request.addParameter("Version", "2012-06-01");
        if (modifyLoadBalancerAttributesRequest.getLoadBalancerName() != null) {
            request.addParameter("LoadBalancerName", StringUtils.fromString(modifyLoadBalancerAttributesRequest.getLoadBalancerName()));
        }
        if ((loadBalancerAttributesLoadBalancerAttributes = modifyLoadBalancerAttributesRequest.getLoadBalancerAttributes()) != null) {
            AccessLog accessLogAccessLog;
            CrossZoneLoadBalancing crossZoneLoadBalancingCrossZoneLoadBalancing = loadBalancerAttributesLoadBalancerAttributes.getCrossZoneLoadBalancing();
            if (crossZoneLoadBalancingCrossZoneLoadBalancing != null && crossZoneLoadBalancingCrossZoneLoadBalancing.isEnabled() != null) {
                request.addParameter("LoadBalancerAttributes.CrossZoneLoadBalancing.Enabled", StringUtils.fromBoolean(crossZoneLoadBalancingCrossZoneLoadBalancing.isEnabled()));
            }
            if ((accessLogAccessLog = loadBalancerAttributesLoadBalancerAttributes.getAccessLog()) != null) {
                if (accessLogAccessLog.isEnabled() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.Enabled", StringUtils.fromBoolean(accessLogAccessLog.isEnabled()));
                }
                if (accessLogAccessLog.getS3BucketName() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketName", StringUtils.fromString(accessLogAccessLog.getS3BucketName()));
                }
                if (accessLogAccessLog.getEmitInterval() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.EmitInterval", StringUtils.fromInteger(accessLogAccessLog.getEmitInterval()));
                }
                if (accessLogAccessLog.getS3BucketPrefix() != null) {
                    request.addParameter("LoadBalancerAttributes.AccessLog.S3BucketPrefix", StringUtils.fromString(accessLogAccessLog.getS3BucketPrefix()));
                }
            }
        }
        return request;
    }
}

