/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventInfoMap
implements Serializable {
    private String eventId;
    private ListWithAutoConstructFlag<String> eventCategories;
    private String eventDescription;
    private String severity;

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public EventInfoMap withEventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    public List<String> getEventCategories() {
        if (this.eventCategories == null) {
            this.eventCategories = new ListWithAutoConstructFlag();
            this.eventCategories.setAutoConstruct(true);
        }
        return this.eventCategories;
    }

    public void setEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
            return;
        }
        ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
        eventCategoriesCopy.addAll(eventCategories);
        this.eventCategories = eventCategoriesCopy;
    }

    public EventInfoMap withEventCategories(String ... eventCategories) {
        if (this.getEventCategories() == null) {
            this.setEventCategories(new ArrayList<String>(eventCategories.length));
        }
        for (String value : eventCategories) {
            this.getEventCategories().add(value);
        }
        return this;
    }

    public EventInfoMap withEventCategories(Collection<String> eventCategories) {
        if (eventCategories == null) {
            this.eventCategories = null;
        } else {
            ListWithAutoConstructFlag eventCategoriesCopy = new ListWithAutoConstructFlag(eventCategories.size());
            eventCategoriesCopy.addAll(eventCategories);
            this.eventCategories = eventCategoriesCopy;
        }
        return this;
    }

    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    public EventInfoMap withEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
        return this;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public EventInfoMap withSeverity(String severity) {
        this.severity = severity;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: " + this.getEventId() + ",");
        }
        if (this.getEventCategories() != null) {
            sb.append("EventCategories: " + this.getEventCategories() + ",");
        }
        if (this.getEventDescription() != null) {
            sb.append("EventDescription: " + this.getEventDescription() + ",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: " + this.getSeverity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventCategories() == null ? 0 : ((Object)this.getEventCategories()).hashCode());
        hashCode = 31 * hashCode + (this.getEventDescription() == null ? 0 : this.getEventDescription().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventInfoMap)) {
            return false;
        }
        EventInfoMap other = (EventInfoMap)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventCategories() == null ^ this.getEventCategories() == null) {
            return false;
        }
        if (other.getEventCategories() != null && !((Object)other.getEventCategories()).equals(this.getEventCategories())) {
            return false;
        }
        if (other.getEventDescription() == null ^ this.getEventDescription() == null) {
            return false;
        }
        if (other.getEventDescription() != null && !other.getEventDescription().equals(this.getEventDescription())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        return other.getSeverity() == null || other.getSeverity().equals(this.getSeverity());
    }
}

