/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.Preset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPresetsResult
implements Serializable {
    private ListWithAutoConstructFlag<Preset> presets;
    private String nextPageToken;

    public List<Preset> getPresets() {
        if (this.presets == null) {
            this.presets = new ListWithAutoConstructFlag();
            this.presets.setAutoConstruct(true);
        }
        return this.presets;
    }

    public void setPresets(Collection<Preset> presets) {
        if (presets == null) {
            this.presets = null;
            return;
        }
        ListWithAutoConstructFlag presetsCopy = new ListWithAutoConstructFlag(presets.size());
        presetsCopy.addAll(presets);
        this.presets = presetsCopy;
    }

    public ListPresetsResult withPresets(Preset ... presets) {
        if (this.getPresets() == null) {
            this.setPresets(new ArrayList<Preset>(presets.length));
        }
        for (Preset value : presets) {
            this.getPresets().add(value);
        }
        return this;
    }

    public ListPresetsResult withPresets(Collection<Preset> presets) {
        if (presets == null) {
            this.presets = null;
        } else {
            ListWithAutoConstructFlag presetsCopy = new ListWithAutoConstructFlag(presets.size());
            presetsCopy.addAll(presets);
            this.presets = presetsCopy;
        }
        return this;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public ListPresetsResult withNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPresets() != null) {
            sb.append("Presets: " + this.getPresets() + ",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: " + this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPresets() == null ? 0 : ((Object)this.getPresets()).hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPresetsResult)) {
            return false;
        }
        ListPresetsResult other = (ListPresetsResult)obj;
        if (other.getPresets() == null ^ this.getPresets() == null) {
            return false;
        }
        if (other.getPresets() != null && !((Object)other.getPresets()).equals(this.getPresets())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }
}

