/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.ClusterState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListClustersRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Date createdAfter;
    private Date createdBefore;
    private ListWithAutoConstructFlag<String> clusterStates;
    private String marker;

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public ListClustersRequest withCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public ListClustersRequest withCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public List<String> getClusterStates() {
        if (this.clusterStates == null) {
            this.clusterStates = new ListWithAutoConstructFlag();
            this.clusterStates.setAutoConstruct(true);
        }
        return this.clusterStates;
    }

    public void setClusterStates(Collection<String> clusterStates) {
        if (clusterStates == null) {
            this.clusterStates = null;
            return;
        }
        ListWithAutoConstructFlag clusterStatesCopy = new ListWithAutoConstructFlag(clusterStates.size());
        clusterStatesCopy.addAll(clusterStates);
        this.clusterStates = clusterStatesCopy;
    }

    public ListClustersRequest withClusterStates(String ... clusterStates) {
        if (this.getClusterStates() == null) {
            this.setClusterStates(new ArrayList<String>(clusterStates.length));
        }
        for (String value : clusterStates) {
            this.getClusterStates().add(value);
        }
        return this;
    }

    public ListClustersRequest withClusterStates(Collection<String> clusterStates) {
        if (clusterStates == null) {
            this.clusterStates = null;
        } else {
            ListWithAutoConstructFlag clusterStatesCopy = new ListWithAutoConstructFlag(clusterStates.size());
            clusterStatesCopy.addAll(clusterStates);
            this.clusterStates = clusterStatesCopy;
        }
        return this;
    }

    public ListClustersRequest withClusterStates(ClusterState ... clusterStates) {
        ArrayList<String> clusterStatesCopy = new ArrayList<String>(clusterStates.length);
        for (ClusterState member : clusterStates) {
            clusterStatesCopy.add(member.toString());
        }
        if (this.getClusterStates() == null) {
            this.setClusterStates(clusterStatesCopy);
        } else {
            this.getClusterStates().addAll(clusterStatesCopy);
        }
        return this;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public ListClustersRequest withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedAfter() != null) {
            sb.append("CreatedAfter: " + this.getCreatedAfter() + ",");
        }
        if (this.getCreatedBefore() != null) {
            sb.append("CreatedBefore: " + this.getCreatedBefore() + ",");
        }
        if (this.getClusterStates() != null) {
            sb.append("ClusterStates: " + this.getClusterStates() + ",");
        }
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedAfter() == null ? 0 : this.getCreatedAfter().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBefore() == null ? 0 : this.getCreatedBefore().hashCode());
        hashCode = 31 * hashCode + (this.getClusterStates() == null ? 0 : ((Object)this.getClusterStates()).hashCode());
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)obj;
        if (other.getCreatedAfter() == null ^ this.getCreatedAfter() == null) {
            return false;
        }
        if (other.getCreatedAfter() != null && !other.getCreatedAfter().equals(this.getCreatedAfter())) {
            return false;
        }
        if (other.getCreatedBefore() == null ^ this.getCreatedBefore() == null) {
            return false;
        }
        if (other.getCreatedBefore() != null && !other.getCreatedBefore().equals(this.getCreatedBefore())) {
            return false;
        }
        if (other.getClusterStates() == null ^ this.getClusterStates() == null) {
            return false;
        }
        if (other.getClusterStates() != null && !((Object)other.getClusterStates()).equals(this.getClusterStates())) {
            return false;
        }
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        return other.getMarker() == null || other.getMarker().equals(this.getMarker());
    }
}

