/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticache.model.Snapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeSnapshotsResult
implements Serializable {
    private String marker;
    private ListWithAutoConstructFlag<Snapshot> snapshots;

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public DescribeSnapshotsResult withMarker(String marker) {
        this.marker = marker;
        return this;
    }

    public List<Snapshot> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new ListWithAutoConstructFlag();
            this.snapshots.setAutoConstruct(true);
        }
        return this.snapshots;
    }

    public void setSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        ListWithAutoConstructFlag snapshotsCopy = new ListWithAutoConstructFlag(snapshots.size());
        snapshotsCopy.addAll(snapshots);
        this.snapshots = snapshotsCopy;
    }

    public DescribeSnapshotsResult withSnapshots(Snapshot ... snapshots) {
        if (this.getSnapshots() == null) {
            this.setSnapshots(new ArrayList<Snapshot>(snapshots.length));
        }
        for (Snapshot value : snapshots) {
            this.getSnapshots().add(value);
        }
        return this;
    }

    public DescribeSnapshotsResult withSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
        } else {
            ListWithAutoConstructFlag snapshotsCopy = new ListWithAutoConstructFlag(snapshots.size());
            snapshotsCopy.addAll(snapshots);
            this.snapshots = snapshotsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: " + this.getMarker() + ",");
        }
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: " + this.getSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : ((Object)this.getSnapshots()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsResult)) {
            return false;
        }
        DescribeSnapshotsResult other = (DescribeSnapshotsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        return other.getSnapshots() == null || ((Object)other.getSnapshots()).equals(this.getSnapshots());
    }
}

