/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.AvailabilityZoneMessage;
import com.amazonaws.services.ec2.model.AvailabilityZoneState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailabilityZone
implements Serializable {
    private String zoneName;
    private String state;
    private String regionName;
    private ListWithAutoConstructFlag<AvailabilityZoneMessage> messages;

    public String getZoneName() {
        return this.zoneName;
    }

    public void setZoneName(String zoneName) {
        this.zoneName = zoneName;
    }

    public AvailabilityZone withZoneName(String zoneName) {
        this.zoneName = zoneName;
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public AvailabilityZone withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(AvailabilityZoneState state) {
        this.state = state.toString();
    }

    public AvailabilityZone withState(AvailabilityZoneState state) {
        this.state = state.toString();
        return this;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public AvailabilityZone withRegionName(String regionName) {
        this.regionName = regionName;
        return this;
    }

    public List<AvailabilityZoneMessage> getMessages() {
        if (this.messages == null) {
            this.messages = new ListWithAutoConstructFlag();
            this.messages.setAutoConstruct(true);
        }
        return this.messages;
    }

    public void setMessages(Collection<AvailabilityZoneMessage> messages) {
        if (messages == null) {
            this.messages = null;
            return;
        }
        ListWithAutoConstructFlag messagesCopy = new ListWithAutoConstructFlag(messages.size());
        messagesCopy.addAll(messages);
        this.messages = messagesCopy;
    }

    public AvailabilityZone withMessages(AvailabilityZoneMessage ... messages) {
        if (this.getMessages() == null) {
            this.setMessages(new ArrayList<AvailabilityZoneMessage>(messages.length));
        }
        for (AvailabilityZoneMessage value : messages) {
            this.getMessages().add(value);
        }
        return this;
    }

    public AvailabilityZone withMessages(Collection<AvailabilityZoneMessage> messages) {
        if (messages == null) {
            this.messages = null;
        } else {
            ListWithAutoConstructFlag messagesCopy = new ListWithAutoConstructFlag(messages.size());
            messagesCopy.addAll(messages);
            this.messages = messagesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getZoneName() != null) {
            sb.append("ZoneName: " + this.getZoneName() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getRegionName() != null) {
            sb.append("RegionName: " + this.getRegionName() + ",");
        }
        if (this.getMessages() != null) {
            sb.append("Messages: " + this.getMessages());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getZoneName() == null ? 0 : this.getZoneName().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getRegionName() == null ? 0 : this.getRegionName().hashCode());
        hashCode = 31 * hashCode + (this.getMessages() == null ? 0 : ((Object)this.getMessages()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone)obj;
        if (other.getZoneName() == null ^ this.getZoneName() == null) {
            return false;
        }
        if (other.getZoneName() != null && !other.getZoneName().equals(this.getZoneName())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getRegionName() == null ^ this.getRegionName() == null) {
            return false;
        }
        if (other.getRegionName() != null && !other.getRegionName().equals(this.getRegionName())) {
            return false;
        }
        if (other.getMessages() == null ^ this.getMessages() == null) {
            return false;
        }
        return other.getMessages() == null || ((Object)other.getMessages()).equals(this.getMessages());
    }
}

