/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableDescription
implements Serializable {
    private ListWithAutoConstructFlag<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private String tableStatus;
    private Date creationDateTime;
    private ProvisionedThroughputDescription provisionedThroughput;
    private Long tableSizeBytes;
    private Long itemCount;
    private ListWithAutoConstructFlag<LocalSecondaryIndexDescription> localSecondaryIndexes;
    private ListWithAutoConstructFlag<GlobalSecondaryIndexDescription> globalSecondaryIndexes;

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag attributeDefinitionsCopy = new ListWithAutoConstructFlag(attributeDefinitions.size());
        attributeDefinitionsCopy.addAll(attributeDefinitions);
        this.attributeDefinitions = attributeDefinitionsCopy;
    }

    public TableDescription withAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        if (this.getAttributeDefinitions() == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitions.length));
        }
        for (AttributeDefinition value : attributeDefinitions) {
            this.getAttributeDefinitions().add(value);
        }
        return this;
    }

    public TableDescription withAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
        } else {
            ListWithAutoConstructFlag attributeDefinitionsCopy = new ListWithAutoConstructFlag(attributeDefinitions.size());
            attributeDefinitionsCopy.addAll(attributeDefinitions);
            this.attributeDefinitions = attributeDefinitionsCopy;
        }
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TableDescription withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
        keySchemaCopy.addAll(keySchema);
        this.keySchema = keySchemaCopy;
    }

    public TableDescription withKeySchema(KeySchemaElement ... keySchema) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement value : keySchema) {
            this.getKeySchema().add(value);
        }
        return this;
    }

    public TableDescription withKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
            keySchemaCopy.addAll(keySchema);
            this.keySchema = keySchemaCopy;
        }
        return this;
    }

    public String getTableStatus() {
        return this.tableStatus;
    }

    public void setTableStatus(String tableStatus) {
        this.tableStatus = tableStatus;
    }

    public TableDescription withTableStatus(String tableStatus) {
        this.tableStatus = tableStatus;
        return this;
    }

    public void setTableStatus(TableStatus tableStatus) {
        this.tableStatus = tableStatus.toString();
    }

    public TableDescription withTableStatus(TableStatus tableStatus) {
        this.tableStatus = tableStatus.toString();
        return this;
    }

    public Date getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public TableDescription withCreationDateTime(Date creationDateTime) {
        this.creationDateTime = creationDateTime;
        return this;
    }

    public ProvisionedThroughputDescription getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public TableDescription withProvisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
        return this;
    }

    public Long getTableSizeBytes() {
        return this.tableSizeBytes;
    }

    public void setTableSizeBytes(Long tableSizeBytes) {
        this.tableSizeBytes = tableSizeBytes;
    }

    public TableDescription withTableSizeBytes(Long tableSizeBytes) {
        this.tableSizeBytes = tableSizeBytes;
        return this;
    }

    public Long getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(Long itemCount) {
        this.itemCount = itemCount;
    }

    public TableDescription withItemCount(Long itemCount) {
        this.itemCount = itemCount;
        return this;
    }

    public List<LocalSecondaryIndexDescription> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
        if (localSecondaryIndexes == null) {
            this.localSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag localSecondaryIndexesCopy = new ListWithAutoConstructFlag(localSecondaryIndexes.size());
        localSecondaryIndexesCopy.addAll(localSecondaryIndexes);
        this.localSecondaryIndexes = localSecondaryIndexesCopy;
    }

    public TableDescription withLocalSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexes) {
        if (this.getLocalSecondaryIndexes() == null) {
            this.setLocalSecondaryIndexes(new ArrayList<LocalSecondaryIndexDescription>(localSecondaryIndexes.length));
        }
        for (LocalSecondaryIndexDescription value : localSecondaryIndexes) {
            this.getLocalSecondaryIndexes().add(value);
        }
        return this;
    }

    public TableDescription withLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
        if (localSecondaryIndexes == null) {
            this.localSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag localSecondaryIndexesCopy = new ListWithAutoConstructFlag(localSecondaryIndexes.size());
            localSecondaryIndexesCopy.addAll(localSecondaryIndexes);
            this.localSecondaryIndexes = localSecondaryIndexesCopy;
        }
        return this;
    }

    public List<GlobalSecondaryIndexDescription> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
        if (globalSecondaryIndexes == null) {
            this.globalSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag globalSecondaryIndexesCopy = new ListWithAutoConstructFlag(globalSecondaryIndexes.size());
        globalSecondaryIndexesCopy.addAll(globalSecondaryIndexes);
        this.globalSecondaryIndexes = globalSecondaryIndexesCopy;
    }

    public TableDescription withGlobalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
        if (this.getGlobalSecondaryIndexes() == null) {
            this.setGlobalSecondaryIndexes(new ArrayList<GlobalSecondaryIndexDescription>(globalSecondaryIndexes.length));
        }
        for (GlobalSecondaryIndexDescription value : globalSecondaryIndexes) {
            this.getGlobalSecondaryIndexes().add(value);
        }
        return this;
    }

    public TableDescription withGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
        if (globalSecondaryIndexes == null) {
            this.globalSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag globalSecondaryIndexesCopy = new ListWithAutoConstructFlag(globalSecondaryIndexes.size());
            globalSecondaryIndexesCopy.addAll(globalSecondaryIndexes);
            this.globalSecondaryIndexes = globalSecondaryIndexesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeDefinitions() != null) {
            sb.append("AttributeDefinitions: " + this.getAttributeDefinitions() + ",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getTableStatus() != null) {
            sb.append("TableStatus: " + this.getTableStatus() + ",");
        }
        if (this.getCreationDateTime() != null) {
            sb.append("CreationDateTime: " + this.getCreationDateTime() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: " + this.getProvisionedThroughput() + ",");
        }
        if (this.getTableSizeBytes() != null) {
            sb.append("TableSizeBytes: " + this.getTableSizeBytes() + ",");
        }
        if (this.getItemCount() != null) {
            sb.append("ItemCount: " + this.getItemCount() + ",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: " + this.getLocalSecondaryIndexes() + ",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: " + this.getGlobalSecondaryIndexes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeDefinitions() == null ? 0 : ((Object)this.getAttributeDefinitions()).hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : ((Object)this.getKeySchema()).hashCode());
        hashCode = 31 * hashCode + (this.getTableStatus() == null ? 0 : this.getTableStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDateTime() == null ? 0 : this.getCreationDateTime().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        hashCode = 31 * hashCode + (this.getTableSizeBytes() == null ? 0 : this.getTableSizeBytes().hashCode());
        hashCode = 31 * hashCode + (this.getItemCount() == null ? 0 : this.getItemCount().hashCode());
        hashCode = 31 * hashCode + (this.getLocalSecondaryIndexes() == null ? 0 : ((Object)this.getLocalSecondaryIndexes()).hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexes() == null ? 0 : ((Object)this.getGlobalSecondaryIndexes()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDescription)) {
            return false;
        }
        TableDescription other = (TableDescription)obj;
        if (other.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (other.getAttributeDefinitions() != null && !((Object)other.getAttributeDefinitions()).equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !((Object)other.getKeySchema()).equals(this.getKeySchema())) {
            return false;
        }
        if (other.getTableStatus() == null ^ this.getTableStatus() == null) {
            return false;
        }
        if (other.getTableStatus() != null && !other.getTableStatus().equals(this.getTableStatus())) {
            return false;
        }
        if (other.getCreationDateTime() == null ^ this.getCreationDateTime() == null) {
            return false;
        }
        if (other.getCreationDateTime() != null && !other.getCreationDateTime().equals(this.getCreationDateTime())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        if (other.getProvisionedThroughput() != null && !other.getProvisionedThroughput().equals(this.getProvisionedThroughput())) {
            return false;
        }
        if (other.getTableSizeBytes() == null ^ this.getTableSizeBytes() == null) {
            return false;
        }
        if (other.getTableSizeBytes() != null && !other.getTableSizeBytes().equals(this.getTableSizeBytes())) {
            return false;
        }
        if (other.getItemCount() == null ^ this.getItemCount() == null) {
            return false;
        }
        if (other.getItemCount() != null && !other.getItemCount().equals(this.getItemCount())) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() != null && !((Object)other.getLocalSecondaryIndexes()).equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        return other.getGlobalSecondaryIndexes() == null || ((Object)other.getGlobalSecondaryIndexes()).equals(this.getGlobalSecondaryIndexes());
    }
}

