/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.DeprecateWorkflowTypeRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecateWorkflowTypeRequestMarshaller
implements Marshaller<Request<DeprecateWorkflowTypeRequest>, DeprecateWorkflowTypeRequest> {
    @Override
    public Request<DeprecateWorkflowTypeRequest> marshall(DeprecateWorkflowTypeRequest deprecateWorkflowTypeRequest) {
        if (deprecateWorkflowTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeprecateWorkflowTypeRequest> request = new DefaultRequest<DeprecateWorkflowTypeRequest>(deprecateWorkflowTypeRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.DeprecateWorkflowType";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            WorkflowType workflowType;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deprecateWorkflowTypeRequest.getDomain() != null) {
                jsonWriter.key("domain").value(deprecateWorkflowTypeRequest.getDomain());
            }
            if ((workflowType = deprecateWorkflowTypeRequest.getWorkflowType()) != null) {
                jsonWriter.key("workflowType");
                jsonWriter.object();
                if (workflowType.getName() != null) {
                    jsonWriter.key("name").value(workflowType.getName());
                }
                if (workflowType.getVersion() != null) {
                    jsonWriter.key("version").value(workflowType.getVersion());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

