/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import com.amazonaws.services.simpleworkflow.model.DeprecateActivityTypeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeprecateActivityTypeRequestMarshaller
implements Marshaller<Request<DeprecateActivityTypeRequest>, DeprecateActivityTypeRequest> {
    @Override
    public Request<DeprecateActivityTypeRequest> marshall(DeprecateActivityTypeRequest deprecateActivityTypeRequest) {
        if (deprecateActivityTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeprecateActivityTypeRequest> request = new DefaultRequest<DeprecateActivityTypeRequest>(deprecateActivityTypeRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.DeprecateActivityType";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ActivityType activityType;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (deprecateActivityTypeRequest.getDomain() != null) {
                jsonWriter.key("domain").value(deprecateActivityTypeRequest.getDomain());
            }
            if ((activityType = deprecateActivityTypeRequest.getActivityType()) != null) {
                jsonWriter.key("activityType");
                jsonWriter.object();
                if (activityType.getName() != null) {
                    jsonWriter.key("name").value(activityType.getName());
                }
                if (activityType.getVersion() != null) {
                    jsonWriter.key("version").value(activityType.getVersion());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

