/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.CurrencyCodeValues;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.OfferingTypeValues;
import com.amazonaws.services.ec2.model.RIProductDescription;
import com.amazonaws.services.ec2.model.RecurringCharge;
import com.amazonaws.services.ec2.model.ReservedInstanceState;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.Tenancy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReservedInstances
implements Serializable {
    private String reservedInstancesId;
    private String instanceType;
    private String availabilityZone;
    private Date start;
    private Date end;
    private Long duration;
    private Float usagePrice;
    private Float fixedPrice;
    private Integer instanceCount;
    private String productDescription;
    private String state;
    private ListWithAutoConstructFlag<Tag> tags;
    private String instanceTenancy;
    private String currencyCode;
    private String offeringType;
    private ListWithAutoConstructFlag<RecurringCharge> recurringCharges;

    public String getReservedInstancesId() {
        return this.reservedInstancesId;
    }

    public void setReservedInstancesId(String reservedInstancesId) {
        this.reservedInstancesId = reservedInstancesId;
    }

    public ReservedInstances withReservedInstancesId(String reservedInstancesId) {
        this.reservedInstancesId = reservedInstancesId;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public ReservedInstances withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
    }

    public ReservedInstances withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public ReservedInstances withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public ReservedInstances withStart(Date start) {
        this.start = start;
        return this;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public ReservedInstances withEnd(Date end) {
        this.end = end;
        return this;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public ReservedInstances withDuration(Long duration) {
        this.duration = duration;
        return this;
    }

    public Float getUsagePrice() {
        return this.usagePrice;
    }

    public void setUsagePrice(Float usagePrice) {
        this.usagePrice = usagePrice;
    }

    public ReservedInstances withUsagePrice(Float usagePrice) {
        this.usagePrice = usagePrice;
        return this;
    }

    public Float getFixedPrice() {
        return this.fixedPrice;
    }

    public void setFixedPrice(Float fixedPrice) {
        this.fixedPrice = fixedPrice;
    }

    public ReservedInstances withFixedPrice(Float fixedPrice) {
        this.fixedPrice = fixedPrice;
        return this;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public ReservedInstances withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public String getProductDescription() {
        return this.productDescription;
    }

    public void setProductDescription(String productDescription) {
        this.productDescription = productDescription;
    }

    public ReservedInstances withProductDescription(String productDescription) {
        this.productDescription = productDescription;
        return this;
    }

    public void setProductDescription(RIProductDescription productDescription) {
        this.productDescription = productDescription.toString();
    }

    public ReservedInstances withProductDescription(RIProductDescription productDescription) {
        this.productDescription = productDescription.toString();
        return this;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ReservedInstances withState(String state) {
        this.state = state;
        return this;
    }

    public void setState(ReservedInstanceState state) {
        this.state = state.toString();
    }

    public ReservedInstances withState(ReservedInstanceState state) {
        this.state = state.toString();
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public ReservedInstances withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public ReservedInstances withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String getInstanceTenancy() {
        return this.instanceTenancy;
    }

    public void setInstanceTenancy(String instanceTenancy) {
        this.instanceTenancy = instanceTenancy;
    }

    public ReservedInstances withInstanceTenancy(String instanceTenancy) {
        this.instanceTenancy = instanceTenancy;
        return this;
    }

    public void setInstanceTenancy(Tenancy instanceTenancy) {
        this.instanceTenancy = instanceTenancy.toString();
    }

    public ReservedInstances withInstanceTenancy(Tenancy instanceTenancy) {
        this.instanceTenancy = instanceTenancy.toString();
        return this;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public ReservedInstances withCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
        return this;
    }

    public void setCurrencyCode(CurrencyCodeValues currencyCode) {
        this.currencyCode = currencyCode.toString();
    }

    public ReservedInstances withCurrencyCode(CurrencyCodeValues currencyCode) {
        this.currencyCode = currencyCode.toString();
        return this;
    }

    public String getOfferingType() {
        return this.offeringType;
    }

    public void setOfferingType(String offeringType) {
        this.offeringType = offeringType;
    }

    public ReservedInstances withOfferingType(String offeringType) {
        this.offeringType = offeringType;
        return this;
    }

    public void setOfferingType(OfferingTypeValues offeringType) {
        this.offeringType = offeringType.toString();
    }

    public ReservedInstances withOfferingType(OfferingTypeValues offeringType) {
        this.offeringType = offeringType.toString();
        return this;
    }

    public List<RecurringCharge> getRecurringCharges() {
        if (this.recurringCharges == null) {
            this.recurringCharges = new ListWithAutoConstructFlag();
            this.recurringCharges.setAutoConstruct(true);
        }
        return this.recurringCharges;
    }

    public void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
        if (recurringCharges == null) {
            this.recurringCharges = null;
            return;
        }
        ListWithAutoConstructFlag recurringChargesCopy = new ListWithAutoConstructFlag(recurringCharges.size());
        recurringChargesCopy.addAll(recurringCharges);
        this.recurringCharges = recurringChargesCopy;
    }

    public ReservedInstances withRecurringCharges(RecurringCharge ... recurringCharges) {
        if (this.getRecurringCharges() == null) {
            this.setRecurringCharges(new ArrayList<RecurringCharge>(recurringCharges.length));
        }
        for (RecurringCharge value : recurringCharges) {
            this.getRecurringCharges().add(value);
        }
        return this;
    }

    public ReservedInstances withRecurringCharges(Collection<RecurringCharge> recurringCharges) {
        if (recurringCharges == null) {
            this.recurringCharges = null;
        } else {
            ListWithAutoConstructFlag recurringChargesCopy = new ListWithAutoConstructFlag(recurringCharges.size());
            recurringChargesCopy.addAll(recurringCharges);
            this.recurringCharges = recurringChargesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstancesId() != null) {
            sb.append("ReservedInstancesId: " + this.getReservedInstancesId() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: " + this.getAvailabilityZone() + ",");
        }
        if (this.getStart() != null) {
            sb.append("Start: " + this.getStart() + ",");
        }
        if (this.getEnd() != null) {
            sb.append("End: " + this.getEnd() + ",");
        }
        if (this.getDuration() != null) {
            sb.append("Duration: " + this.getDuration() + ",");
        }
        if (this.getUsagePrice() != null) {
            sb.append("UsagePrice: " + this.getUsagePrice() + ",");
        }
        if (this.getFixedPrice() != null) {
            sb.append("FixedPrice: " + this.getFixedPrice() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getProductDescription() != null) {
            sb.append("ProductDescription: " + this.getProductDescription() + ",");
        }
        if (this.getState() != null) {
            sb.append("State: " + this.getState() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ",");
        }
        if (this.getInstanceTenancy() != null) {
            sb.append("InstanceTenancy: " + this.getInstanceTenancy() + ",");
        }
        if (this.getCurrencyCode() != null) {
            sb.append("CurrencyCode: " + this.getCurrencyCode() + ",");
        }
        if (this.getOfferingType() != null) {
            sb.append("OfferingType: " + this.getOfferingType() + ",");
        }
        if (this.getRecurringCharges() != null) {
            sb.append("RecurringCharges: " + this.getRecurringCharges());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstancesId() == null ? 0 : this.getReservedInstancesId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getStart() == null ? 0 : this.getStart().hashCode());
        hashCode = 31 * hashCode + (this.getEnd() == null ? 0 : this.getEnd().hashCode());
        hashCode = 31 * hashCode + (this.getDuration() == null ? 0 : this.getDuration().hashCode());
        hashCode = 31 * hashCode + (this.getUsagePrice() == null ? 0 : this.getUsagePrice().hashCode());
        hashCode = 31 * hashCode + (this.getFixedPrice() == null ? 0 : this.getFixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getProductDescription() == null ? 0 : this.getProductDescription().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTenancy() == null ? 0 : this.getInstanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.getCurrencyCode() == null ? 0 : this.getCurrencyCode().hashCode());
        hashCode = 31 * hashCode + (this.getOfferingType() == null ? 0 : this.getOfferingType().hashCode());
        hashCode = 31 * hashCode + (this.getRecurringCharges() == null ? 0 : this.getRecurringCharges().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstances)) {
            return false;
        }
        ReservedInstances other = (ReservedInstances)obj;
        if (other.getReservedInstancesId() == null ^ this.getReservedInstancesId() == null) {
            return false;
        }
        if (other.getReservedInstancesId() != null && !other.getReservedInstancesId().equals(this.getReservedInstancesId())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getStart() == null ^ this.getStart() == null) {
            return false;
        }
        if (other.getStart() != null && !other.getStart().equals(this.getStart())) {
            return false;
        }
        if (other.getEnd() == null ^ this.getEnd() == null) {
            return false;
        }
        if (other.getEnd() != null && !other.getEnd().equals(this.getEnd())) {
            return false;
        }
        if (other.getDuration() == null ^ this.getDuration() == null) {
            return false;
        }
        if (other.getDuration() != null && !other.getDuration().equals(this.getDuration())) {
            return false;
        }
        if (other.getUsagePrice() == null ^ this.getUsagePrice() == null) {
            return false;
        }
        if (other.getUsagePrice() != null && !other.getUsagePrice().equals(this.getUsagePrice())) {
            return false;
        }
        if (other.getFixedPrice() == null ^ this.getFixedPrice() == null) {
            return false;
        }
        if (other.getFixedPrice() != null && !other.getFixedPrice().equals(this.getFixedPrice())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getProductDescription() == null ^ this.getProductDescription() == null) {
            return false;
        }
        if (other.getProductDescription() != null && !other.getProductDescription().equals(this.getProductDescription())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getInstanceTenancy() == null ^ this.getInstanceTenancy() == null) {
            return false;
        }
        if (other.getInstanceTenancy() != null && !other.getInstanceTenancy().equals(this.getInstanceTenancy())) {
            return false;
        }
        if (other.getCurrencyCode() == null ^ this.getCurrencyCode() == null) {
            return false;
        }
        if (other.getCurrencyCode() != null && !other.getCurrencyCode().equals(this.getCurrencyCode())) {
            return false;
        }
        if (other.getOfferingType() == null ^ this.getOfferingType() == null) {
            return false;
        }
        if (other.getOfferingType() != null && !other.getOfferingType().equals(this.getOfferingType())) {
            return false;
        }
        if (other.getRecurringCharges() == null ^ this.getRecurringCharges() == null) {
            return false;
        }
        return other.getRecurringCharges() == null || other.getRecurringCharges().equals(this.getRecurringCharges());
    }
}

