/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import com.amazonaws.services.dynamodbv2.model.TableStatus;

public class Tables {
    private static final int DEFAULT_WAIT_TIMEOUT = 600000;
    private static final int DEFAULT_WAIT_INTERVAL = 20000;

    public static boolean doesTableExist(AmazonDynamoDB dynamo, String tableName) {
        try {
            TableDescription table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
            return TableStatus.ACTIVE.toString().equals(table.getTableStatus());
        }
        catch (ResourceNotFoundException rnfe) {
            return false;
        }
    }

    public static void waitForTableToBecomeActive(AmazonDynamoDB dynamo, String tableName) {
        Tables.waitForTableToBecomeActive(dynamo, tableName, 600000, 20000);
    }

    public static void waitForTableToBecomeActive(AmazonDynamoDB dynamo, String tableName, int timeout, int interval) {
        if (timeout < 0) {
            throw new AmazonClientException("Timeout must be >= 0");
        }
        if (interval <= 0 || interval >= timeout) {
            throw new AmazonClientException("Interval must be > 0 and < timeout");
        }
        long startTime = System.currentTimeMillis();
        long endTime = startTime + (long)timeout;
        while (System.currentTimeMillis() < endTime) {
            try {
                TableDescription table = dynamo.describeTable(new DescribeTableRequest(tableName)).getTable();
                if (table != null && table.getTableStatus().equals(TableStatus.ACTIVE.toString())) {
                    return;
                }
            }
            catch (ResourceNotFoundException table) {
                // empty catch block
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw new AmazonClientException("Interrupted while waiting for table to become active", e);
            }
        }
        throw new AmazonClientException("Table " + tableName + " never became active");
    }
}

