/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.NewPrivateVirtualInterface;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreatePrivateVirtualInterfaceRequestMarshaller
implements Marshaller<Request<CreatePrivateVirtualInterfaceRequest>, CreatePrivateVirtualInterfaceRequest> {
    @Override
    public Request<CreatePrivateVirtualInterfaceRequest> marshall(CreatePrivateVirtualInterfaceRequest createPrivateVirtualInterfaceRequest) {
        if (createPrivateVirtualInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreatePrivateVirtualInterfaceRequest> request = new DefaultRequest<CreatePrivateVirtualInterfaceRequest>(createPrivateVirtualInterfaceRequest, "AmazonDirectConnect");
        String target = "OvertureService.CreatePrivateVirtualInterface";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            NewPrivateVirtualInterface newPrivateVirtualInterface;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createPrivateVirtualInterfaceRequest.getConnectionId() != null) {
                jsonWriter.key("connectionId").value(createPrivateVirtualInterfaceRequest.getConnectionId());
            }
            if ((newPrivateVirtualInterface = createPrivateVirtualInterfaceRequest.getNewPrivateVirtualInterface()) != null) {
                jsonWriter.key("newPrivateVirtualInterface");
                jsonWriter.object();
                if (newPrivateVirtualInterface.getVirtualInterfaceName() != null) {
                    jsonWriter.key("virtualInterfaceName").value(newPrivateVirtualInterface.getVirtualInterfaceName());
                }
                if (newPrivateVirtualInterface.getVlan() != null) {
                    jsonWriter.key("vlan").value(newPrivateVirtualInterface.getVlan());
                }
                if (newPrivateVirtualInterface.getAsn() != null) {
                    jsonWriter.key("asn").value(newPrivateVirtualInterface.getAsn());
                }
                if (newPrivateVirtualInterface.getAuthKey() != null) {
                    jsonWriter.key("authKey").value(newPrivateVirtualInterface.getAuthKey());
                }
                if (newPrivateVirtualInterface.getAmazonAddress() != null) {
                    jsonWriter.key("amazonAddress").value(newPrivateVirtualInterface.getAmazonAddress());
                }
                if (newPrivateVirtualInterface.getCustomerAddress() != null) {
                    jsonWriter.key("customerAddress").value(newPrivateVirtualInterface.getCustomerAddress());
                }
                if (newPrivateVirtualInterface.getVirtualGatewayId() != null) {
                    jsonWriter.key("virtualGatewayId").value(newPrivateVirtualInterface.getVirtualGatewayId());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

