/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.auth.PEMObject;
import com.amazonaws.auth.RSA;
import com.amazonaws.util.Base64;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum PEM {

    private static final String BEGIN_MARKER = "-----BEGIN ";

    public static PrivateKey readPrivateKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PEMObject> objects = PEM.readPEMObjects(is);
        for (PEMObject object : objects) {
            switch (object.getPEMObjectType()) {
                case PRIVATE_KEY_PKCS1: {
                    return RSA.privateKeyFromPKCS1(object.getDerBytes());
                }
                case PRIVATE_KEY_PKCS8: {
                    return RSA.privateKeyFromPKCS8(object.getDerBytes());
                }
            }
        }
        throw new IllegalArgumentException("Found no private key");
    }

    public static PublicKey readPublicKey(InputStream is) throws InvalidKeySpecException, IOException {
        List<PEMObject> objects = PEM.readPEMObjects(is);
        for (PEMObject object : objects) {
            switch (object.getPEMObjectType()) {
                case PUBLIC_KEY_X509: {
                    return RSA.publicKeyFrom(object.getDerBytes());
                }
            }
        }
        throw new IllegalArgumentException("Found no public key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PEMObject> readPEMObjects(InputStream is) throws IOException {
        ArrayList<PEMObject> pemContents = new ArrayList<PEMObject>();
        boolean readingContent = false;
        String beginMarker = null;
        String endMarker = null;
        StringBuffer sb = null;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (readingContent) {
                    if (line.indexOf(endMarker) != -1) {
                        pemContents.add(new PEMObject(beginMarker, Base64.decode(sb.toString())));
                        readingContent = false;
                        continue;
                    }
                    sb.append(line.trim());
                    continue;
                }
                if (line.indexOf(BEGIN_MARKER) == -1) continue;
                readingContent = true;
                beginMarker = line.trim();
                endMarker = beginMarker.replace("BEGIN", "END");
                sb = new StringBuffer();
            }
            ArrayList<PEMObject> arrayList = pemContents;
            return arrayList;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }
}

