/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.CreateAppRequest;
import com.amazonaws.services.opsworks.model.DataSource;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.SslConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateAppRequestMarshaller
implements Marshaller<Request<CreateAppRequest>, CreateAppRequest> {
    @Override
    public Request<CreateAppRequest> marshall(CreateAppRequest createAppRequest) {
        if (createAppRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAppRequest> request = new DefaultRequest<CreateAppRequest>(createAppRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.CreateApp";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            SslConfiguration sslConfiguration;
            ListWithAutoConstructFlag domainsList;
            Source appSource;
            ListWithAutoConstructFlag dataSourcesList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createAppRequest.getStackId() != null) {
                jsonWriter.key("StackId").value(createAppRequest.getStackId());
            }
            if (createAppRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value(createAppRequest.getShortname());
            }
            if (createAppRequest.getName() != null) {
                jsonWriter.key("Name").value(createAppRequest.getName());
            }
            if (createAppRequest.getDescription() != null) {
                jsonWriter.key("Description").value(createAppRequest.getDescription());
            }
            if (!((dataSourcesList = (ListWithAutoConstructFlag)createAppRequest.getDataSources()) == null || dataSourcesList.isAutoConstruct() && dataSourcesList.isEmpty())) {
                jsonWriter.key("DataSources");
                jsonWriter.array();
                for (DataSource dataSourcesListValue : dataSourcesList) {
                    if (dataSourcesListValue == null) continue;
                    jsonWriter.object();
                    if (dataSourcesListValue.getType() != null) {
                        jsonWriter.key("Type").value(dataSourcesListValue.getType());
                    }
                    if (dataSourcesListValue.getArn() != null) {
                        jsonWriter.key("Arn").value(dataSourcesListValue.getArn());
                    }
                    if (dataSourcesListValue.getDatabaseName() != null) {
                        jsonWriter.key("DatabaseName").value(dataSourcesListValue.getDatabaseName());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (createAppRequest.getType() != null) {
                jsonWriter.key("Type").value(createAppRequest.getType());
            }
            if ((appSource = createAppRequest.getAppSource()) != null) {
                jsonWriter.key("AppSource");
                jsonWriter.object();
                if (appSource.getType() != null) {
                    jsonWriter.key("Type").value(appSource.getType());
                }
                if (appSource.getUrl() != null) {
                    jsonWriter.key("Url").value(appSource.getUrl());
                }
                if (appSource.getUsername() != null) {
                    jsonWriter.key("Username").value(appSource.getUsername());
                }
                if (appSource.getPassword() != null) {
                    jsonWriter.key("Password").value(appSource.getPassword());
                }
                if (appSource.getSshKey() != null) {
                    jsonWriter.key("SshKey").value(appSource.getSshKey());
                }
                if (appSource.getRevision() != null) {
                    jsonWriter.key("Revision").value(appSource.getRevision());
                }
                jsonWriter.endObject();
            }
            if (!((domainsList = (ListWithAutoConstructFlag)createAppRequest.getDomains()) == null || domainsList.isAutoConstruct() && domainsList.isEmpty())) {
                jsonWriter.key("Domains");
                jsonWriter.array();
                for (String domainsListValue : domainsList) {
                    if (domainsListValue == null) continue;
                    jsonWriter.value(domainsListValue);
                }
                jsonWriter.endArray();
            }
            if (createAppRequest.isEnableSsl() != null) {
                jsonWriter.key("EnableSsl").value(createAppRequest.isEnableSsl());
            }
            if ((sslConfiguration = createAppRequest.getSslConfiguration()) != null) {
                jsonWriter.key("SslConfiguration");
                jsonWriter.object();
                if (sslConfiguration.getCertificate() != null) {
                    jsonWriter.key("Certificate").value(sslConfiguration.getCertificate());
                }
                if (sslConfiguration.getPrivateKey() != null) {
                    jsonWriter.key("PrivateKey").value(sslConfiguration.getPrivateKey());
                }
                if (sslConfiguration.getChain() != null) {
                    jsonWriter.key("Chain").value(sslConfiguration.getChain());
                }
                jsonWriter.endObject();
            }
            if (createAppRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : createAppRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value(attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

