/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.http.annotation.ThreadSafe;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.tz.FixedDateTimeZone;

@ThreadSafe
public class DateUtils {
    private static final DateTimeZone GMT = new FixedDateTimeZone("GMT", "GMT", 0, 0);
    protected static final DateTimeFormatter iso8601DateFormat = ISODateTimeFormat.dateTime().withZone(GMT);
    protected static final DateTimeFormatter alternateIso8601DateFormat = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(GMT);
    protected static final DateTimeFormatter rfc822DateFormat = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss z").withLocale(Locale.US).withZone(GMT);
    protected static final DateTimeFormatter compressedIso8601DateFormat = DateTimeFormat.forPattern((String)"yyyyMMdd'T'HHmmss'Z'").withZone(GMT);

    @Deprecated
    public Date parseIso8601Date(String dateString) throws ParseException {
        return DateUtils.parseISO8601Date(dateString);
    }

    public static Date parseISO8601Date(String dateString) throws ParseException {
        try {
            return new Date(iso8601DateFormat.parseMillis(dateString));
        }
        catch (IllegalArgumentException e) {
            return new Date(alternateIso8601DateFormat.parseMillis(dateString));
        }
    }

    @Deprecated
    public String formatIso8601Date(Date date) {
        return DateUtils.formatISO8601Date(date);
    }

    public static String formatISO8601Date(Date date) {
        return iso8601DateFormat.print(date.getTime());
    }

    @Deprecated
    public Date parseRfc822Date(String dateString) throws ParseException {
        return DateUtils.parseRFC822Date(dateString);
    }

    public static Date parseRFC822Date(String dateString) throws ParseException {
        return new Date(rfc822DateFormat.parseMillis(dateString));
    }

    @Deprecated
    public String formatRfc822Date(Date date) {
        return DateUtils.formatRFC822Date(date);
    }

    public static String formatRFC822Date(Date date) {
        return rfc822DateFormat.print(date.getTime());
    }

    @Deprecated
    public Date parseCompressedIso8601Date(String dateString) throws ParseException {
        return DateUtils.parseCompressedISO8601Date(dateString);
    }

    public static Date parseCompressedISO8601Date(String dateString) throws ParseException {
        return new Date(compressedIso8601DateFormat.parseMillis(dateString));
    }
}

