/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.importexport.AmazonImportExport;
import com.amazonaws.services.importexport.model.CancelJobRequest;
import com.amazonaws.services.importexport.model.CancelJobResult;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.services.importexport.model.CreateJobResult;
import com.amazonaws.services.importexport.model.GetStatusRequest;
import com.amazonaws.services.importexport.model.GetStatusResult;
import com.amazonaws.services.importexport.model.ListJobsRequest;
import com.amazonaws.services.importexport.model.ListJobsResult;
import com.amazonaws.services.importexport.model.UpdateJobRequest;
import com.amazonaws.services.importexport.model.UpdateJobResult;
import com.amazonaws.services.importexport.model.transform.BucketPermissionExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.CancelJobResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CanceledJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.CreateJobResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.ExpiredJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.GetStatusRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.GetStatusResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidAccessKeyIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidAddressExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidCustomsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidFileSystemExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidManifestFieldExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.InvalidParameterExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.ListJobsResultStaxUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MalformedManifestExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingCustomsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingManifestFieldExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MissingParameterExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.MultipleRegionsExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.NoSuchBucketExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UnableToCancelJobIdExceptionUnmarshaller;
import com.amazonaws.services.importexport.model.transform.UpdateJobRequestMarshaller;
import com.amazonaws.services.importexport.model.transform.UpdateJobResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonImportExportClient
extends AmazonWebServiceClient
implements AmazonImportExport {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private QueryStringSigner signer;

    public AmazonImportExportClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonImportExportClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonImportExportClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonImportExportClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonImportExportClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonImportExportClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new BucketPermissionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidFileSystemExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingCustomsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ExpiredJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidManifestFieldExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingManifestFieldExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MalformedManifestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAddressExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MultipleRegionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new UnableToCancelJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CanceledJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidJobIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchBucketExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidAccessKeyIdExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidCustomsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("importexport.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/importexport/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) {
        CreateJobResult createJobResult;
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateJobRequest> request = null;
        CreateJobResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateJobRequestMarshaller().marshall(createJobRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createJobResult = response = this.invoke(request, new CreateJobResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) {
        CancelJobResult cancelJobResult;
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CancelJobRequest> request = null;
        CancelJobResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CancelJobRequestMarshaller().marshall(cancelJobRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            cancelJobResult = response = this.invoke(request, new CancelJobResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return cancelJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStatusResult getStatus(GetStatusRequest getStatusRequest) {
        GetStatusResult getStatusResult;
        ExecutionContext executionContext = this.createExecutionContext(getStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetStatusRequest> request = null;
        GetStatusResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetStatusRequestMarshaller().marshall(getStatusRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            getStatusResult = response = this.invoke(request, new GetStatusResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getStatusResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ListJobsResult listJobsResult;
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListJobsRequest> request = null;
        ListJobsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListJobsRequestMarshaller().marshall(listJobsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listJobsResult = response = this.invoke(request, new ListJobsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listJobsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateJobResult updateJob(UpdateJobRequest updateJobRequest) {
        UpdateJobResult updateJobResult;
        ExecutionContext executionContext = this.createExecutionContext(updateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateJobRequest> request = null;
        UpdateJobResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateJobRequestMarshaller().marshall(updateJobRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateJobResult = response = this.invoke(request, new UpdateJobResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateJobResult;
    }

    @Override
    public ListJobsResult listJobs() throws AmazonServiceException, AmazonClientException {
        return this.listJobs(new ListJobsRequest());
    }

    @Override
    protected String getServiceAbbreviation() {
        return "importexport";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

