/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.GetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.GetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.services.glacier.model.ListJobsResult;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.services.glacier.model.ListMultipartUploadsResult;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.ListPartsResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartResult;
import com.amazonaws.services.glacier.model.transform.AbortMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.MissingParameterValueExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartResultJsonUnmarshaller;
import com.amazonaws.transform.GlacierErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonGlacierClient
extends AmazonWebServiceClient
implements AmazonGlacier {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonGlacier.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonGlacierClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonGlacierClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new RequestTimeoutExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ServiceUnavailableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new GlacierErrorUnmarshaller());
        this.setEndpoint("glacier.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/glacier/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVaultsResult listVaults(ListVaultsRequest listVaultsRequest) {
        ListVaultsResult listVaultsResult;
        ExecutionContext executionContext = this.createExecutionContext(listVaultsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVaultsRequest> request = null;
        ListVaultsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVaultsRequestMarshaller().marshall(listVaultsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListVaultsResultJsonUnmarshaller unmarshaller = new ListVaultsResultJsonUnmarshaller();
            JsonResponseHandler<ListVaultsResult> responseHandler = new JsonResponseHandler<ListVaultsResult>(unmarshaller);
            listVaultsResult = response = (ListVaultsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listVaultsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResult describeJob(DescribeJobRequest describeJobRequest) {
        DescribeJobResult describeJobResult;
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        DescribeJobResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller().marshall(describeJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeJobResultJsonUnmarshaller unmarshaller = new DescribeJobResultJsonUnmarshaller();
            JsonResponseHandler<DescribeJobResult> responseHandler = new JsonResponseHandler<DescribeJobResult>(unmarshaller);
            describeJobResult = response = (DescribeJobResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartsResult listParts(ListPartsRequest listPartsRequest) {
        ListPartsResult listPartsResult;
        ExecutionContext executionContext = this.createExecutionContext(listPartsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPartsRequest> request = null;
        ListPartsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPartsRequestMarshaller().marshall(listPartsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPartsResultJsonUnmarshaller unmarshaller = new ListPartsResultJsonUnmarshaller();
            JsonResponseHandler<ListPartsResult> responseHandler = new JsonResponseHandler<ListPartsResult>(unmarshaller);
            listPartsResult = response = (ListPartsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listPartsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVaultNotificationsResult getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) {
        GetVaultNotificationsResult getVaultNotificationsResult;
        ExecutionContext executionContext = this.createExecutionContext(getVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVaultNotificationsRequest> request = null;
        GetVaultNotificationsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVaultNotificationsRequestMarshaller().marshall(getVaultNotificationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetVaultNotificationsResultJsonUnmarshaller unmarshaller = new GetVaultNotificationsResultJsonUnmarshaller();
            JsonResponseHandler<GetVaultNotificationsResult> responseHandler = new JsonResponseHandler<GetVaultNotificationsResult>(unmarshaller);
            getVaultNotificationsResult = response = (GetVaultNotificationsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getVaultNotificationsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ListJobsResult listJobsResult;
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        ListJobsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall(listJobsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListJobsResultJsonUnmarshaller unmarshaller = new ListJobsResultJsonUnmarshaller();
            JsonResponseHandler<ListJobsResult> responseHandler = new JsonResponseHandler<ListJobsResult>(unmarshaller);
            listJobsResult = response = (ListJobsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listJobsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVaultResult createVault(CreateVaultRequest createVaultRequest) {
        CreateVaultResult createVaultResult;
        ExecutionContext executionContext = this.createExecutionContext(createVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVaultRequest> request = null;
        CreateVaultResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVaultRequestMarshaller().marshall(createVaultRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateVaultResultJsonUnmarshaller unmarshaller = new CreateVaultResultJsonUnmarshaller();
            JsonResponseHandler<CreateVaultResult> responseHandler = new JsonResponseHandler<CreateVaultResult>(unmarshaller);
            createVaultResult = response = (CreateVaultResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createVaultResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        InitiateMultipartUploadResult initiateMultipartUploadResult;
        ExecutionContext executionContext = this.createExecutionContext(initiateMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateMultipartUploadRequest> request = null;
        InitiateMultipartUploadResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateMultipartUploadRequestMarshaller().marshall(initiateMultipartUploadRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            InitiateMultipartUploadResultJsonUnmarshaller unmarshaller = new InitiateMultipartUploadResultJsonUnmarshaller();
            JsonResponseHandler<InitiateMultipartUploadResult> responseHandler = new JsonResponseHandler<InitiateMultipartUploadResult>(unmarshaller);
            initiateMultipartUploadResult = response = (InitiateMultipartUploadResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return initiateMultipartUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        Request<AbortMultipartUploadRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(abortMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new AbortMultipartUploadRequestMarshaller().marshall(abortMultipartUploadRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        Request<DeleteArchiveRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteArchiveRequestMarshaller().marshall(deleteArchiveRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobOutputResult getJobOutput(GetJobOutputRequest getJobOutputRequest) {
        GetJobOutputResult getJobOutputResult;
        ExecutionContext executionContext = this.createExecutionContext(getJobOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobOutputRequest> request = null;
        GetJobOutputResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobOutputRequestMarshaller().marshall(getJobOutputRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetJobOutputResultJsonUnmarshaller unmarshaller = new GetJobOutputResultJsonUnmarshaller();
            JsonResponseHandler<GetJobOutputResult> responseHandler = new JsonResponseHandler<GetJobOutputResult>(unmarshaller);
            responseHandler.needsConnectionLeftOpen = true;
            getJobOutputResult = response = (GetJobOutputResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getJobOutputResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateJobResult initiateJob(InitiateJobRequest initiateJobRequest) {
        InitiateJobResult initiateJobResult;
        ExecutionContext executionContext = this.createExecutionContext(initiateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateJobRequest> request = null;
        InitiateJobResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateJobRequestMarshaller().marshall(initiateJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            InitiateJobResultJsonUnmarshaller unmarshaller = new InitiateJobResultJsonUnmarshaller();
            JsonResponseHandler<InitiateJobResult> responseHandler = new JsonResponseHandler<InitiateJobResult>(unmarshaller);
            initiateJobResult = response = (InitiateJobResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return initiateJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadArchiveResult uploadArchive(UploadArchiveRequest uploadArchiveRequest) {
        UploadArchiveResult uploadArchiveResult;
        ExecutionContext executionContext = this.createExecutionContext(uploadArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadArchiveRequest> request = null;
        UploadArchiveResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadArchiveRequestMarshaller().marshall(uploadArchiveRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UploadArchiveResultJsonUnmarshaller unmarshaller = new UploadArchiveResultJsonUnmarshaller();
            JsonResponseHandler<UploadArchiveResult> responseHandler = new JsonResponseHandler<UploadArchiveResult>(unmarshaller);
            uploadArchiveResult = response = (UploadArchiveResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return uploadArchiveResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) {
        Request<SetVaultNotificationsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetVaultNotificationsRequestMarshaller().marshall(setVaultNotificationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        CompleteMultipartUploadResult completeMultipartUploadResult;
        ExecutionContext executionContext = this.createExecutionContext(completeMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteMultipartUploadRequest> request = null;
        CompleteMultipartUploadResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteMultipartUploadRequestMarshaller().marshall(completeMultipartUploadRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CompleteMultipartUploadResultJsonUnmarshaller unmarshaller = new CompleteMultipartUploadResultJsonUnmarshaller();
            JsonResponseHandler<CompleteMultipartUploadResult> responseHandler = new JsonResponseHandler<CompleteMultipartUploadResult>(unmarshaller);
            completeMultipartUploadResult = response = (CompleteMultipartUploadResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return completeMultipartUploadResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadMultipartPartResult uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest) {
        UploadMultipartPartResult uploadMultipartPartResult;
        ExecutionContext executionContext = this.createExecutionContext(uploadMultipartPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadMultipartPartRequest> request = null;
        UploadMultipartPartResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadMultipartPartRequestMarshaller().marshall(uploadMultipartPartRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UploadMultipartPartResultJsonUnmarshaller unmarshaller = new UploadMultipartPartResultJsonUnmarshaller();
            JsonResponseHandler<UploadMultipartPartResult> responseHandler = new JsonResponseHandler<UploadMultipartPartResult>(unmarshaller);
            uploadMultipartPartResult = response = (UploadMultipartPartResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return uploadMultipartPartResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVaultResult describeVault(DescribeVaultRequest describeVaultRequest) {
        DescribeVaultResult describeVaultResult;
        ExecutionContext executionContext = this.createExecutionContext(describeVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVaultRequest> request = null;
        DescribeVaultResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVaultRequestMarshaller().marshall(describeVaultRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeVaultResultJsonUnmarshaller unmarshaller = new DescribeVaultResultJsonUnmarshaller();
            JsonResponseHandler<DescribeVaultResult> responseHandler = new JsonResponseHandler<DescribeVaultResult>(unmarshaller);
            describeVaultResult = response = (DescribeVaultResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeVaultResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) {
        Request<DeleteVaultNotificationsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteVaultNotificationsRequestMarshaller().marshall(deleteVaultNotificationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultipartUploadsResult listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        ListMultipartUploadsResult listMultipartUploadsResult;
        ExecutionContext executionContext = this.createExecutionContext(listMultipartUploadsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMultipartUploadsRequest> request = null;
        ListMultipartUploadsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMultipartUploadsRequestMarshaller().marshall(listMultipartUploadsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListMultipartUploadsResultJsonUnmarshaller unmarshaller = new ListMultipartUploadsResultJsonUnmarshaller();
            JsonResponseHandler<ListMultipartUploadsResult> responseHandler = new JsonResponseHandler<ListMultipartUploadsResult>(unmarshaller);
            listMultipartUploadsResult = response = (ListMultipartUploadsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listMultipartUploadsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVault(DeleteVaultRequest deleteVaultRequest) {
        Request<DeleteVaultRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeleteVaultRequestMarshaller().marshall(deleteVaultRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "glacier";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

