/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticmapreduce.AmazonElasticMapReduce;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.AddJobFlowStepsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeClusterResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeJobFlowsResult;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepResult;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListBootstrapActionsResult;
import com.amazonaws.services.elasticmapreduce.model.ListClustersRequest;
import com.amazonaws.services.elasticmapreduce.model.ListClustersResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsResult;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesRequest;
import com.amazonaws.services.elasticmapreduce.model.ListInstancesResult;
import com.amazonaws.services.elasticmapreduce.model.ListStepsRequest;
import com.amazonaws.services.elasticmapreduce.model.ListStepsResult;
import com.amazonaws.services.elasticmapreduce.model.ModifyInstanceGroupsRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowRequest;
import com.amazonaws.services.elasticmapreduce.model.RunJobFlowResult;
import com.amazonaws.services.elasticmapreduce.model.SetTerminationProtectionRequest;
import com.amazonaws.services.elasticmapreduce.model.SetVisibleToAllUsersRequest;
import com.amazonaws.services.elasticmapreduce.model.TerminateJobFlowsRequest;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddInstanceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.AddJobFlowStepsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeClusterRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeClusterResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeJobFlowsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeStepRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.DescribeStepResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListBootstrapActionsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListBootstrapActionsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListClustersRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListClustersResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstanceGroupsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstancesRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListInstancesResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListStepsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ListStepsResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.ModifyInstanceGroupsRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.RunJobFlowResultJsonUnmarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetTerminationProtectionRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.SetVisibleToAllUsersRequestMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.TerminateJobFlowsRequestMarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticMapReduceClient
extends AmazonWebServiceClient
implements AmazonElasticMapReduce {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticMapReduce.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonElasticMapReduceClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticMapReduceClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new InternalServerExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("elasticmapreduce.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("elasticmapreduce");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticmapreduce/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListBootstrapActionsResult listBootstrapActions(ListBootstrapActionsRequest listBootstrapActionsRequest) {
        ListBootstrapActionsResult listBootstrapActionsResult;
        ExecutionContext executionContext = this.createExecutionContext(listBootstrapActionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListBootstrapActionsRequest> request = null;
        ListBootstrapActionsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListBootstrapActionsRequestMarshaller().marshall(listBootstrapActionsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListBootstrapActionsResultJsonUnmarshaller unmarshaller = new ListBootstrapActionsResultJsonUnmarshaller();
            JsonResponseHandler<ListBootstrapActionsResult> responseHandler = new JsonResponseHandler<ListBootstrapActionsResult>(unmarshaller);
            listBootstrapActionsResult = response = (ListBootstrapActionsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listBootstrapActionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisibleToAllUsers(SetVisibleToAllUsersRequest setVisibleToAllUsersRequest) {
        Request<SetVisibleToAllUsersRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setVisibleToAllUsersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetVisibleToAllUsersRequestMarshaller().marshall(setVisibleToAllUsersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStepsResult listSteps(ListStepsRequest listStepsRequest) {
        ListStepsResult listStepsResult;
        ExecutionContext executionContext = this.createExecutionContext(listStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListStepsRequest> request = null;
        ListStepsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListStepsRequestMarshaller().marshall(listStepsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListStepsResultJsonUnmarshaller unmarshaller = new ListStepsResultJsonUnmarshaller();
            JsonResponseHandler<ListStepsResult> responseHandler = new JsonResponseHandler<ListStepsResult>(unmarshaller);
            listStepsResult = response = (ListStepsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listStepsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddJobFlowStepsResult addJobFlowSteps(AddJobFlowStepsRequest addJobFlowStepsRequest) {
        AddJobFlowStepsResult addJobFlowStepsResult;
        ExecutionContext executionContext = this.createExecutionContext(addJobFlowStepsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddJobFlowStepsRequest> request = null;
        AddJobFlowStepsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddJobFlowStepsRequestMarshaller().marshall(addJobFlowStepsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddJobFlowStepsResultJsonUnmarshaller unmarshaller = new AddJobFlowStepsResultJsonUnmarshaller();
            JsonResponseHandler<AddJobFlowStepsResult> responseHandler = new JsonResponseHandler<AddJobFlowStepsResult>(unmarshaller);
            addJobFlowStepsResult = response = (AddJobFlowStepsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return addJobFlowStepsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStepResult describeStep(DescribeStepRequest describeStepRequest) {
        DescribeStepResult describeStepResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStepRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeStepRequest> request = null;
        DescribeStepResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeStepRequestMarshaller().marshall(describeStepRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeStepResultJsonUnmarshaller unmarshaller = new DescribeStepResultJsonUnmarshaller();
            JsonResponseHandler<DescribeStepResult> responseHandler = new JsonResponseHandler<DescribeStepResult>(unmarshaller);
            describeStepResult = response = (DescribeStepResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStepResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResult listClusters(ListClustersRequest listClustersRequest) {
        ListClustersResult listClustersResult;
        ExecutionContext executionContext = this.createExecutionContext(listClustersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListClustersRequest> request = null;
        ListClustersResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListClustersRequestMarshaller().marshall(listClustersRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListClustersResultJsonUnmarshaller unmarshaller = new ListClustersResultJsonUnmarshaller();
            JsonResponseHandler<ListClustersResult> responseHandler = new JsonResponseHandler<ListClustersResult>(unmarshaller);
            listClustersResult = response = (ListClustersResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listClustersResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstanceGroupsResult listInstanceGroups(ListInstanceGroupsRequest listInstanceGroupsRequest) {
        ListInstanceGroupsResult listInstanceGroupsResult;
        ExecutionContext executionContext = this.createExecutionContext(listInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstanceGroupsRequest> request = null;
        ListInstanceGroupsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstanceGroupsRequestMarshaller().marshall(listInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListInstanceGroupsResultJsonUnmarshaller unmarshaller = new ListInstanceGroupsResultJsonUnmarshaller();
            JsonResponseHandler<ListInstanceGroupsResult> responseHandler = new JsonResponseHandler<ListInstanceGroupsResult>(unmarshaller);
            listInstanceGroupsResult = response = (ListInstanceGroupsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listInstanceGroupsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyInstanceGroups(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest) {
        Request<ModifyInstanceGroupsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(modifyInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new ModifyInstanceGroupsRequestMarshaller().marshall(modifyInstanceGroupsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstancesResult listInstances(ListInstancesRequest listInstancesRequest) {
        ListInstancesResult listInstancesResult;
        ExecutionContext executionContext = this.createExecutionContext(listInstancesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstancesRequest> request = null;
        ListInstancesResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstancesRequestMarshaller().marshall(listInstancesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListInstancesResultJsonUnmarshaller unmarshaller = new ListInstancesResultJsonUnmarshaller();
            JsonResponseHandler<ListInstancesResult> responseHandler = new JsonResponseHandler<ListInstancesResult>(unmarshaller);
            listInstancesResult = response = (ListInstancesResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listInstancesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddInstanceGroupsResult addInstanceGroups(AddInstanceGroupsRequest addInstanceGroupsRequest) {
        AddInstanceGroupsResult addInstanceGroupsResult;
        ExecutionContext executionContext = this.createExecutionContext(addInstanceGroupsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddInstanceGroupsRequest> request = null;
        AddInstanceGroupsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddInstanceGroupsRequestMarshaller().marshall(addInstanceGroupsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            AddInstanceGroupsResultJsonUnmarshaller unmarshaller = new AddInstanceGroupsResultJsonUnmarshaller();
            JsonResponseHandler<AddInstanceGroupsResult> responseHandler = new JsonResponseHandler<AddInstanceGroupsResult>(unmarshaller);
            addInstanceGroupsResult = response = (AddInstanceGroupsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return addInstanceGroupsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminateJobFlows(TerminateJobFlowsRequest terminateJobFlowsRequest) {
        Request<TerminateJobFlowsRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(terminateJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new TerminateJobFlowsRequestMarshaller().marshall(terminateJobFlowsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public DescribeJobFlowsResult describeJobFlows(DescribeJobFlowsRequest describeJobFlowsRequest) {
        DescribeJobFlowsResult describeJobFlowsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeJobFlowsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobFlowsRequest> request = null;
        DescribeJobFlowsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobFlowsRequestMarshaller().marshall(describeJobFlowsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeJobFlowsResultJsonUnmarshaller unmarshaller = new DescribeJobFlowsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeJobFlowsResult> responseHandler = new JsonResponseHandler<DescribeJobFlowsResult>(unmarshaller);
            describeJobFlowsResult = response = (DescribeJobFlowsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeJobFlowsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTerminationProtection(SetTerminationProtectionRequest setTerminationProtectionRequest) {
        Request<SetTerminationProtectionRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setTerminationProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetTerminationProtectionRequestMarshaller().marshall(setTerminationProtectionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RunJobFlowResult runJobFlow(RunJobFlowRequest runJobFlowRequest) {
        RunJobFlowResult runJobFlowResult;
        ExecutionContext executionContext = this.createExecutionContext(runJobFlowRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RunJobFlowRequest> request = null;
        RunJobFlowResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RunJobFlowRequestMarshaller().marshall(runJobFlowRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            RunJobFlowResultJsonUnmarshaller unmarshaller = new RunJobFlowResultJsonUnmarshaller();
            JsonResponseHandler<RunJobFlowResult> responseHandler = new JsonResponseHandler<RunJobFlowResult>(unmarshaller);
            runJobFlowResult = response = (RunJobFlowResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return runJobFlowResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeClusterResult describeCluster(DescribeClusterRequest describeClusterRequest) {
        DescribeClusterResult describeClusterResult;
        ExecutionContext executionContext = this.createExecutionContext(describeClusterRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeClusterRequest> request = null;
        DescribeClusterResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeClusterRequestMarshaller().marshall(describeClusterRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeClusterResultJsonUnmarshaller unmarshaller = new DescribeClusterResultJsonUnmarshaller();
            JsonResponseHandler<DescribeClusterResult> responseHandler = new JsonResponseHandler<DescribeClusterResult>(unmarshaller);
            describeClusterResult = response = (DescribeClusterResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeClusterResult;
    }

    @Override
    public ListBootstrapActionsResult listBootstrapActions() throws AmazonServiceException, AmazonClientException {
        return this.listBootstrapActions(new ListBootstrapActionsRequest());
    }

    @Override
    public ListStepsResult listSteps() throws AmazonServiceException, AmazonClientException {
        return this.listSteps(new ListStepsRequest());
    }

    @Override
    public DescribeStepResult describeStep() throws AmazonServiceException, AmazonClientException {
        return this.describeStep(new DescribeStepRequest());
    }

    @Override
    public ListClustersResult listClusters() throws AmazonServiceException, AmazonClientException {
        return this.listClusters(new ListClustersRequest());
    }

    @Override
    public ListInstanceGroupsResult listInstanceGroups() throws AmazonServiceException, AmazonClientException {
        return this.listInstanceGroups(new ListInstanceGroupsRequest());
    }

    @Override
    public void modifyInstanceGroups() throws AmazonServiceException, AmazonClientException {
        this.modifyInstanceGroups(new ModifyInstanceGroupsRequest());
    }

    @Override
    public ListInstancesResult listInstances() throws AmazonServiceException, AmazonClientException {
        return this.listInstances(new ListInstancesRequest());
    }

    @Override
    @Deprecated
    public DescribeJobFlowsResult describeJobFlows() throws AmazonServiceException, AmazonClientException {
        return this.describeJobFlows(new DescribeJobFlowsRequest());
    }

    @Override
    public DescribeClusterResult describeCluster() throws AmazonServiceException, AmazonClientException {
        return this.describeCluster(new DescribeClusterRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elasticmapreduce";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

