/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudsearch.AmazonCloudSearch;
import com.amazonaws.services.cloudsearch.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearch.model.CreateDomainResult;
import com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearch.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest;
import com.amazonaws.services.cloudsearch.model.DefineRankExpressionResult;
import com.amazonaws.services.cloudsearch.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearch.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearch.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest;
import com.amazonaws.services.cloudsearch.model.DeleteRankExpressionResult;
import com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest;
import com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldResult;
import com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsResult;
import com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearch.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest;
import com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldResult;
import com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsResult;
import com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsResult;
import com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsResult;
import com.amazonaws.services.cloudsearch.model.transform.BaseExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineRankExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineRankExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteRankExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteRankExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDefaultSearchFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDefaultSearchFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDomainsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDomainsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeIndexFieldsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeIndexFieldsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeRankExpressionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeRankExpressionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStemmingOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStemmingOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStopwordOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStopwordOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeSynonymOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeSynonymOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.IndexDocumentsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.IndexDocumentsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.InvalidTypeExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateDefaultSearchFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateDefaultSearchFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStemmingOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStemmingOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStopwordOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStopwordOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateSynonymOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateSynonymOptionsResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudSearchClient
extends AmazonWebServiceClient
implements AmazonCloudSearch {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonCloudSearchClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudSearchClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudSearchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudSearchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BaseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidTypeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudsearch.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudsearch/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDefaultSearchFieldResult updateDefaultSearchField(UpdateDefaultSearchFieldRequest updateDefaultSearchFieldRequest) {
        UpdateDefaultSearchFieldResult updateDefaultSearchFieldResult;
        ExecutionContext executionContext = this.createExecutionContext(updateDefaultSearchFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateDefaultSearchFieldRequest> request = null;
        UpdateDefaultSearchFieldResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateDefaultSearchFieldRequestMarshaller().marshall(updateDefaultSearchFieldRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateDefaultSearchFieldResult = response = this.invoke(request, new UpdateDefaultSearchFieldResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateDefaultSearchFieldResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRankExpressionResult deleteRankExpression(DeleteRankExpressionRequest deleteRankExpressionRequest) {
        DeleteRankExpressionResult deleteRankExpressionResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteRankExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteRankExpressionRequest> request = null;
        DeleteRankExpressionResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteRankExpressionRequestMarshaller().marshall(deleteRankExpressionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deleteRankExpressionResult = response = this.invoke(request, new DeleteRankExpressionResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deleteRankExpressionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRankExpressionsResult describeRankExpressions(DescribeRankExpressionsRequest describeRankExpressionsRequest) {
        DescribeRankExpressionsResult describeRankExpressionsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeRankExpressionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeRankExpressionsRequest> request = null;
        DescribeRankExpressionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeRankExpressionsRequestMarshaller().marshall(describeRankExpressionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeRankExpressionsResult = response = this.invoke(request, new DescribeRankExpressionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeRankExpressionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResult createDomain(CreateDomainRequest createDomainRequest) {
        CreateDomainResult createDomainResult;
        ExecutionContext executionContext = this.createExecutionContext(createDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateDomainRequest> request = null;
        CreateDomainResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateDomainRequestMarshaller().marshall(createDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createDomainResult = response = this.invoke(request, new CreateDomainResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createDomainResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceAccessPoliciesResult updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) {
        UpdateServiceAccessPoliciesResult updateServiceAccessPoliciesResult;
        ExecutionContext executionContext = this.createExecutionContext(updateServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateServiceAccessPoliciesRequest> request = null;
        UpdateServiceAccessPoliciesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateServiceAccessPoliciesRequestMarshaller().marshall(updateServiceAccessPoliciesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateServiceAccessPoliciesResult = response = this.invoke(request, new UpdateServiceAccessPoliciesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateServiceAccessPoliciesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineIndexFieldResult defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) {
        DefineIndexFieldResult defineIndexFieldResult;
        ExecutionContext executionContext = this.createExecutionContext(defineIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DefineIndexFieldRequest> request = null;
        DefineIndexFieldResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DefineIndexFieldRequestMarshaller().marshall(defineIndexFieldRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            defineIndexFieldResult = response = this.invoke(request, new DefineIndexFieldResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return defineIndexFieldResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineRankExpressionResult defineRankExpression(DefineRankExpressionRequest defineRankExpressionRequest) {
        DefineRankExpressionResult defineRankExpressionResult;
        ExecutionContext executionContext = this.createExecutionContext(defineRankExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DefineRankExpressionRequest> request = null;
        DefineRankExpressionResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DefineRankExpressionRequestMarshaller().marshall(defineRankExpressionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            defineRankExpressionResult = response = this.invoke(request, new DefineRankExpressionResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return defineRankExpressionResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSynonymOptionsResult describeSynonymOptions(DescribeSynonymOptionsRequest describeSynonymOptionsRequest) {
        DescribeSynonymOptionsResult describeSynonymOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeSynonymOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeSynonymOptionsRequest> request = null;
        DescribeSynonymOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeSynonymOptionsRequestMarshaller().marshall(describeSynonymOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeSynonymOptionsResult = response = this.invoke(request, new DescribeSynonymOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeSynonymOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStopwordOptionsResult describeStopwordOptions(DescribeStopwordOptionsRequest describeStopwordOptionsRequest) {
        DescribeStopwordOptionsResult describeStopwordOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStopwordOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStopwordOptionsRequest> request = null;
        DescribeStopwordOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStopwordOptionsRequestMarshaller().marshall(describeStopwordOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeStopwordOptionsResult = response = this.invoke(request, new DescribeStopwordOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStopwordOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        DeleteDomainResult deleteDomainResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteDomainRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteDomainRequest> request = null;
        DeleteDomainResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteDomainRequestMarshaller().marshall(deleteDomainRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deleteDomainResult = response = this.invoke(request, new DeleteDomainResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deleteDomainResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceAccessPoliciesResult describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) {
        DescribeServiceAccessPoliciesResult describeServiceAccessPoliciesResult;
        ExecutionContext executionContext = this.createExecutionContext(describeServiceAccessPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeServiceAccessPoliciesRequest> request = null;
        DescribeServiceAccessPoliciesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeServiceAccessPoliciesRequestMarshaller().marshall(describeServiceAccessPoliciesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeServiceAccessPoliciesResult = response = this.invoke(request, new DescribeServiceAccessPoliciesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeServiceAccessPoliciesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDefaultSearchFieldResult describeDefaultSearchField(DescribeDefaultSearchFieldRequest describeDefaultSearchFieldRequest) {
        DescribeDefaultSearchFieldResult describeDefaultSearchFieldResult;
        ExecutionContext executionContext = this.createExecutionContext(describeDefaultSearchFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeDefaultSearchFieldRequest> request = null;
        DescribeDefaultSearchFieldResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeDefaultSearchFieldRequestMarshaller().marshall(describeDefaultSearchFieldRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeDefaultSearchFieldResult = response = this.invoke(request, new DescribeDefaultSearchFieldResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeDefaultSearchFieldResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStopwordOptionsResult updateStopwordOptions(UpdateStopwordOptionsRequest updateStopwordOptionsRequest) {
        UpdateStopwordOptionsResult updateStopwordOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(updateStopwordOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateStopwordOptionsRequest> request = null;
        UpdateStopwordOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateStopwordOptionsRequestMarshaller().marshall(updateStopwordOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateStopwordOptionsResult = response = this.invoke(request, new UpdateStopwordOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateStopwordOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateSynonymOptionsResult updateSynonymOptions(UpdateSynonymOptionsRequest updateSynonymOptionsRequest) {
        UpdateSynonymOptionsResult updateSynonymOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(updateSynonymOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateSynonymOptionsRequest> request = null;
        UpdateSynonymOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateSynonymOptionsRequestMarshaller().marshall(updateSynonymOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateSynonymOptionsResult = response = this.invoke(request, new UpdateSynonymOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateSynonymOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStemmingOptionsResult updateStemmingOptions(UpdateStemmingOptionsRequest updateStemmingOptionsRequest) {
        UpdateStemmingOptionsResult updateStemmingOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(updateStemmingOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateStemmingOptionsRequest> request = null;
        UpdateStemmingOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateStemmingOptionsRequestMarshaller().marshall(updateStemmingOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateStemmingOptionsResult = response = this.invoke(request, new UpdateStemmingOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateStemmingOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStemmingOptionsResult describeStemmingOptions(DescribeStemmingOptionsRequest describeStemmingOptionsRequest) {
        DescribeStemmingOptionsResult describeStemmingOptionsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStemmingOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStemmingOptionsRequest> request = null;
        DescribeStemmingOptionsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStemmingOptionsRequestMarshaller().marshall(describeStemmingOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeStemmingOptionsResult = response = this.invoke(request, new DescribeStemmingOptionsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStemmingOptionsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainsResult describeDomains(DescribeDomainsRequest describeDomainsRequest) {
        DescribeDomainsResult describeDomainsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeDomainsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeDomainsRequest> request = null;
        DescribeDomainsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeDomainsRequestMarshaller().marshall(describeDomainsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeDomainsResult = response = this.invoke(request, new DescribeDomainsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeDomainsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDocumentsResult indexDocuments(IndexDocumentsRequest indexDocumentsRequest) {
        IndexDocumentsResult indexDocumentsResult;
        ExecutionContext executionContext = this.createExecutionContext(indexDocumentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<IndexDocumentsRequest> request = null;
        IndexDocumentsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new IndexDocumentsRequestMarshaller().marshall(indexDocumentsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            indexDocumentsResult = response = this.invoke(request, new IndexDocumentsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return indexDocumentsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIndexFieldsResult describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) {
        DescribeIndexFieldsResult describeIndexFieldsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeIndexFieldsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeIndexFieldsRequest> request = null;
        DescribeIndexFieldsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeIndexFieldsRequestMarshaller().marshall(describeIndexFieldsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeIndexFieldsResult = response = this.invoke(request, new DescribeIndexFieldsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeIndexFieldsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexFieldResult deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) {
        DeleteIndexFieldResult deleteIndexFieldResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteIndexFieldRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteIndexFieldRequest> request = null;
        DeleteIndexFieldResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteIndexFieldRequestMarshaller().marshall(deleteIndexFieldRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deleteIndexFieldResult = response = this.invoke(request, new DeleteIndexFieldResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deleteIndexFieldResult;
    }

    @Override
    public DescribeDomainsResult describeDomains() throws AmazonServiceException, AmazonClientException {
        return this.describeDomains(new DescribeDomainsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "cloudsearch";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

