/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifyReservedInstancesRequest;
import com.amazonaws.services.ec2.model.ReservedInstancesConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyReservedInstancesRequestMarshaller
implements Marshaller<Request<ModifyReservedInstancesRequest>, ModifyReservedInstancesRequest> {
    @Override
    public Request<ModifyReservedInstancesRequest> marshall(ModifyReservedInstancesRequest modifyReservedInstancesRequest) {
        if (modifyReservedInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyReservedInstancesRequest> request = new DefaultRequest<ModifyReservedInstancesRequest>(modifyReservedInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyReservedInstances");
        request.addParameter("Version", "2013-10-01");
        if (modifyReservedInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(modifyReservedInstancesRequest.getClientToken()));
        }
        List<String> reservedInstancesIdsList = modifyReservedInstancesRequest.getReservedInstancesIds();
        int reservedInstancesIdsListIndex = 1;
        for (String reservedInstancesIdsListValue : reservedInstancesIdsList) {
            if (reservedInstancesIdsListValue != null) {
                request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringUtils.fromString(reservedInstancesIdsListValue));
            }
            ++reservedInstancesIdsListIndex;
        }
        List<ReservedInstancesConfiguration> targetConfigurationsList = modifyReservedInstancesRequest.getTargetConfigurations();
        int targetConfigurationsListIndex = 1;
        for (ReservedInstancesConfiguration targetConfigurationsListValue : targetConfigurationsList) {
            ReservedInstancesConfiguration reservedInstancesConfigurationMember = targetConfigurationsListValue;
            if (reservedInstancesConfigurationMember != null) {
                if (reservedInstancesConfigurationMember.getAvailabilityZone() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".AvailabilityZone", StringUtils.fromString(reservedInstancesConfigurationMember.getAvailabilityZone()));
                }
                if (reservedInstancesConfigurationMember.getPlatform() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".Platform", StringUtils.fromString(reservedInstancesConfigurationMember.getPlatform()));
                }
                if (reservedInstancesConfigurationMember.getInstanceCount() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceCount", StringUtils.fromInteger(reservedInstancesConfigurationMember.getInstanceCount()));
                }
                if (reservedInstancesConfigurationMember.getInstanceType() != null) {
                    request.addParameter("ReservedInstancesConfigurationSetItemType." + targetConfigurationsListIndex + ".InstanceType", StringUtils.fromString(reservedInstancesConfigurationMember.getInstanceType()));
                }
            }
            ++targetConfigurationsListIndex;
        }
        return request;
    }
}

