/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.AddSourceIdentifierToSubscriptionRequest;
import com.amazonaws.services.rds.model.AddTagsToResourceRequest;
import com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.CopyDBSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.CreateDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.CreateDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.CreateEventSubscriptionRequest;
import com.amazonaws.services.rds.model.CreateOptionGroupRequest;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBParameterGroup;
import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSnapshotRequest;
import com.amazonaws.services.rds.model.DeleteDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.DeleteEventSubscriptionRequest;
import com.amazonaws.services.rds.model.DeleteOptionGroupRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBLogFilesRequest;
import com.amazonaws.services.rds.model.DescribeDBLogFilesResult;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBParametersRequest;
import com.amazonaws.services.rds.model.DescribeDBParametersResult;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSubnetGroupsResult;
import com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.rds.model.DescribeEventCategoriesRequest;
import com.amazonaws.services.rds.model.DescribeEventCategoriesResult;
import com.amazonaws.services.rds.model.DescribeEventSubscriptionsRequest;
import com.amazonaws.services.rds.model.DescribeEventSubscriptionsResult;
import com.amazonaws.services.rds.model.DescribeEventsRequest;
import com.amazonaws.services.rds.model.DescribeEventsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupOptionsResult;
import com.amazonaws.services.rds.model.DescribeOptionGroupsRequest;
import com.amazonaws.services.rds.model.DescribeOptionGroupsResult;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsRequest;
import com.amazonaws.services.rds.model.DescribeOrderableDBInstanceOptionsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesResult;
import com.amazonaws.services.rds.model.DownloadDBLogFilePortionRequest;
import com.amazonaws.services.rds.model.DownloadDBLogFilePortionResult;
import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.EventSubscription;
import com.amazonaws.services.rds.model.ListTagsForResourceRequest;
import com.amazonaws.services.rds.model.ListTagsForResourceResult;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupResult;
import com.amazonaws.services.rds.model.ModifyDBSubnetGroupRequest;
import com.amazonaws.services.rds.model.ModifyEventSubscriptionRequest;
import com.amazonaws.services.rds.model.ModifyOptionGroupRequest;
import com.amazonaws.services.rds.model.OptionGroup;
import com.amazonaws.services.rds.model.PromoteReadReplicaRequest;
import com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import com.amazonaws.services.rds.model.RemoveSourceIdentifierFromSubscriptionRequest;
import com.amazonaws.services.rds.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.rds.model.ReservedDBInstance;
import com.amazonaws.services.rds.model.ResetDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ResetDBParameterGroupResult;
import com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.transform.AddSourceIdentifierToSubscriptionRequestMarshaller;
import com.amazonaws.services.rds.model.transform.AddTagsToResourceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizationAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizationNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizationQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizeDBSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CopyDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBInstanceReadReplicaRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBSecurityGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBSubnetGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateEventSubscriptionRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateOptionGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DBInstanceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBInstanceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBInstanceStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupNotSupportedExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSnapshotAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSnapshotNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSnapshotStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSubnetGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSubnetGroupDoesNotCoverEnoughAZsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSubnetGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSubnetGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSubnetGroupStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSubnetQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBUpgradeDependencyFailureExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBSecurityGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBSubnetGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteEventSubscriptionRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteOptionGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBEngineVersionsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBEngineVersionsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBInstancesRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBInstancesResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBLogFilesRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBLogFilesResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParameterGroupsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParameterGroupsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParametersRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParametersResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSecurityGroupsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSecurityGroupsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSnapshotsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSnapshotsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSubnetGroupsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSubnetGroupsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEngineDefaultParametersRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventCategoriesRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventCategoriesResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventSubscriptionsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventSubscriptionsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeOptionGroupOptionsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeOptionGroupOptionsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeOptionGroupsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeOptionGroupsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeOrderableDBInstanceOptionsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeOrderableDBInstanceOptionsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesOfferingsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesOfferingsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DownloadDBLogFilePortionRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DownloadDBLogFilePortionResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.EngineDefaultsStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.EventSubscriptionQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.EventSubscriptionStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.InstanceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InsufficientDBInstanceCapacityExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBInstanceStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBParameterGroupStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBSecurityGroupStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBSnapshotStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBSubnetGroupStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBSubnetStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidEventSubscriptionStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidOptionGroupStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidRestoreExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidSubnetExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidVPCNetworkStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ListTagsForResourceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ListTagsForResourceResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBSubnetGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ModifyEventSubscriptionRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ModifyOptionGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.OptionGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.OptionGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.OptionGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.OptionGroupStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.PointInTimeRestoreNotEnabledExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.PromoteReadReplicaRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ProvisionedIopsNotAvailableInAZExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.PurchaseReservedDBInstancesOfferingRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RebootDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RemoveSourceIdentifierFromSubscriptionRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RemoveTagsFromResourceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstancesOfferingNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ResetDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ResetDBParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.RestoreDBInstanceFromDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RestoreDBInstanceToPointInTimeRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RevokeDBSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.rds.model.transform.SNSInvalidTopicExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SNSNoAuthorizationExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SNSTopicArnNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SnapshotQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.StorageQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SubnetAlreadyInUseExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SubscriptionAlreadyExistExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SubscriptionCategoryNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.SubscriptionNotFoundExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRDSClient
extends AmazonWebServiceClient
implements AmazonRDS {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonRDSClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRDSClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRDSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRDSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRDSClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRDSClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new DBParameterGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBParameterGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new OptionGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstanceAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSubnetGroupDoesNotCoverEnoughAZsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ProvisionedIopsNotAvailableInAZExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBSnapshotStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSnapshotNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PointInTimeRestoreNotEnabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBSubnetStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StorageQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidVPCNetworkStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidOptionGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRestoreExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstancesOfferingNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBSubnetGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBUpgradeDependencyFailureExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBInstanceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SNSTopicArnNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InstanceQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubscriptionCategoryNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SNSInvalidTopicExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstanceQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidEventSubscriptionStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBSecurityGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSnapshotAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientDBInstanceCapacityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubscriptionNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBInstanceAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSubnetGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubscriptionAlreadyExistExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubnetAlreadyInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSubnetGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstanceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SNSNoAuthorizationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new OptionGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new OptionGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSubnetGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBParameterGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidSubnetExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SnapshotQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBParameterGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSubnetQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBInstanceStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupNotSupportedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new EventSubscriptionQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("rds.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("rds");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/rds/request.handlers"));
    }

    @Override
    public DescribeReservedDBInstancesResult describeReservedDBInstances(DescribeReservedDBInstancesRequest describeReservedDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedDBInstancesRequest> request = new DescribeReservedDBInstancesRequestMarshaller().marshall(describeReservedDBInstancesRequest);
        return this.invoke(request, new DescribeReservedDBInstancesResultStaxUnmarshaller());
    }

    @Override
    public EventSubscription removeSourceIdentifierFromSubscription(RemoveSourceIdentifierFromSubscriptionRequest removeSourceIdentifierFromSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        Request<RemoveSourceIdentifierFromSubscriptionRequest> request = new RemoveSourceIdentifierFromSubscriptionRequestMarshaller().marshall(removeSourceIdentifierFromSubscriptionRequest);
        return this.invoke(request, new EventSubscriptionStaxUnmarshaller());
    }

    @Override
    public DBSnapshot deleteDBSnapshot(DeleteDBSnapshotRequest deleteDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBSnapshotRequest> request = new DeleteDBSnapshotRequestMarshaller().marshall(deleteDBSnapshotRequest);
        return this.invoke(request, new DBSnapshotStaxUnmarshaller());
    }

    @Override
    public DBInstance restoreDBInstanceFromDBSnapshot(RestoreDBInstanceFromDBSnapshotRequest restoreDBInstanceFromDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<RestoreDBInstanceFromDBSnapshotRequest> request = new RestoreDBInstanceFromDBSnapshotRequestMarshaller().marshall(restoreDBInstanceFromDBSnapshotRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeEventCategoriesResult describeEventCategories(DescribeEventCategoriesRequest describeEventCategoriesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventCategoriesRequest> request = new DescribeEventCategoriesRequestMarshaller().marshall(describeEventCategoriesRequest);
        return this.invoke(request, new DescribeEventCategoriesResultStaxUnmarshaller());
    }

    @Override
    public DBSecurityGroup authorizeDBSecurityGroupIngress(AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<AuthorizeDBSecurityGroupIngressRequest> request = new AuthorizeDBSecurityGroupIngressRequestMarshaller().marshall(authorizeDBSecurityGroupIngressRequest);
        return this.invoke(request, new DBSecurityGroupStaxUnmarshaller());
    }

    @Override
    public EventSubscription createEventSubscription(CreateEventSubscriptionRequest createEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateEventSubscriptionRequest> request = new CreateEventSubscriptionRequestMarshaller().marshall(createEventSubscriptionRequest);
        return this.invoke(request, new EventSubscriptionStaxUnmarshaller());
    }

    @Override
    public OptionGroup modifyOptionGroup(ModifyOptionGroupRequest modifyOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyOptionGroupRequest> request = new ModifyOptionGroupRequestMarshaller().marshall(modifyOptionGroupRequest);
        return this.invoke(request, new OptionGroupStaxUnmarshaller());
    }

    @Override
    public ResetDBParameterGroupResult resetDBParameterGroup(ResetDBParameterGroupRequest resetDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResetDBParameterGroupRequest> request = new ResetDBParameterGroupRequestMarshaller().marshall(resetDBParameterGroupRequest);
        return this.invoke(request, new ResetDBParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public EngineDefaults describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEngineDefaultParametersRequest> request = new DescribeEngineDefaultParametersRequestMarshaller().marshall(describeEngineDefaultParametersRequest);
        return this.invoke(request, new EngineDefaultsStaxUnmarshaller());
    }

    @Override
    public DescribeReservedDBInstancesOfferingsResult describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedDBInstancesOfferingsRequest> request = new DescribeReservedDBInstancesOfferingsRequestMarshaller().marshall(describeReservedDBInstancesOfferingsRequest);
        return this.invoke(request, new DescribeReservedDBInstancesOfferingsResultStaxUnmarshaller());
    }

    @Override
    public void deleteDBSubnetGroup(DeleteDBSubnetGroupRequest deleteDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBSubnetGroupRequest> request = new DeleteDBSubnetGroupRequestMarshaller().marshall(deleteDBSubnetGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeDBInstancesResult describeDBInstances(DescribeDBInstancesRequest describeDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBInstancesRequest> request = new DescribeDBInstancesRequestMarshaller().marshall(describeDBInstancesRequest);
        return this.invoke(request, new DescribeDBInstancesResultStaxUnmarshaller());
    }

    @Override
    public DescribeDBEngineVersionsResult describeDBEngineVersions(DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBEngineVersionsRequest> request = new DescribeDBEngineVersionsRequestMarshaller().marshall(describeDBEngineVersionsRequest);
        return this.invoke(request, new DescribeDBEngineVersionsResultStaxUnmarshaller());
    }

    @Override
    public DBInstance promoteReadReplica(PromoteReadReplicaRequest promoteReadReplicaRequest) throws AmazonServiceException, AmazonClientException {
        Request<PromoteReadReplicaRequest> request = new PromoteReadReplicaRequestMarshaller().marshall(promoteReadReplicaRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public void deleteDBParameterGroup(DeleteDBParameterGroupRequest deleteDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBParameterGroupRequest> request = new DeleteDBParameterGroupRequestMarshaller().marshall(deleteDBParameterGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DescribeDBSnapshotsResult describeDBSnapshots(DescribeDBSnapshotsRequest describeDBSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBSnapshotsRequest> request = new DescribeDBSnapshotsRequestMarshaller().marshall(describeDBSnapshotsRequest);
        return this.invoke(request, new DescribeDBSnapshotsResultStaxUnmarshaller());
    }

    @Override
    public DescribeDBSubnetGroupsResult describeDBSubnetGroups(DescribeDBSubnetGroupsRequest describeDBSubnetGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBSubnetGroupsRequest> request = new DescribeDBSubnetGroupsRequestMarshaller().marshall(describeDBSubnetGroupsRequest);
        return this.invoke(request, new DescribeDBSubnetGroupsResultStaxUnmarshaller());
    }

    @Override
    public DBInstance restoreDBInstanceToPointInTime(RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) throws AmazonServiceException, AmazonClientException {
        Request<RestoreDBInstanceToPointInTimeRequest> request = new RestoreDBInstanceToPointInTimeRequestMarshaller().marshall(restoreDBInstanceToPointInTimeRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeOrderableDBInstanceOptionsResult describeOrderableDBInstanceOptions(DescribeOrderableDBInstanceOptionsRequest describeOrderableDBInstanceOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeOrderableDBInstanceOptionsRequest> request = new DescribeOrderableDBInstanceOptionsRequestMarshaller().marshall(describeOrderableDBInstanceOptionsRequest);
        return this.invoke(request, new DescribeOrderableDBInstanceOptionsResultStaxUnmarshaller());
    }

    @Override
    public void addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddTagsToResourceRequest> request = new AddTagsToResourceRequestMarshaller().marshall(addTagsToResourceRequest);
        this.invoke(request, null);
    }

    @Override
    public DBSnapshot createDBSnapshot(CreateDBSnapshotRequest createDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBSnapshotRequest> request = new CreateDBSnapshotRequestMarshaller().marshall(createDBSnapshotRequest);
        return this.invoke(request, new DBSnapshotStaxUnmarshaller());
    }

    @Override
    public DBInstance createDBInstanceReadReplica(CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBInstanceReadReplicaRequest> request = new CreateDBInstanceReadReplicaRequestMarshaller().marshall(createDBInstanceReadReplicaRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeOptionGroupOptionsResult describeOptionGroupOptions(DescribeOptionGroupOptionsRequest describeOptionGroupOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeOptionGroupOptionsRequest> request = new DescribeOptionGroupOptionsRequestMarshaller().marshall(describeOptionGroupOptionsRequest);
        return this.invoke(request, new DescribeOptionGroupOptionsResultStaxUnmarshaller());
    }

    @Override
    public DescribeEventSubscriptionsResult describeEventSubscriptions(DescribeEventSubscriptionsRequest describeEventSubscriptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventSubscriptionsRequest> request = new DescribeEventSubscriptionsRequestMarshaller().marshall(describeEventSubscriptionsRequest);
        return this.invoke(request, new DescribeEventSubscriptionsResultStaxUnmarshaller());
    }

    @Override
    public DBSubnetGroup modifyDBSubnetGroup(ModifyDBSubnetGroupRequest modifyDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyDBSubnetGroupRequest> request = new ModifyDBSubnetGroupRequestMarshaller().marshall(modifyDBSubnetGroupRequest);
        return this.invoke(request, new DBSubnetGroupStaxUnmarshaller());
    }

    @Override
    public DBInstance createDBInstance(CreateDBInstanceRequest createDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBInstanceRequest> request = new CreateDBInstanceRequestMarshaller().marshall(createDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeDBParametersResult describeDBParameters(DescribeDBParametersRequest describeDBParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBParametersRequest> request = new DescribeDBParametersRequestMarshaller().marshall(describeDBParametersRequest);
        return this.invoke(request, new DescribeDBParametersResultStaxUnmarshaller());
    }

    @Override
    public DBSnapshot copyDBSnapshot(CopyDBSnapshotRequest copyDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<CopyDBSnapshotRequest> request = new CopyDBSnapshotRequestMarshaller().marshall(copyDBSnapshotRequest);
        return this.invoke(request, new DBSnapshotStaxUnmarshaller());
    }

    @Override
    public DBSecurityGroup createDBSecurityGroup(CreateDBSecurityGroupRequest createDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBSecurityGroupRequest> request = new CreateDBSecurityGroupRequestMarshaller().marshall(createDBSecurityGroupRequest);
        return this.invoke(request, new DBSecurityGroupStaxUnmarshaller());
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListTagsForResourceRequest> request = new ListTagsForResourceRequestMarshaller().marshall(listTagsForResourceRequest);
        return this.invoke(request, new ListTagsForResourceResultStaxUnmarshaller());
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventsRequest> request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
        return this.invoke(request, new DescribeEventsResultStaxUnmarshaller());
    }

    @Override
    public OptionGroup createOptionGroup(CreateOptionGroupRequest createOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateOptionGroupRequest> request = new CreateOptionGroupRequestMarshaller().marshall(createOptionGroupRequest);
        return this.invoke(request, new OptionGroupStaxUnmarshaller());
    }

    @Override
    public DBSubnetGroup createDBSubnetGroup(CreateDBSubnetGroupRequest createDBSubnetGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBSubnetGroupRequest> request = new CreateDBSubnetGroupRequestMarshaller().marshall(createDBSubnetGroupRequest);
        return this.invoke(request, new DBSubnetGroupStaxUnmarshaller());
    }

    @Override
    public DescribeDBLogFilesResult describeDBLogFiles(DescribeDBLogFilesRequest describeDBLogFilesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBLogFilesRequest> request = new DescribeDBLogFilesRequestMarshaller().marshall(describeDBLogFilesRequest);
        return this.invoke(request, new DescribeDBLogFilesResultStaxUnmarshaller());
    }

    @Override
    public DBSecurityGroup revokeDBSecurityGroupIngress(RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<RevokeDBSecurityGroupIngressRequest> request = new RevokeDBSecurityGroupIngressRequestMarshaller().marshall(revokeDBSecurityGroupIngressRequest);
        return this.invoke(request, new DBSecurityGroupStaxUnmarshaller());
    }

    @Override
    public EventSubscription modifyEventSubscription(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyEventSubscriptionRequest> request = new ModifyEventSubscriptionRequestMarshaller().marshall(modifyEventSubscriptionRequest);
        return this.invoke(request, new EventSubscriptionStaxUnmarshaller());
    }

    @Override
    public DescribeDBParameterGroupsResult describeDBParameterGroups(DescribeDBParameterGroupsRequest describeDBParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBParameterGroupsRequest> request = new DescribeDBParameterGroupsRequestMarshaller().marshall(describeDBParameterGroupsRequest);
        return this.invoke(request, new DescribeDBParameterGroupsResultStaxUnmarshaller());
    }

    @Override
    public EventSubscription deleteEventSubscription(DeleteEventSubscriptionRequest deleteEventSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteEventSubscriptionRequest> request = new DeleteEventSubscriptionRequestMarshaller().marshall(deleteEventSubscriptionRequest);
        return this.invoke(request, new EventSubscriptionStaxUnmarshaller());
    }

    @Override
    public ReservedDBInstance purchaseReservedDBInstancesOffering(PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        Request<PurchaseReservedDBInstancesOfferingRequest> request = new PurchaseReservedDBInstancesOfferingRequestMarshaller().marshall(purchaseReservedDBInstancesOfferingRequest);
        return this.invoke(request, new ReservedDBInstanceStaxUnmarshaller());
    }

    @Override
    public DBParameterGroup createDBParameterGroup(CreateDBParameterGroupRequest createDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBParameterGroupRequest> request = new CreateDBParameterGroupRequestMarshaller().marshall(createDBParameterGroupRequest);
        return this.invoke(request, new DBParameterGroupStaxUnmarshaller());
    }

    @Override
    public void deleteOptionGroup(DeleteOptionGroupRequest deleteOptionGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteOptionGroupRequest> request = new DeleteOptionGroupRequestMarshaller().marshall(deleteOptionGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DownloadDBLogFilePortionResult downloadDBLogFilePortion(DownloadDBLogFilePortionRequest downloadDBLogFilePortionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DownloadDBLogFilePortionRequest> request = new DownloadDBLogFilePortionRequestMarshaller().marshall(downloadDBLogFilePortionRequest);
        return this.invoke(request, new DownloadDBLogFilePortionResultStaxUnmarshaller());
    }

    @Override
    public void deleteDBSecurityGroup(DeleteDBSecurityGroupRequest deleteDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBSecurityGroupRequest> request = new DeleteDBSecurityGroupRequestMarshaller().marshall(deleteDBSecurityGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DBInstance modifyDBInstance(ModifyDBInstanceRequest modifyDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyDBInstanceRequest> request = new ModifyDBInstanceRequestMarshaller().marshall(modifyDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public EventSubscription addSourceIdentifierToSubscription(AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddSourceIdentifierToSubscriptionRequest> request = new AddSourceIdentifierToSubscriptionRequestMarshaller().marshall(addSourceIdentifierToSubscriptionRequest);
        return this.invoke(request, new EventSubscriptionStaxUnmarshaller());
    }

    @Override
    public DescribeOptionGroupsResult describeOptionGroups(DescribeOptionGroupsRequest describeOptionGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeOptionGroupsRequest> request = new DescribeOptionGroupsRequestMarshaller().marshall(describeOptionGroupsRequest);
        return this.invoke(request, new DescribeOptionGroupsResultStaxUnmarshaller());
    }

    @Override
    public DescribeDBSecurityGroupsResult describeDBSecurityGroups(DescribeDBSecurityGroupsRequest describeDBSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBSecurityGroupsRequest> request = new DescribeDBSecurityGroupsRequestMarshaller().marshall(describeDBSecurityGroupsRequest);
        return this.invoke(request, new DescribeDBSecurityGroupsResultStaxUnmarshaller());
    }

    @Override
    public DBInstance deleteDBInstance(DeleteDBInstanceRequest deleteDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBInstanceRequest> request = new DeleteDBInstanceRequestMarshaller().marshall(deleteDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public void removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) throws AmazonServiceException, AmazonClientException {
        Request<RemoveTagsFromResourceRequest> request = new RemoveTagsFromResourceRequestMarshaller().marshall(removeTagsFromResourceRequest);
        this.invoke(request, null);
    }

    @Override
    public ModifyDBParameterGroupResult modifyDBParameterGroup(ModifyDBParameterGroupRequest modifyDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyDBParameterGroupRequest> request = new ModifyDBParameterGroupRequestMarshaller().marshall(modifyDBParameterGroupRequest);
        return this.invoke(request, new ModifyDBParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public DBInstance rebootDBInstance(RebootDBInstanceRequest rebootDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<RebootDBInstanceRequest> request = new RebootDBInstanceRequestMarshaller().marshall(rebootDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeReservedDBInstancesResult describeReservedDBInstances() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedDBInstances(new DescribeReservedDBInstancesRequest());
    }

    @Override
    public DescribeEventCategoriesResult describeEventCategories() throws AmazonServiceException, AmazonClientException {
        return this.describeEventCategories(new DescribeEventCategoriesRequest());
    }

    @Override
    public DescribeReservedDBInstancesOfferingsResult describeReservedDBInstancesOfferings() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedDBInstancesOfferings(new DescribeReservedDBInstancesOfferingsRequest());
    }

    @Override
    public DescribeDBInstancesResult describeDBInstances() throws AmazonServiceException, AmazonClientException {
        return this.describeDBInstances(new DescribeDBInstancesRequest());
    }

    @Override
    public DescribeDBEngineVersionsResult describeDBEngineVersions() throws AmazonServiceException, AmazonClientException {
        return this.describeDBEngineVersions(new DescribeDBEngineVersionsRequest());
    }

    @Override
    public DescribeDBSnapshotsResult describeDBSnapshots() throws AmazonServiceException, AmazonClientException {
        return this.describeDBSnapshots(new DescribeDBSnapshotsRequest());
    }

    @Override
    public DescribeDBSubnetGroupsResult describeDBSubnetGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeDBSubnetGroups(new DescribeDBSubnetGroupsRequest());
    }

    @Override
    public DescribeEventSubscriptionsResult describeEventSubscriptions() throws AmazonServiceException, AmazonClientException {
        return this.describeEventSubscriptions(new DescribeEventSubscriptionsRequest());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    @Override
    public DescribeDBLogFilesResult describeDBLogFiles() throws AmazonServiceException, AmazonClientException {
        return this.describeDBLogFiles(new DescribeDBLogFilesRequest());
    }

    @Override
    public DescribeDBParameterGroupsResult describeDBParameterGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeDBParameterGroups(new DescribeDBParameterGroupsRequest());
    }

    @Override
    public DownloadDBLogFilePortionResult downloadDBLogFilePortion() throws AmazonServiceException, AmazonClientException {
        return this.downloadDBLogFilePortion(new DownloadDBLogFilePortionRequest());
    }

    @Override
    public DescribeOptionGroupsResult describeOptionGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeOptionGroups(new DescribeOptionGroupsRequest());
    }

    @Override
    public DescribeDBSecurityGroupsResult describeDBSecurityGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeDBSecurityGroups(new DescribeDBSecurityGroupsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "rds";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext(originalRequest);
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

