/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.JobFlowExecutionState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeJobFlowsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Date createdAfter;
    private Date createdBefore;
    private ListWithAutoConstructFlag<String> jobFlowIds;
    private ListWithAutoConstructFlag<String> jobFlowStates;

    public DescribeJobFlowsRequest() {
    }

    public DescribeJobFlowsRequest(List<String> jobFlowIds) {
        this.setJobFlowIds(jobFlowIds);
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public DescribeJobFlowsRequest withCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
        return this;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public DescribeJobFlowsRequest withCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    public List<String> getJobFlowIds() {
        if (this.jobFlowIds == null) {
            this.jobFlowIds = new ListWithAutoConstructFlag();
            this.jobFlowIds.setAutoConstruct(true);
        }
        return this.jobFlowIds;
    }

    public void setJobFlowIds(Collection<String> jobFlowIds) {
        if (jobFlowIds == null) {
            this.jobFlowIds = null;
            return;
        }
        ListWithAutoConstructFlag jobFlowIdsCopy = new ListWithAutoConstructFlag(jobFlowIds.size());
        jobFlowIdsCopy.addAll(jobFlowIds);
        this.jobFlowIds = jobFlowIdsCopy;
    }

    public DescribeJobFlowsRequest withJobFlowIds(String ... jobFlowIds) {
        if (this.getJobFlowIds() == null) {
            this.setJobFlowIds(new ArrayList<String>(jobFlowIds.length));
        }
        for (String value : jobFlowIds) {
            this.getJobFlowIds().add(value);
        }
        return this;
    }

    public DescribeJobFlowsRequest withJobFlowIds(Collection<String> jobFlowIds) {
        if (jobFlowIds == null) {
            this.jobFlowIds = null;
        } else {
            ListWithAutoConstructFlag jobFlowIdsCopy = new ListWithAutoConstructFlag(jobFlowIds.size());
            jobFlowIdsCopy.addAll(jobFlowIds);
            this.jobFlowIds = jobFlowIdsCopy;
        }
        return this;
    }

    public List<String> getJobFlowStates() {
        if (this.jobFlowStates == null) {
            this.jobFlowStates = new ListWithAutoConstructFlag();
            this.jobFlowStates.setAutoConstruct(true);
        }
        return this.jobFlowStates;
    }

    public void setJobFlowStates(Collection<String> jobFlowStates) {
        if (jobFlowStates == null) {
            this.jobFlowStates = null;
            return;
        }
        ListWithAutoConstructFlag jobFlowStatesCopy = new ListWithAutoConstructFlag(jobFlowStates.size());
        jobFlowStatesCopy.addAll(jobFlowStates);
        this.jobFlowStates = jobFlowStatesCopy;
    }

    public DescribeJobFlowsRequest withJobFlowStates(String ... jobFlowStates) {
        if (this.getJobFlowStates() == null) {
            this.setJobFlowStates(new ArrayList<String>(jobFlowStates.length));
        }
        for (String value : jobFlowStates) {
            this.getJobFlowStates().add(value);
        }
        return this;
    }

    public DescribeJobFlowsRequest withJobFlowStates(Collection<String> jobFlowStates) {
        if (jobFlowStates == null) {
            this.jobFlowStates = null;
        } else {
            ListWithAutoConstructFlag jobFlowStatesCopy = new ListWithAutoConstructFlag(jobFlowStates.size());
            jobFlowStatesCopy.addAll(jobFlowStates);
            this.jobFlowStates = jobFlowStatesCopy;
        }
        return this;
    }

    public DescribeJobFlowsRequest withJobFlowStates(JobFlowExecutionState ... jobFlowStates) {
        ArrayList<String> jobFlowStatesCopy = new ArrayList<String>(jobFlowStates.length);
        for (JobFlowExecutionState member : jobFlowStates) {
            jobFlowStatesCopy.add(member.toString());
        }
        if (this.getJobFlowStates() == null) {
            this.setJobFlowStates(jobFlowStatesCopy);
        } else {
            this.getJobFlowStates().addAll(jobFlowStatesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreatedAfter() != null) {
            sb.append("CreatedAfter: " + this.getCreatedAfter() + ",");
        }
        if (this.getCreatedBefore() != null) {
            sb.append("CreatedBefore: " + this.getCreatedBefore() + ",");
        }
        if (this.getJobFlowIds() != null) {
            sb.append("JobFlowIds: " + this.getJobFlowIds() + ",");
        }
        if (this.getJobFlowStates() != null) {
            sb.append("JobFlowStates: " + this.getJobFlowStates());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreatedAfter() == null ? 0 : this.getCreatedAfter().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBefore() == null ? 0 : this.getCreatedBefore().hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowIds() == null ? 0 : this.getJobFlowIds().hashCode());
        hashCode = 31 * hashCode + (this.getJobFlowStates() == null ? 0 : this.getJobFlowStates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobFlowsRequest)) {
            return false;
        }
        DescribeJobFlowsRequest other = (DescribeJobFlowsRequest)obj;
        if (other.getCreatedAfter() == null ^ this.getCreatedAfter() == null) {
            return false;
        }
        if (other.getCreatedAfter() != null && !other.getCreatedAfter().equals(this.getCreatedAfter())) {
            return false;
        }
        if (other.getCreatedBefore() == null ^ this.getCreatedBefore() == null) {
            return false;
        }
        if (other.getCreatedBefore() != null && !other.getCreatedBefore().equals(this.getCreatedBefore())) {
            return false;
        }
        if (other.getJobFlowIds() == null ^ this.getJobFlowIds() == null) {
            return false;
        }
        if (other.getJobFlowIds() != null && !other.getJobFlowIds().equals(this.getJobFlowIds())) {
            return false;
        }
        if (other.getJobFlowStates() == null ^ this.getJobFlowStates() == null) {
            return false;
        }
        return other.getJobFlowStates() == null || other.getJobFlowStates().equals(this.getJobFlowStates());
    }
}

