/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearch;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudsearch.AmazonCloudSearch;
import com.amazonaws.services.cloudsearch.model.CreateDomainRequest;
import com.amazonaws.services.cloudsearch.model.CreateDomainResult;
import com.amazonaws.services.cloudsearch.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearch.model.DefineIndexFieldResult;
import com.amazonaws.services.cloudsearch.model.DefineRankExpressionRequest;
import com.amazonaws.services.cloudsearch.model.DefineRankExpressionResult;
import com.amazonaws.services.cloudsearch.model.DeleteDomainRequest;
import com.amazonaws.services.cloudsearch.model.DeleteDomainResult;
import com.amazonaws.services.cloudsearch.model.DeleteIndexFieldRequest;
import com.amazonaws.services.cloudsearch.model.DeleteIndexFieldResult;
import com.amazonaws.services.cloudsearch.model.DeleteRankExpressionRequest;
import com.amazonaws.services.cloudsearch.model.DeleteRankExpressionResult;
import com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldRequest;
import com.amazonaws.services.cloudsearch.model.DescribeDefaultSearchFieldResult;
import com.amazonaws.services.cloudsearch.model.DescribeDomainsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeDomainsResult;
import com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeIndexFieldsResult;
import com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeRankExpressionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearch.model.DescribeServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeStemmingOptionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeStopwordOptionsResult;
import com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsRequest;
import com.amazonaws.services.cloudsearch.model.DescribeSynonymOptionsResult;
import com.amazonaws.services.cloudsearch.model.IndexDocumentsRequest;
import com.amazonaws.services.cloudsearch.model.IndexDocumentsResult;
import com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldRequest;
import com.amazonaws.services.cloudsearch.model.UpdateDefaultSearchFieldResult;
import com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import com.amazonaws.services.cloudsearch.model.UpdateServiceAccessPoliciesResult;
import com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateStemmingOptionsResult;
import com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateStopwordOptionsResult;
import com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsRequest;
import com.amazonaws.services.cloudsearch.model.UpdateSynonymOptionsResult;
import com.amazonaws.services.cloudsearch.model.transform.BaseExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.CreateDomainRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.CreateDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineRankExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DefineRankExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteDomainRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteDomainResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteIndexFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteIndexFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteRankExpressionRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DeleteRankExpressionResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDefaultSearchFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDefaultSearchFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDomainsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeDomainsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeIndexFieldsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeIndexFieldsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeRankExpressionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeRankExpressionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStemmingOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStemmingOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStopwordOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeStopwordOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeSynonymOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.DescribeSynonymOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.IndexDocumentsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.IndexDocumentsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.InvalidTypeExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateDefaultSearchFieldRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateDefaultSearchFieldResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateServiceAccessPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStemmingOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStemmingOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStopwordOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateStopwordOptionsResultStaxUnmarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateSynonymOptionsRequestMarshaller;
import com.amazonaws.services.cloudsearch.model.transform.UpdateSynonymOptionsResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudSearchClient
extends AmazonWebServiceClient
implements AmazonCloudSearch {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonCloudSearchClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudSearchClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudSearchClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudSearchClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudSearchClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new BaseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidTypeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudsearch.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudsearch/request.handlers"));
    }

    @Override
    public UpdateDefaultSearchFieldResult updateDefaultSearchField(UpdateDefaultSearchFieldRequest updateDefaultSearchFieldRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateDefaultSearchFieldRequest> request = new UpdateDefaultSearchFieldRequestMarshaller().marshall(updateDefaultSearchFieldRequest);
        return this.invoke(request, new UpdateDefaultSearchFieldResultStaxUnmarshaller());
    }

    @Override
    public DeleteRankExpressionResult deleteRankExpression(DeleteRankExpressionRequest deleteRankExpressionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteRankExpressionRequest> request = new DeleteRankExpressionRequestMarshaller().marshall(deleteRankExpressionRequest);
        return this.invoke(request, new DeleteRankExpressionResultStaxUnmarshaller());
    }

    @Override
    public DescribeRankExpressionsResult describeRankExpressions(DescribeRankExpressionsRequest describeRankExpressionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeRankExpressionsRequest> request = new DescribeRankExpressionsRequestMarshaller().marshall(describeRankExpressionsRequest);
        return this.invoke(request, new DescribeRankExpressionsResultStaxUnmarshaller());
    }

    @Override
    public CreateDomainResult createDomain(CreateDomainRequest createDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDomainRequest> request = new CreateDomainRequestMarshaller().marshall(createDomainRequest);
        return this.invoke(request, new CreateDomainResultStaxUnmarshaller());
    }

    @Override
    public UpdateServiceAccessPoliciesResult updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateServiceAccessPoliciesRequest> request = new UpdateServiceAccessPoliciesRequestMarshaller().marshall(updateServiceAccessPoliciesRequest);
        return this.invoke(request, new UpdateServiceAccessPoliciesResultStaxUnmarshaller());
    }

    @Override
    public DefineIndexFieldResult defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) throws AmazonServiceException, AmazonClientException {
        Request<DefineIndexFieldRequest> request = new DefineIndexFieldRequestMarshaller().marshall(defineIndexFieldRequest);
        return this.invoke(request, new DefineIndexFieldResultStaxUnmarshaller());
    }

    @Override
    public DefineRankExpressionResult defineRankExpression(DefineRankExpressionRequest defineRankExpressionRequest) throws AmazonServiceException, AmazonClientException {
        Request<DefineRankExpressionRequest> request = new DefineRankExpressionRequestMarshaller().marshall(defineRankExpressionRequest);
        return this.invoke(request, new DefineRankExpressionResultStaxUnmarshaller());
    }

    @Override
    public DescribeSynonymOptionsResult describeSynonymOptions(DescribeSynonymOptionsRequest describeSynonymOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeSynonymOptionsRequest> request = new DescribeSynonymOptionsRequestMarshaller().marshall(describeSynonymOptionsRequest);
        return this.invoke(request, new DescribeSynonymOptionsResultStaxUnmarshaller());
    }

    @Override
    public DescribeStopwordOptionsResult describeStopwordOptions(DescribeStopwordOptionsRequest describeStopwordOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStopwordOptionsRequest> request = new DescribeStopwordOptionsRequestMarshaller().marshall(describeStopwordOptionsRequest);
        return this.invoke(request, new DescribeStopwordOptionsResultStaxUnmarshaller());
    }

    @Override
    public DeleteDomainResult deleteDomain(DeleteDomainRequest deleteDomainRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDomainRequest> request = new DeleteDomainRequestMarshaller().marshall(deleteDomainRequest);
        return this.invoke(request, new DeleteDomainResultStaxUnmarshaller());
    }

    @Override
    public DescribeServiceAccessPoliciesResult describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeServiceAccessPoliciesRequest> request = new DescribeServiceAccessPoliciesRequestMarshaller().marshall(describeServiceAccessPoliciesRequest);
        return this.invoke(request, new DescribeServiceAccessPoliciesResultStaxUnmarshaller());
    }

    @Override
    public DescribeDefaultSearchFieldResult describeDefaultSearchField(DescribeDefaultSearchFieldRequest describeDefaultSearchFieldRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDefaultSearchFieldRequest> request = new DescribeDefaultSearchFieldRequestMarshaller().marshall(describeDefaultSearchFieldRequest);
        return this.invoke(request, new DescribeDefaultSearchFieldResultStaxUnmarshaller());
    }

    @Override
    public UpdateStopwordOptionsResult updateStopwordOptions(UpdateStopwordOptionsRequest updateStopwordOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateStopwordOptionsRequest> request = new UpdateStopwordOptionsRequestMarshaller().marshall(updateStopwordOptionsRequest);
        return this.invoke(request, new UpdateStopwordOptionsResultStaxUnmarshaller());
    }

    @Override
    public UpdateSynonymOptionsResult updateSynonymOptions(UpdateSynonymOptionsRequest updateSynonymOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateSynonymOptionsRequest> request = new UpdateSynonymOptionsRequestMarshaller().marshall(updateSynonymOptionsRequest);
        return this.invoke(request, new UpdateSynonymOptionsResultStaxUnmarshaller());
    }

    @Override
    public UpdateStemmingOptionsResult updateStemmingOptions(UpdateStemmingOptionsRequest updateStemmingOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateStemmingOptionsRequest> request = new UpdateStemmingOptionsRequestMarshaller().marshall(updateStemmingOptionsRequest);
        return this.invoke(request, new UpdateStemmingOptionsResultStaxUnmarshaller());
    }

    @Override
    public DescribeStemmingOptionsResult describeStemmingOptions(DescribeStemmingOptionsRequest describeStemmingOptionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStemmingOptionsRequest> request = new DescribeStemmingOptionsRequestMarshaller().marshall(describeStemmingOptionsRequest);
        return this.invoke(request, new DescribeStemmingOptionsResultStaxUnmarshaller());
    }

    @Override
    public DescribeDomainsResult describeDomains(DescribeDomainsRequest describeDomainsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDomainsRequest> request = new DescribeDomainsRequestMarshaller().marshall(describeDomainsRequest);
        return this.invoke(request, new DescribeDomainsResultStaxUnmarshaller());
    }

    @Override
    public IndexDocumentsResult indexDocuments(IndexDocumentsRequest indexDocumentsRequest) throws AmazonServiceException, AmazonClientException {
        Request<IndexDocumentsRequest> request = new IndexDocumentsRequestMarshaller().marshall(indexDocumentsRequest);
        return this.invoke(request, new IndexDocumentsResultStaxUnmarshaller());
    }

    @Override
    public DescribeIndexFieldsResult describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeIndexFieldsRequest> request = new DescribeIndexFieldsRequestMarshaller().marshall(describeIndexFieldsRequest);
        return this.invoke(request, new DescribeIndexFieldsResultStaxUnmarshaller());
    }

    @Override
    public DeleteIndexFieldResult deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteIndexFieldRequest> request = new DeleteIndexFieldRequestMarshaller().marshall(deleteIndexFieldRequest);
        return this.invoke(request, new DeleteIndexFieldResultStaxUnmarshaller());
    }

    @Override
    public DescribeDomainsResult describeDomains() throws AmazonServiceException, AmazonClientException {
        return this.describeDomains(new DescribeDomainsRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "cloudsearch";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext(originalRequest);
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

