/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.GetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.GetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.services.glacier.model.ListJobsResult;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.services.glacier.model.ListMultipartUploadsResult;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.ListPartsResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartResult;
import com.amazonaws.services.glacier.model.transform.AbortMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.MissingParameterValueExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartResultJsonUnmarshaller;
import com.amazonaws.transform.GlacierErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonGlacierClient
extends AmazonWebServiceClient
implements AmazonGlacier {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonGlacier.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonGlacierClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonGlacierClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new MissingParameterValueExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new RequestTimeoutExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ServiceUnavailableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new GlacierErrorUnmarshaller());
        this.setEndpoint("glacier.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/glacier/request.handlers"));
    }

    @Override
    public ListVaultsResult listVaults(ListVaultsRequest listVaultsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listVaultsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListVaultsRequest> request = new ListVaultsRequestMarshaller().marshall(listVaultsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListVaultsResultJsonUnmarshaller unmarshaller = new ListVaultsResultJsonUnmarshaller();
        JsonResponseHandler<ListVaultsResult> responseHandler = new JsonResponseHandler<ListVaultsResult>(unmarshaller);
        return (ListVaultsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeJobResult describeJob(DescribeJobRequest describeJobRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeJobRequest> request = new DescribeJobRequestMarshaller().marshall(describeJobRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeJobResultJsonUnmarshaller unmarshaller = new DescribeJobResultJsonUnmarshaller();
        JsonResponseHandler<DescribeJobResult> responseHandler = new JsonResponseHandler<DescribeJobResult>(unmarshaller);
        return (DescribeJobResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListPartsResult listParts(ListPartsRequest listPartsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listPartsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListPartsRequest> request = new ListPartsRequestMarshaller().marshall(listPartsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListPartsResultJsonUnmarshaller unmarshaller = new ListPartsResultJsonUnmarshaller();
        JsonResponseHandler<ListPartsResult> responseHandler = new JsonResponseHandler<ListPartsResult>(unmarshaller);
        return (ListPartsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public GetVaultNotificationsResult getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<GetVaultNotificationsRequest> request = new GetVaultNotificationsRequestMarshaller().marshall(getVaultNotificationsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        GetVaultNotificationsResultJsonUnmarshaller unmarshaller = new GetVaultNotificationsResultJsonUnmarshaller();
        JsonResponseHandler<GetVaultNotificationsResult> responseHandler = new JsonResponseHandler<GetVaultNotificationsResult>(unmarshaller);
        return (GetVaultNotificationsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListJobsRequest> request = new ListJobsRequestMarshaller().marshall(listJobsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListJobsResultJsonUnmarshaller unmarshaller = new ListJobsResultJsonUnmarshaller();
        JsonResponseHandler<ListJobsResult> responseHandler = new JsonResponseHandler<ListJobsResult>(unmarshaller);
        return (ListJobsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateVaultResult createVault(CreateVaultRequest createVaultRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(createVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateVaultRequest> request = new CreateVaultRequestMarshaller().marshall(createVaultRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateVaultResultJsonUnmarshaller unmarshaller = new CreateVaultResultJsonUnmarshaller();
        JsonResponseHandler<CreateVaultResult> responseHandler = new JsonResponseHandler<CreateVaultResult>(unmarshaller);
        return (CreateVaultResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(initiateMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<InitiateMultipartUploadRequest> request = new InitiateMultipartUploadRequestMarshaller().marshall(initiateMultipartUploadRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        InitiateMultipartUploadResultJsonUnmarshaller unmarshaller = new InitiateMultipartUploadResultJsonUnmarshaller();
        JsonResponseHandler<InitiateMultipartUploadResult> responseHandler = new JsonResponseHandler<InitiateMultipartUploadResult>(unmarshaller);
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(abortMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<AbortMultipartUploadRequest> request = new AbortMultipartUploadRequestMarshaller().marshall(abortMultipartUploadRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void deleteArchive(DeleteArchiveRequest deleteArchiveRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteArchiveRequest> request = new DeleteArchiveRequestMarshaller().marshall(deleteArchiveRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public GetJobOutputResult getJobOutput(GetJobOutputRequest getJobOutputRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(getJobOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<GetJobOutputRequest> request = new GetJobOutputRequestMarshaller().marshall(getJobOutputRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        GetJobOutputResultJsonUnmarshaller unmarshaller = new GetJobOutputResultJsonUnmarshaller();
        JsonResponseHandler<GetJobOutputResult> responseHandler = new JsonResponseHandler<GetJobOutputResult>(unmarshaller);
        responseHandler.needsConnectionLeftOpen = true;
        return (GetJobOutputResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public InitiateJobResult initiateJob(InitiateJobRequest initiateJobRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(initiateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<InitiateJobRequest> request = new InitiateJobRequestMarshaller().marshall(initiateJobRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        InitiateJobResultJsonUnmarshaller unmarshaller = new InitiateJobResultJsonUnmarshaller();
        JsonResponseHandler<InitiateJobResult> responseHandler = new JsonResponseHandler<InitiateJobResult>(unmarshaller);
        return (InitiateJobResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UploadArchiveResult uploadArchive(UploadArchiveRequest uploadArchiveRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(uploadArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UploadArchiveRequest> request = new UploadArchiveRequestMarshaller().marshall(uploadArchiveRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UploadArchiveResultJsonUnmarshaller unmarshaller = new UploadArchiveResultJsonUnmarshaller();
        JsonResponseHandler<UploadArchiveResult> responseHandler = new JsonResponseHandler<UploadArchiveResult>(unmarshaller);
        return (UploadArchiveResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(setVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<SetVaultNotificationsRequest> request = new SetVaultNotificationsRequestMarshaller().marshall(setVaultNotificationsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(completeMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CompleteMultipartUploadRequest> request = new CompleteMultipartUploadRequestMarshaller().marshall(completeMultipartUploadRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CompleteMultipartUploadResultJsonUnmarshaller unmarshaller = new CompleteMultipartUploadResultJsonUnmarshaller();
        JsonResponseHandler<CompleteMultipartUploadResult> responseHandler = new JsonResponseHandler<CompleteMultipartUploadResult>(unmarshaller);
        return (CompleteMultipartUploadResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UploadMultipartPartResult uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(uploadMultipartPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UploadMultipartPartRequest> request = new UploadMultipartPartRequestMarshaller().marshall(uploadMultipartPartRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UploadMultipartPartResultJsonUnmarshaller unmarshaller = new UploadMultipartPartResultJsonUnmarshaller();
        JsonResponseHandler<UploadMultipartPartResult> responseHandler = new JsonResponseHandler<UploadMultipartPartResult>(unmarshaller);
        return (UploadMultipartPartResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DescribeVaultResult describeVault(DescribeVaultRequest describeVaultRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(describeVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DescribeVaultRequest> request = new DescribeVaultRequestMarshaller().marshall(describeVaultRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DescribeVaultResultJsonUnmarshaller unmarshaller = new DescribeVaultResultJsonUnmarshaller();
        JsonResponseHandler<DescribeVaultResult> responseHandler = new JsonResponseHandler<DescribeVaultResult>(unmarshaller);
        return (DescribeVaultResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteVaultNotificationsRequest> request = new DeleteVaultNotificationsRequestMarshaller().marshall(deleteVaultNotificationsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListMultipartUploadsResult listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(listMultipartUploadsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListMultipartUploadsRequest> request = new ListMultipartUploadsRequestMarshaller().marshall(listMultipartUploadsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListMultipartUploadsResultJsonUnmarshaller unmarshaller = new ListMultipartUploadsResultJsonUnmarshaller();
        JsonResponseHandler<ListMultipartUploadsResult> responseHandler = new JsonResponseHandler<ListMultipartUploadsResult>(unmarshaller);
        return (ListMultipartUploadsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public void deleteVault(DeleteVaultRequest deleteVaultRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeleteVaultRequest> request = new DeleteVaultRequestMarshaller().marshall(deleteVaultRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "glacier";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (X)result;
    }
}

