/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoder;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import com.amazonaws.services.elastictranscoder.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.IncompatibleVersionExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticTranscoderClient
extends AmazonWebServiceClient
implements AmazonElasticTranscoder {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticTranscoder.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonElasticTranscoderClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ValidationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IncompatibleVersionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AccessDeniedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("elastictranscoder.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("elastictranscoder");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elastictranscoder/request.handlers"));
    }

    @Override
    public UpdatePipelineStatusResult updatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdatePipelineStatusRequest> request = new UpdatePipelineStatusRequestMarshaller().marshall(updatePipelineStatusRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdatePipelineStatusResultJsonUnmarshaller unmarshaller = new UpdatePipelineStatusResultJsonUnmarshaller();
        JsonResponseHandler<UpdatePipelineStatusResult> responseHandler = new JsonResponseHandler<UpdatePipelineStatusResult>(unmarshaller);
        return (UpdatePipelineStatusResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdatePipelineNotificationsResult updatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdatePipelineNotificationsRequest> request = new UpdatePipelineNotificationsRequestMarshaller().marshall(updatePipelineNotificationsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdatePipelineNotificationsResultJsonUnmarshaller unmarshaller = new UpdatePipelineNotificationsResultJsonUnmarshaller();
        JsonResponseHandler<UpdatePipelineNotificationsResult> responseHandler = new JsonResponseHandler<UpdatePipelineNotificationsResult>(unmarshaller);
        return (UpdatePipelineNotificationsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ReadJobResult readJob(ReadJobRequest readJobRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ReadJobRequest> request = new ReadJobRequestMarshaller().marshall(readJobRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ReadJobResultJsonUnmarshaller unmarshaller = new ReadJobResultJsonUnmarshaller();
        JsonResponseHandler<ReadJobResult> responseHandler = new JsonResponseHandler<ReadJobResult>(unmarshaller);
        return (ReadJobResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListJobsByStatusResult listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListJobsByStatusRequest> request = new ListJobsByStatusRequestMarshaller().marshall(listJobsByStatusRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListJobsByStatusResultJsonUnmarshaller unmarshaller = new ListJobsByStatusResultJsonUnmarshaller();
        JsonResponseHandler<ListJobsByStatusResult> responseHandler = new JsonResponseHandler<ListJobsByStatusResult>(unmarshaller);
        return (ListJobsByStatusResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ReadPresetResult readPreset(ReadPresetRequest readPresetRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ReadPresetRequest> request = new ReadPresetRequestMarshaller().marshall(readPresetRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ReadPresetResultJsonUnmarshaller unmarshaller = new ReadPresetResultJsonUnmarshaller();
        JsonResponseHandler<ReadPresetResult> responseHandler = new JsonResponseHandler<ReadPresetResult>(unmarshaller);
        return (ReadPresetResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreatePipelineRequest> request = new CreatePipelineRequestMarshaller().marshall(createPipelineRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreatePipelineResultJsonUnmarshaller unmarshaller = new CreatePipelineResultJsonUnmarshaller();
        JsonResponseHandler<CreatePipelineResult> responseHandler = new JsonResponseHandler<CreatePipelineResult>(unmarshaller);
        return (CreatePipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CancelJobRequest> request = new CancelJobRequestMarshaller().marshall(cancelJobRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CancelJobResultJsonUnmarshaller unmarshaller = new CancelJobResultJsonUnmarshaller();
        JsonResponseHandler<CancelJobResult> responseHandler = new JsonResponseHandler<CancelJobResult>(unmarshaller);
        return (CancelJobResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest updatePipelineRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<UpdatePipelineRequest> request = new UpdatePipelineRequestMarshaller().marshall(updatePipelineRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        UpdatePipelineResultJsonUnmarshaller unmarshaller = new UpdatePipelineResultJsonUnmarshaller();
        JsonResponseHandler<UpdatePipelineResult> responseHandler = new JsonResponseHandler<UpdatePipelineResult>(unmarshaller);
        return (UpdatePipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListPresetsResult listPresets(ListPresetsRequest listPresetsRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListPresetsRequest> request = new ListPresetsRequestMarshaller().marshall(listPresetsRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListPresetsResultJsonUnmarshaller unmarshaller = new ListPresetsResultJsonUnmarshaller();
        JsonResponseHandler<ListPresetsResult> responseHandler = new JsonResponseHandler<ListPresetsResult>(unmarshaller);
        return (ListPresetsResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest deletePipelineRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeletePipelineRequest> request = new DeletePipelineRequestMarshaller().marshall(deletePipelineRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeletePipelineResultJsonUnmarshaller unmarshaller = new DeletePipelineResultJsonUnmarshaller();
        JsonResponseHandler<DeletePipelineResult> responseHandler = new JsonResponseHandler<DeletePipelineResult>(unmarshaller);
        return (DeletePipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public TestRoleResult testRole(TestRoleRequest testRoleRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<TestRoleRequest> request = new TestRoleRequestMarshaller().marshall(testRoleRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        TestRoleResultJsonUnmarshaller unmarshaller = new TestRoleResultJsonUnmarshaller();
        JsonResponseHandler<TestRoleResult> responseHandler = new JsonResponseHandler<TestRoleResult>(unmarshaller);
        return (TestRoleResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListPipelinesRequest> request = new ListPipelinesRequestMarshaller().marshall(listPipelinesRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListPipelinesResultJsonUnmarshaller unmarshaller = new ListPipelinesResultJsonUnmarshaller();
        JsonResponseHandler<ListPipelinesResult> responseHandler = new JsonResponseHandler<ListPipelinesResult>(unmarshaller);
        return (ListPipelinesResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ReadPipelineResult readPipeline(ReadPipelineRequest readPipelineRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ReadPipelineRequest> request = new ReadPipelineRequestMarshaller().marshall(readPipelineRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ReadPipelineResultJsonUnmarshaller unmarshaller = new ReadPipelineResultJsonUnmarshaller();
        JsonResponseHandler<ReadPipelineResult> responseHandler = new JsonResponseHandler<ReadPipelineResult>(unmarshaller);
        return (ReadPipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreatePresetResult createPreset(CreatePresetRequest createPresetRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreatePresetRequest> request = new CreatePresetRequestMarshaller().marshall(createPresetRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreatePresetResultJsonUnmarshaller unmarshaller = new CreatePresetResultJsonUnmarshaller();
        JsonResponseHandler<CreatePresetResult> responseHandler = new JsonResponseHandler<CreatePresetResult>(unmarshaller);
        return (CreatePresetResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public DeletePresetResult deletePreset(DeletePresetRequest deletePresetRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<DeletePresetRequest> request = new DeletePresetRequestMarshaller().marshall(deletePresetRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        DeletePresetResultJsonUnmarshaller unmarshaller = new DeletePresetResultJsonUnmarshaller();
        JsonResponseHandler<DeletePresetResult> responseHandler = new JsonResponseHandler<DeletePresetResult>(unmarshaller);
        return (DeletePresetResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<CreateJobRequest> request = new CreateJobRequestMarshaller().marshall(createJobRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        CreateJobResultJsonUnmarshaller unmarshaller = new CreateJobResultJsonUnmarshaller();
        JsonResponseHandler<CreateJobResult> responseHandler = new JsonResponseHandler<CreateJobResult>(unmarshaller);
        return (CreateJobResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public ListJobsByPipelineResult listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) throws AmazonServiceException, AmazonClientException {
        ExecutionContext executionContext = this.createExecutionContext();
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        Request<ListJobsByPipelineRequest> request = new ListJobsByPipelineRequestMarshaller().marshall(listJobsByPipelineRequest);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime.name());
        ListJobsByPipelineResultJsonUnmarshaller unmarshaller = new ListJobsByPipelineResultJsonUnmarshaller();
        JsonResponseHandler<ListJobsByPipelineResult> responseHandler = new JsonResponseHandler<ListJobsByPipelineResult>(unmarshaller);
        return (ListJobsByPipelineResult)this.invoke(request, responseHandler, executionContext);
    }

    @Override
    public UpdatePipelineStatusResult updatePipelineStatus() throws AmazonServiceException, AmazonClientException {
        return this.updatePipelineStatus(new UpdatePipelineStatusRequest());
    }

    @Override
    public UpdatePipelineNotificationsResult updatePipelineNotifications() throws AmazonServiceException, AmazonClientException {
        return this.updatePipelineNotifications(new UpdatePipelineNotificationsRequest());
    }

    @Override
    public ReadJobResult readJob() throws AmazonServiceException, AmazonClientException {
        return this.readJob(new ReadJobRequest());
    }

    @Override
    public ListJobsByStatusResult listJobsByStatus() throws AmazonServiceException, AmazonClientException {
        return this.listJobsByStatus(new ListJobsByStatusRequest());
    }

    @Override
    public ReadPresetResult readPreset() throws AmazonServiceException, AmazonClientException {
        return this.readPreset(new ReadPresetRequest());
    }

    @Override
    public CreatePipelineResult createPipeline() throws AmazonServiceException, AmazonClientException {
        return this.createPipeline(new CreatePipelineRequest());
    }

    @Override
    public CancelJobResult cancelJob() throws AmazonServiceException, AmazonClientException {
        return this.cancelJob(new CancelJobRequest());
    }

    @Override
    public ListPresetsResult listPresets() throws AmazonServiceException, AmazonClientException {
        return this.listPresets(new ListPresetsRequest());
    }

    @Override
    public DeletePipelineResult deletePipeline() throws AmazonServiceException, AmazonClientException {
        return this.deletePipeline(new DeletePipelineRequest());
    }

    @Override
    public TestRoleResult testRole() throws AmazonServiceException, AmazonClientException {
        return this.testRole(new TestRoleRequest());
    }

    @Override
    public ListPipelinesResult listPipelines() throws AmazonServiceException, AmazonClientException {
        return this.listPipelines(new ListPipelinesRequest());
    }

    @Override
    public ReadPipelineResult readPipeline() throws AmazonServiceException, AmazonClientException {
        return this.readPipeline(new ReadPipelineRequest());
    }

    @Override
    public CreatePresetResult createPreset() throws AmazonServiceException, AmazonClientException {
        return this.createPreset(new CreatePresetRequest());
    }

    @Override
    public DeletePresetResult deletePreset() throws AmazonServiceException, AmazonClientException {
        return this.deletePreset(new DeletePresetRequest());
    }

    @Override
    public CreateJobResult createJob() throws AmazonServiceException, AmazonClientException {
        return this.createJob(new CreateJobRequest());
    }

    @Override
    public ListJobsByPipelineResult listJobsByPipeline() throws AmazonServiceException, AmazonClientException {
        return this.listJobsByPipeline(new ListJobsByPipelineRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elastictranscoder";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) throws AmazonClientException {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime.name());
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.endEvent(AWSRequestMetrics.Field.ClientExecuteTime.name());
        awsRequestMetrics.log();
        return (X)result;
    }
}

