/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.amazonaws.services.ec2.model.ReservedInstanceLimitPrice;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PurchaseReservedInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedInstancesOfferingRequest>, PurchaseReservedInstancesOfferingRequest> {
    @Override
    public Request<PurchaseReservedInstancesOfferingRequest> marshall(PurchaseReservedInstancesOfferingRequest purchaseReservedInstancesOfferingRequest) {
        ReservedInstanceLimitPrice reservedInstanceLimitPriceLimitPrice;
        if (purchaseReservedInstancesOfferingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurchaseReservedInstancesOfferingRequest> request = new DefaultRequest<PurchaseReservedInstancesOfferingRequest>(purchaseReservedInstancesOfferingRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseReservedInstancesOffering");
        request.addParameter("Version", "2013-07-15");
        if (purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId() != null) {
            request.addParameter("ReservedInstancesOfferingId", StringUtils.fromString(purchaseReservedInstancesOfferingRequest.getReservedInstancesOfferingId()));
        }
        if (purchaseReservedInstancesOfferingRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger(purchaseReservedInstancesOfferingRequest.getInstanceCount()));
        }
        if ((reservedInstanceLimitPriceLimitPrice = purchaseReservedInstancesOfferingRequest.getLimitPrice()) != null) {
            if (reservedInstanceLimitPriceLimitPrice.getAmount() != null) {
                request.addParameter("LimitPrice.Amount", StringUtils.fromDouble(reservedInstanceLimitPriceLimitPrice.getAmount()));
            }
            if (reservedInstanceLimitPriceLimitPrice.getCurrencyCode() != null) {
                request.addParameter("LimitPrice.CurrencyCode", StringUtils.fromString(reservedInstanceLimitPriceLimitPrice.getCurrencyCode()));
            }
        }
        return request;
    }
}

