/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model;

import com.amazonaws.services.simpledb.model.Item;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectResult
implements Serializable {
    private List<Item> items;
    private String nextToken;

    public List<Item> getItems() {
        if (this.items == null) {
            this.items = new ArrayList<Item>();
        }
        return this.items;
    }

    public void setItems(Collection<Item> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ArrayList<Item> itemsCopy = new ArrayList<Item>(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public SelectResult withItems(Item ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<Item>(items.length));
        }
        for (Item value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public SelectResult withItems(Collection<Item> items) {
        if (items == null) {
            this.items = null;
        } else {
            ArrayList<Item> itemsCopy = new ArrayList<Item>(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public SelectResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectResult)) {
            return false;
        }
        SelectResult other = (SelectResult)obj;
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !((Object)other.getItems()).equals(this.getItems())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

