/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.KeysAndAttributes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchGetItemResult
implements Serializable {
    private Map<String, List<Map<String, AttributeValue>>> responses;
    private Map<String, KeysAndAttributes> unprocessedKeys;
    private ListWithAutoConstructFlag<ConsumedCapacity> consumedCapacity;

    public Map<String, List<Map<String, AttributeValue>>> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, List<Map<String, AttributeValue>>> responses) {
        this.responses = responses;
    }

    public BatchGetItemResult withResponses(Map<String, List<Map<String, AttributeValue>>> responses) {
        this.setResponses(responses);
        return this;
    }

    public Map<String, KeysAndAttributes> getUnprocessedKeys() {
        return this.unprocessedKeys;
    }

    public void setUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.unprocessedKeys = unprocessedKeys;
    }

    public BatchGetItemResult withUnprocessedKeys(Map<String, KeysAndAttributes> unprocessedKeys) {
        this.setUnprocessedKeys(unprocessedKeys);
        return this;
    }

    public List<ConsumedCapacity> getConsumedCapacity() {
        return this.consumedCapacity;
    }

    public void setConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
            return;
        }
        ListWithAutoConstructFlag consumedCapacityCopy = new ListWithAutoConstructFlag(consumedCapacity.size());
        consumedCapacityCopy.addAll(consumedCapacity);
        this.consumedCapacity = consumedCapacityCopy;
    }

    public BatchGetItemResult withConsumedCapacity(ConsumedCapacity ... consumedCapacity) {
        if (this.getConsumedCapacity() == null) {
            this.setConsumedCapacity(new ArrayList<ConsumedCapacity>(consumedCapacity.length));
        }
        for (ConsumedCapacity value : consumedCapacity) {
            this.getConsumedCapacity().add(value);
        }
        return this;
    }

    public BatchGetItemResult withConsumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
        if (consumedCapacity == null) {
            this.consumedCapacity = null;
        } else {
            ListWithAutoConstructFlag consumedCapacityCopy = new ListWithAutoConstructFlag(consumedCapacity.size());
            consumedCapacityCopy.addAll(consumedCapacity);
            this.consumedCapacity = consumedCapacityCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResponses() != null) {
            sb.append("Responses: " + this.getResponses() + ",");
        }
        if (this.getUnprocessedKeys() != null) {
            sb.append("UnprocessedKeys: " + this.getUnprocessedKeys() + ",");
        }
        if (this.getConsumedCapacity() != null) {
            sb.append("ConsumedCapacity: " + this.getConsumedCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResponses() == null ? 0 : ((Object)this.getResponses()).hashCode());
        hashCode = 31 * hashCode + (this.getUnprocessedKeys() == null ? 0 : ((Object)this.getUnprocessedKeys()).hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacity() == null ? 0 : ((Object)this.getConsumedCapacity()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetItemResult)) {
            return false;
        }
        BatchGetItemResult other = (BatchGetItemResult)obj;
        if (other.getResponses() == null ^ this.getResponses() == null) {
            return false;
        }
        if (other.getResponses() != null && !((Object)other.getResponses()).equals(this.getResponses())) {
            return false;
        }
        if (other.getUnprocessedKeys() == null ^ this.getUnprocessedKeys() == null) {
            return false;
        }
        if (other.getUnprocessedKeys() != null && !((Object)other.getUnprocessedKeys()).equals(this.getUnprocessedKeys())) {
            return false;
        }
        if (other.getConsumedCapacity() == null ^ this.getConsumedCapacity() == null) {
            return false;
        }
        return other.getConsumedCapacity() == null || ((Object)other.getConsumedCapacity()).equals(this.getConsumedCapacity());
    }
}

