/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.services.elasticbeanstalk.model.ConfigurationDeploymentStatus;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationSettingsDescription
implements Serializable {
    private String solutionStackName;
    private String applicationName;
    private String templateName;
    private String description;
    private String environmentName;
    private String deploymentStatus;
    private Date dateCreated;
    private Date dateUpdated;
    private List<ConfigurationOptionSetting> optionSettings;

    public String getSolutionStackName() {
        return this.solutionStackName;
    }

    public void setSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
    }

    public ConfigurationSettingsDescription withSolutionStackName(String solutionStackName) {
        this.solutionStackName = solutionStackName;
        return this;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public ConfigurationSettingsDescription withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public ConfigurationSettingsDescription withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ConfigurationSettingsDescription withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    public ConfigurationSettingsDescription withEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
        return this;
    }

    public String getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public void setDeploymentStatus(String deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
    }

    public ConfigurationSettingsDescription withDeploymentStatus(String deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
        return this;
    }

    public void setDeploymentStatus(ConfigurationDeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus.toString();
    }

    public ConfigurationSettingsDescription withDeploymentStatus(ConfigurationDeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus.toString();
        return this;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public ConfigurationSettingsDescription withDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    public Date getDateUpdated() {
        return this.dateUpdated;
    }

    public void setDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
    }

    public ConfigurationSettingsDescription withDateUpdated(Date dateUpdated) {
        this.dateUpdated = dateUpdated;
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<ConfigurationOptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>(optionSettings.size());
        optionSettingsCopy.addAll(optionSettings);
        this.optionSettings = optionSettingsCopy;
    }

    public ConfigurationSettingsDescription withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<ConfigurationOptionSetting>(optionSettings.length));
        }
        for (ConfigurationOptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public ConfigurationSettingsDescription withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
        } else {
            ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>(optionSettings.size());
            optionSettingsCopy.addAll(optionSettings);
            this.optionSettings = optionSettingsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSolutionStackName() != null) {
            sb.append("SolutionStackName: " + this.getSolutionStackName() + ", ");
        }
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ", ");
        }
        if (this.getTemplateName() != null) {
            sb.append("TemplateName: " + this.getTemplateName() + ", ");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ", ");
        }
        if (this.getEnvironmentName() != null) {
            sb.append("EnvironmentName: " + this.getEnvironmentName() + ", ");
        }
        if (this.getDeploymentStatus() != null) {
            sb.append("DeploymentStatus: " + this.getDeploymentStatus() + ", ");
        }
        if (this.getDateCreated() != null) {
            sb.append("DateCreated: " + this.getDateCreated() + ", ");
        }
        if (this.getDateUpdated() != null) {
            sb.append("DateUpdated: " + this.getDateUpdated() + ", ");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: " + this.getOptionSettings() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSolutionStackName() == null ? 0 : this.getSolutionStackName().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getTemplateName() == null ? 0 : this.getTemplateName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironmentName() == null ? 0 : this.getEnvironmentName().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentStatus() == null ? 0 : this.getDeploymentStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDateCreated() == null ? 0 : this.getDateCreated().hashCode());
        hashCode = 31 * hashCode + (this.getDateUpdated() == null ? 0 : this.getDateUpdated().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : ((Object)this.getOptionSettings()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationSettingsDescription)) {
            return false;
        }
        ConfigurationSettingsDescription other = (ConfigurationSettingsDescription)obj;
        if (other.getSolutionStackName() == null ^ this.getSolutionStackName() == null) {
            return false;
        }
        if (other.getSolutionStackName() != null && !other.getSolutionStackName().equals(this.getSolutionStackName())) {
            return false;
        }
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getTemplateName() == null ^ this.getTemplateName() == null) {
            return false;
        }
        if (other.getTemplateName() != null && !other.getTemplateName().equals(this.getTemplateName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEnvironmentName() == null ^ this.getEnvironmentName() == null) {
            return false;
        }
        if (other.getEnvironmentName() != null && !other.getEnvironmentName().equals(this.getEnvironmentName())) {
            return false;
        }
        if (other.getDeploymentStatus() == null ^ this.getDeploymentStatus() == null) {
            return false;
        }
        if (other.getDeploymentStatus() != null && !other.getDeploymentStatus().equals(this.getDeploymentStatus())) {
            return false;
        }
        if (other.getDateCreated() == null ^ this.getDateCreated() == null) {
            return false;
        }
        if (other.getDateCreated() != null && !other.getDateCreated().equals(this.getDateCreated())) {
            return false;
        }
        if (other.getDateUpdated() == null ^ this.getDateUpdated() == null) {
            return false;
        }
        if (other.getDateUpdated() != null && !other.getDateUpdated().equals(this.getDateUpdated())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        return other.getOptionSettings() == null || ((Object)other.getOptionSettings()).equals(this.getOptionSettings());
    }
}

