/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.transform;

import com.amazonaws.http.HttpResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUnmarshallerContext {
    private final JsonParser jsonParser;
    private final Stack<String> stack = new Stack();
    private String stackString = "";
    private String currentField;
    private Map<String, String> metadata = new HashMap<String, String>();
    private List<MetadataExpression> metadataExpressions = new ArrayList<MetadataExpression>();
    public JsonToken currentToken;
    private JsonToken nextToken;
    private final HttpResponse httpResponse;

    public JsonUnmarshallerContext(JsonParser jsonParser) {
        this(jsonParser, null);
    }

    public JsonUnmarshallerContext(JsonParser jsonParser, HttpResponse httpResponse) {
        this.jsonParser = jsonParser;
        this.httpResponse = httpResponse;
    }

    public String getHeader(String header) {
        if (this.httpResponse == null) {
            return null;
        }
        return this.httpResponse.getHeaders().get(header);
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public int getCurrentDepth() {
        int depth = 0;
        for (String s : this.stack) {
            if (s.equals(JsonToken.START_OBJECT.asString()) || s.equals(JsonToken.START_ARRAY.toString())) continue;
            ++depth;
        }
        if (this.currentField != null) {
            ++depth;
        }
        return depth;
    }

    public String readText() throws IOException {
        switch (this.currentToken) {
            case VALUE_STRING: {
                String text = this.jsonParser.getText();
                return text;
            }
            case VALUE_FALSE: {
                return "false";
            }
            case VALUE_TRUE: {
                return "true";
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return this.jsonParser.getNumberValue().toString();
            }
            case FIELD_NAME: {
                return this.jsonParser.getText();
            }
        }
        throw new RuntimeException("We expected a VALUE token but got: " + this.currentToken);
    }

    public boolean isStartOfDocument() {
        return this.jsonParser == null || this.jsonParser.getCurrentToken() == null;
    }

    public boolean testExpression(String expression) {
        if (expression.equals(".")) {
            return true;
        }
        return this.stackString.endsWith(expression);
    }

    public boolean testExpression(String expression, int stackDepth) {
        if (expression.equals(".")) {
            return true;
        }
        int index = -1;
        while ((index = expression.indexOf("/", index + 1)) > -1) {
            if (expression.charAt(index + 1) == '@') continue;
            ++stackDepth;
        }
        return this.stackString.endsWith("/" + expression) && stackDepth == this.getCurrentDepth();
    }

    public JsonToken nextToken() throws IOException {
        JsonToken token;
        this.currentToken = token = this.nextToken != null ? this.nextToken : this.jsonParser.nextToken();
        this.nextToken = null;
        this.updateContext();
        return token;
    }

    public JsonToken peek() throws IOException {
        if (this.nextToken != null) {
            return this.nextToken;
        }
        this.nextToken = this.jsonParser.nextToken();
        return this.nextToken;
    }

    public JsonParser getJsonParser() {
        return this.jsonParser;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void registerMetadataExpression(String expression, int targetDepth, String storageKey) {
        this.metadataExpressions.add(new MetadataExpression(expression, targetDepth, storageKey));
    }

    private void updateContext() throws IOException {
        if (this.currentToken == null) {
            return;
        }
        if (this.currentToken == JsonToken.START_OBJECT || this.currentToken == JsonToken.START_ARRAY) {
            if (this.currentField != null) {
                this.stack.push(this.currentField);
                this.stack.push(this.currentToken.asString());
                this.currentField = null;
            }
        } else if (this.currentToken == JsonToken.END_OBJECT || this.currentToken == JsonToken.END_ARRAY) {
            if (!this.stack.isEmpty()) {
                boolean curlyBracketsMatch;
                boolean squareBracketsMatch = this.currentToken == JsonToken.END_ARRAY && this.stack.peek().equals(JsonToken.START_ARRAY.asString());
                boolean bl = curlyBracketsMatch = this.currentToken == JsonToken.END_OBJECT && this.stack.peek().equals(JsonToken.START_OBJECT.asString());
                if (squareBracketsMatch || curlyBracketsMatch) {
                    this.stack.pop();
                    this.stack.pop();
                }
            }
            this.currentField = null;
        } else if (this.currentToken == JsonToken.FIELD_NAME) {
            String t;
            this.currentField = t = this.jsonParser.getText();
        }
        this.rebuildStackString();
    }

    public String toString() {
        return this.stackString;
    }

    private void rebuildStackString() {
        this.stackString = "";
        for (String s : this.stack) {
            if (s.equals(JsonToken.START_ARRAY.asString()) || s.equals(JsonToken.START_OBJECT.asString())) continue;
            this.stackString = this.stackString + "/" + s;
        }
        if (this.currentField != null) {
            this.stackString = this.stackString + "/" + this.currentField;
        }
        if (this.stackString == "") {
            this.stackString = "/";
        }
    }

    private class MetadataExpression {
        public String expression;
        public int targetDepth;
        public String key;

        public MetadataExpression(String expression, int targetDepth, String key) {
            this.expression = expression;
            this.targetDepth = targetDepth;
            this.key = key;
        }
    }
}

