/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.services.elasticmapreduce.model.InstanceGroupConfig;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobFlowInstancesConfig
implements Serializable {
    private String masterInstanceType;
    private String slaveInstanceType;
    private Integer instanceCount;
    private List<InstanceGroupConfig> instanceGroups;
    private String ec2KeyName;
    private PlacementType placement;
    private Boolean keepJobFlowAliveWhenNoSteps;
    private Boolean terminationProtected;
    private String hadoopVersion;
    private String ec2SubnetId;

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public void setMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
    }

    public JobFlowInstancesConfig withMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
        return this;
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
    }

    public JobFlowInstancesConfig withSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
        return this;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public JobFlowInstancesConfig withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public List<InstanceGroupConfig> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ArrayList<InstanceGroupConfig>();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>(instanceGroups.size());
        instanceGroupsCopy.addAll(instanceGroups);
        this.instanceGroups = instanceGroupsCopy;
    }

    public JobFlowInstancesConfig withInstanceGroups(InstanceGroupConfig ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupConfig>(instanceGroups.length));
        }
        for (InstanceGroupConfig value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public JobFlowInstancesConfig withInstanceGroups(Collection<InstanceGroupConfig> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
        } else {
            ArrayList<InstanceGroupConfig> instanceGroupsCopy = new ArrayList<InstanceGroupConfig>(instanceGroups.size());
            instanceGroupsCopy.addAll(instanceGroups);
            this.instanceGroups = instanceGroupsCopy;
        }
        return this;
    }

    public String getEc2KeyName() {
        return this.ec2KeyName;
    }

    public void setEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
    }

    public JobFlowInstancesConfig withEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
        return this;
    }

    public PlacementType getPlacement() {
        return this.placement;
    }

    public void setPlacement(PlacementType placement) {
        this.placement = placement;
    }

    public JobFlowInstancesConfig withPlacement(PlacementType placement) {
        this.placement = placement;
        return this;
    }

    public Boolean isKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
    }

    public JobFlowInstancesConfig withKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        return this;
    }

    public Boolean getKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public JobFlowInstancesConfig withTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
        return this;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public void setHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
    }

    public JobFlowInstancesConfig withHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
        return this;
    }

    public String getEc2SubnetId() {
        return this.ec2SubnetId;
    }

    public void setEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
    }

    public JobFlowInstancesConfig withEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMasterInstanceType() != null) {
            sb.append("MasterInstanceType: " + this.getMasterInstanceType() + ", ");
        }
        if (this.getSlaveInstanceType() != null) {
            sb.append("SlaveInstanceType: " + this.getSlaveInstanceType() + ", ");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ", ");
        }
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups() + ", ");
        }
        if (this.getEc2KeyName() != null) {
            sb.append("Ec2KeyName: " + this.getEc2KeyName() + ", ");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: " + this.getPlacement() + ", ");
        }
        if (this.isKeepJobFlowAliveWhenNoSteps() != null) {
            sb.append("KeepJobFlowAliveWhenNoSteps: " + this.isKeepJobFlowAliveWhenNoSteps() + ", ");
        }
        if (this.isTerminationProtected() != null) {
            sb.append("TerminationProtected: " + this.isTerminationProtected() + ", ");
        }
        if (this.getHadoopVersion() != null) {
            sb.append("HadoopVersion: " + this.getHadoopVersion() + ", ");
        }
        if (this.getEc2SubnetId() != null) {
            sb.append("Ec2SubnetId: " + this.getEc2SubnetId() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMasterInstanceType() == null ? 0 : this.getMasterInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getSlaveInstanceType() == null ? 0 : this.getSlaveInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : ((Object)this.getInstanceGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getEc2KeyName() == null ? 0 : this.getEc2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.isKeepJobFlowAliveWhenNoSteps() == null ? 0 : this.isKeepJobFlowAliveWhenNoSteps().hashCode());
        hashCode = 31 * hashCode + (this.isTerminationProtected() == null ? 0 : this.isTerminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.getHadoopVersion() == null ? 0 : this.getHadoopVersion().hashCode());
        hashCode = 31 * hashCode + (this.getEc2SubnetId() == null ? 0 : this.getEc2SubnetId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesConfig)) {
            return false;
        }
        JobFlowInstancesConfig other = (JobFlowInstancesConfig)obj;
        if (other.getMasterInstanceType() == null ^ this.getMasterInstanceType() == null) {
            return false;
        }
        if (other.getMasterInstanceType() != null && !other.getMasterInstanceType().equals(this.getMasterInstanceType())) {
            return false;
        }
        if (other.getSlaveInstanceType() == null ^ this.getSlaveInstanceType() == null) {
            return false;
        }
        if (other.getSlaveInstanceType() != null && !other.getSlaveInstanceType().equals(this.getSlaveInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !((Object)other.getInstanceGroups()).equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getEc2KeyName() == null ^ this.getEc2KeyName() == null) {
            return false;
        }
        if (other.getEc2KeyName() != null && !other.getEc2KeyName().equals(this.getEc2KeyName())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.isKeepJobFlowAliveWhenNoSteps() == null ^ this.isKeepJobFlowAliveWhenNoSteps() == null) {
            return false;
        }
        if (other.isKeepJobFlowAliveWhenNoSteps() != null && !other.isKeepJobFlowAliveWhenNoSteps().equals(this.isKeepJobFlowAliveWhenNoSteps())) {
            return false;
        }
        if (other.isTerminationProtected() == null ^ this.isTerminationProtected() == null) {
            return false;
        }
        if (other.isTerminationProtected() != null && !other.isTerminationProtected().equals(this.isTerminationProtected())) {
            return false;
        }
        if (other.getHadoopVersion() == null ^ this.getHadoopVersion() == null) {
            return false;
        }
        if (other.getHadoopVersion() != null && !other.getHadoopVersion().equals(this.getHadoopVersion())) {
            return false;
        }
        if (other.getEc2SubnetId() == null ^ this.getEc2SubnetId() == null) {
            return false;
        }
        return other.getEc2SubnetId() == null || other.getEc2SubnetId().equals(this.getEc2SubnetId());
    }
}

