/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.InternetGatewayAttachment;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternetGateway
implements Serializable {
    private String internetGatewayId;
    private List<InternetGatewayAttachment> attachments;
    private List<Tag> tags;

    public String getInternetGatewayId() {
        return this.internetGatewayId;
    }

    public void setInternetGatewayId(String internetGatewayId) {
        this.internetGatewayId = internetGatewayId;
    }

    public InternetGateway withInternetGatewayId(String internetGatewayId) {
        this.internetGatewayId = internetGatewayId;
        return this;
    }

    public List<InternetGatewayAttachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<InternetGatewayAttachment>();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<InternetGatewayAttachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        ArrayList<InternetGatewayAttachment> attachmentsCopy = new ArrayList<InternetGatewayAttachment>(attachments.size());
        attachmentsCopy.addAll(attachments);
        this.attachments = attachmentsCopy;
    }

    public InternetGateway withAttachments(InternetGatewayAttachment ... attachments) {
        if (this.getAttachments() == null) {
            this.setAttachments(new ArrayList<InternetGatewayAttachment>(attachments.length));
        }
        for (InternetGatewayAttachment value : attachments) {
            this.getAttachments().add(value);
        }
        return this;
    }

    public InternetGateway withAttachments(Collection<InternetGatewayAttachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
        } else {
            ArrayList<InternetGatewayAttachment> attachmentsCopy = new ArrayList<InternetGatewayAttachment>(attachments.size());
            attachmentsCopy.addAll(attachments);
            this.attachments = attachmentsCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public InternetGateway withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public InternetGateway withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInternetGatewayId() != null) {
            sb.append("InternetGatewayId: " + this.getInternetGatewayId() + ", ");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: " + this.getAttachments() + ", ");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInternetGatewayId() == null ? 0 : this.getInternetGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : ((Object)this.getAttachments()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternetGateway)) {
            return false;
        }
        InternetGateway other = (InternetGateway)obj;
        if (other.getInternetGatewayId() == null ^ this.getInternetGatewayId() == null) {
            return false;
        }
        if (other.getInternetGatewayId() != null && !other.getInternetGatewayId().equals(this.getInternetGatewayId())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !((Object)other.getAttachments()).equals(this.getAttachments())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

