/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.AttributeValue;
import com.amazonaws.services.dynamodb.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodb.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodb.model.Key;
import com.amazonaws.services.dynamodb.model.UpdateItemRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateItemRequestMarshaller
implements Marshaller<Request<UpdateItemRequest>, UpdateItemRequest> {
    @Override
    public Request<UpdateItemRequest> marshall(UpdateItemRequest updateItemRequest) {
        if (updateItemRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateItemRequest> request = new DefaultRequest<UpdateItemRequest>(updateItemRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.UpdateItem";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            List<String> nSList;
            List<String> sSList;
            AttributeValue value;
            Key key;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (updateItemRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(updateItemRequest.getTableName());
            }
            if ((key = updateItemRequest.getKey()) != null) {
                AttributeValue attributeValue;
                jsonWriter.key("Key").object();
                AttributeValue hashKeyElement = key.getHashKeyElement();
                if (hashKeyElement != null) {
                    List<String> nSList2;
                    List<String> list;
                    jsonWriter.key("HashKeyElement").object();
                    if (hashKeyElement.getS() != null) {
                        jsonWriter.key("S").value(hashKeyElement.getS());
                    }
                    if (hashKeyElement.getN() != null) {
                        jsonWriter.key("N").value(hashKeyElement.getN());
                    }
                    if ((list = hashKeyElement.getSS()) != null && list.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : list) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList2 = hashKeyElement.getNS()) != null && nSList2.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList2) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                if ((attributeValue = key.getRangeKeyElement()) != null) {
                    List<String> nSList3;
                    List<String> sSList3;
                    jsonWriter.key("RangeKeyElement").object();
                    if (attributeValue.getS() != null) {
                        jsonWriter.key("S").value(attributeValue.getS());
                    }
                    if (attributeValue.getN() != null) {
                        jsonWriter.key("N").value(attributeValue.getN());
                    }
                    if ((sSList3 = attributeValue.getSS()) != null && sSList3.size() > 0) {
                        jsonWriter.key("SS").array();
                        for (String sSListValue : sSList3) {
                            jsonWriter.value(sSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    if ((nSList3 = attributeValue.getNS()) != null && nSList3.size() > 0) {
                        jsonWriter.key("NS").array();
                        for (String nSListValue : nSList3) {
                            jsonWriter.value(nSListValue);
                        }
                        jsonWriter.endArray();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getAttributeUpdates() != null) {
                jsonWriter.key("AttributeUpdates").object();
                for (Map.Entry<String, Object> entry : updateItemRequest.getAttributeUpdates().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    value = ((AttributeValueUpdate)entry.getValue()).getValue();
                    if (value != null) {
                        jsonWriter.key("Value").object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if ((sSList = value.getSS()) != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if ((nSList = value.getNS()) != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (((AttributeValueUpdate)entry.getValue()).getAction() != null) {
                        jsonWriter.key("Action").value(((AttributeValueUpdate)entry.getValue()).getAction());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getExpected() != null) {
                jsonWriter.key("Expected").object();
                for (Map.Entry<String, Object> entry : updateItemRequest.getExpected().entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonWriter.key(entry.getKey());
                    jsonWriter.object();
                    value = ((ExpectedAttributeValue)entry.getValue()).getValue();
                    if (value != null) {
                        jsonWriter.key("Value").object();
                        if (value.getS() != null) {
                            jsonWriter.key("S").value(value.getS());
                        }
                        if (value.getN() != null) {
                            jsonWriter.key("N").value(value.getN());
                        }
                        if ((sSList = value.getSS()) != null && sSList.size() > 0) {
                            jsonWriter.key("SS").array();
                            for (String sSListValue : sSList) {
                                jsonWriter.value(sSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        if ((nSList = value.getNS()) != null && nSList.size() > 0) {
                            jsonWriter.key("NS").array();
                            for (String nSListValue : nSList) {
                                jsonWriter.value(nSListValue);
                            }
                            jsonWriter.endArray();
                        }
                        jsonWriter.endObject();
                    }
                    if (((ExpectedAttributeValue)entry.getValue()).isExists() != null) {
                        jsonWriter.key("Exists").value(((ExpectedAttributeValue)entry.getValue()).isExists());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (updateItemRequest.getReturnValues() != null) {
                jsonWriter.key("ReturnValues").value(updateItemRequest.getReturnValues());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] byArray = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

