/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeWorkingStorageResult {
    private String gatewayARN;
    private List<String> diskIds;
    private Long workingStorageUsedInBytes;
    private Long workingStorageAllocatedInBytes;

    public String getGatewayARN() {
        return this.gatewayARN;
    }

    public void setGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
    }

    public DescribeWorkingStorageResult withGatewayARN(String gatewayARN) {
        this.gatewayARN = gatewayARN;
        return this;
    }

    public List<String> getDiskIds() {
        if (this.diskIds == null) {
            this.diskIds = new ArrayList<String>();
        }
        return this.diskIds;
    }

    public void setDiskIds(Collection<String> diskIds) {
        if (diskIds == null) {
            this.diskIds = null;
            return;
        }
        ArrayList<String> diskIdsCopy = new ArrayList<String>(diskIds.size());
        diskIdsCopy.addAll(diskIds);
        this.diskIds = diskIdsCopy;
    }

    public DescribeWorkingStorageResult withDiskIds(String ... diskIds) {
        if (this.getDiskIds() == null) {
            this.setDiskIds(new ArrayList<String>(diskIds.length));
        }
        for (String value : diskIds) {
            this.getDiskIds().add(value);
        }
        return this;
    }

    public DescribeWorkingStorageResult withDiskIds(Collection<String> diskIds) {
        if (diskIds == null) {
            this.diskIds = null;
        } else {
            ArrayList<String> diskIdsCopy = new ArrayList<String>(diskIds.size());
            diskIdsCopy.addAll(diskIds);
            this.diskIds = diskIdsCopy;
        }
        return this;
    }

    public Long getWorkingStorageUsedInBytes() {
        return this.workingStorageUsedInBytes;
    }

    public void setWorkingStorageUsedInBytes(Long workingStorageUsedInBytes) {
        this.workingStorageUsedInBytes = workingStorageUsedInBytes;
    }

    public DescribeWorkingStorageResult withWorkingStorageUsedInBytes(Long workingStorageUsedInBytes) {
        this.workingStorageUsedInBytes = workingStorageUsedInBytes;
        return this;
    }

    public Long getWorkingStorageAllocatedInBytes() {
        return this.workingStorageAllocatedInBytes;
    }

    public void setWorkingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes) {
        this.workingStorageAllocatedInBytes = workingStorageAllocatedInBytes;
    }

    public DescribeWorkingStorageResult withWorkingStorageAllocatedInBytes(Long workingStorageAllocatedInBytes) {
        this.workingStorageAllocatedInBytes = workingStorageAllocatedInBytes;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGatewayARN() != null) {
            sb.append("GatewayARN: " + this.getGatewayARN() + ", ");
        }
        if (this.getDiskIds() != null) {
            sb.append("DiskIds: " + this.getDiskIds() + ", ");
        }
        if (this.getWorkingStorageUsedInBytes() != null) {
            sb.append("WorkingStorageUsedInBytes: " + this.getWorkingStorageUsedInBytes() + ", ");
        }
        if (this.getWorkingStorageAllocatedInBytes() != null) {
            sb.append("WorkingStorageAllocatedInBytes: " + this.getWorkingStorageAllocatedInBytes() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGatewayARN() == null ? 0 : this.getGatewayARN().hashCode());
        hashCode = 31 * hashCode + (this.getDiskIds() == null ? 0 : ((Object)this.getDiskIds()).hashCode());
        hashCode = 31 * hashCode + (this.getWorkingStorageUsedInBytes() == null ? 0 : this.getWorkingStorageUsedInBytes().hashCode());
        hashCode = 31 * hashCode + (this.getWorkingStorageAllocatedInBytes() == null ? 0 : this.getWorkingStorageAllocatedInBytes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkingStorageResult)) {
            return false;
        }
        DescribeWorkingStorageResult other = (DescribeWorkingStorageResult)obj;
        if (other.getGatewayARN() == null ^ this.getGatewayARN() == null) {
            return false;
        }
        if (other.getGatewayARN() != null && !other.getGatewayARN().equals(this.getGatewayARN())) {
            return false;
        }
        if (other.getDiskIds() == null ^ this.getDiskIds() == null) {
            return false;
        }
        if (other.getDiskIds() != null && !((Object)other.getDiskIds()).equals(this.getDiskIds())) {
            return false;
        }
        if (other.getWorkingStorageUsedInBytes() == null ^ this.getWorkingStorageUsedInBytes() == null) {
            return false;
        }
        if (other.getWorkingStorageUsedInBytes() != null && !other.getWorkingStorageUsedInBytes().equals(this.getWorkingStorageUsedInBytes())) {
            return false;
        }
        if (other.getWorkingStorageAllocatedInBytes() == null ^ this.getWorkingStorageAllocatedInBytes() == null) {
            return false;
        }
        return other.getWorkingStorageAllocatedInBytes() == null || other.getWorkingStorageAllocatedInBytes().equals(this.getWorkingStorageAllocatedInBytes());
    }
}

