/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitiateJobRequestMarshaller
implements Marshaller<Request<InitiateJobRequest>, InitiateJobRequest> {
    @Override
    public Request<InitiateJobRequest> marshall(InitiateJobRequest initiateJobRequest) {
        if (initiateJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<InitiateJobRequest> request = new DefaultRequest<InitiateJobRequest>(initiateJobRequest, "AmazonGlacier");
        String target = "Glacier.InitiateJob";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs";
        uriResourcePath = uriResourcePath.replace("{accountId}", this.getString(initiateJobRequest.getAccountId()));
        uriResourcePath = uriResourcePath.replace("{vaultName}", this.getString(initiateJobRequest.getVaultName()));
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            JobParameters jobParameters = initiateJobRequest.getJobParameters();
            if (jobParameters != null) {
                jsonWriter.object();
                if (jobParameters.getFormat() != null) {
                    jsonWriter.key("Format").value(jobParameters.getFormat());
                }
                if (jobParameters.getType() != null) {
                    jsonWriter.key("Type").value(jobParameters.getType());
                }
                if (jobParameters.getArchiveId() != null) {
                    jsonWriter.key("ArchiveId").value(jobParameters.getArchiveId());
                }
                if (jobParameters.getDescription() != null) {
                    jsonWriter.key("Description").value(jobParameters.getDescription());
                }
                if (jobParameters.getSNSTopic() != null) {
                    jsonWriter.key("SNSTopic").value(jobParameters.getSNSTopic());
                }
                jsonWriter.endObject();
            }
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

