/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.TreeHashGenerator;
import com.amazonaws.services.glacier.internal.TreeHashInputStream;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.transfer.JobStatusMonitor;
import com.amazonaws.services.glacier.transfer.UploadResult;
import com.amazonaws.services.s3.internal.InputSubstream;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.sns.AmazonSNSClient;
import com.amazonaws.services.sqs.AmazonSQSClient;
import com.amazonaws.util.BinaryUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;

public class ArchiveTransferManager {
    private static final long MAXIMUM_PART_SIZE = 0x100000000L;
    private static final long MINIMUM_PART_SIZE = 0x100000L;
    private static final long MULTIPART_UPLOAD_SIZE_THRESHOLD = 0x6400000L;
    private final AmazonGlacier glacier;
    private final AWSCredentialsProvider credentialsProvider;
    private final ClientConfiguration clientConfiguration;
    private final AmazonSQSClient sqs;
    private final AmazonSNSClient sns;

    public ArchiveTransferManager(AWSCredentials credentials) {
        this(new StaticCredentialsProvider(credentials), new ClientConfiguration());
    }

    public ArchiveTransferManager(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(new AmazonGlacierClient(credentialsProvider, clientConfiguration), credentialsProvider, clientConfiguration);
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentialsProvider credentialsProvider) {
        this(glacier, credentialsProvider, new ClientConfiguration());
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentials credentials) {
        this(glacier, new StaticCredentialsProvider(credentials), new ClientConfiguration());
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this.credentialsProvider = credentialsProvider;
        this.clientConfiguration = clientConfiguration;
        this.glacier = glacier;
        this.sns = null;
        this.sqs = null;
    }

    public ArchiveTransferManager(AmazonGlacierClient glacier, AmazonSQSClient sqs, AmazonSNSClient sns) {
        this.credentialsProvider = null;
        this.clientConfiguration = null;
        this.glacier = glacier;
        this.sqs = sqs;
        this.sns = sns;
    }

    public UploadResult upload(String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        return this.upload(null, vaultName, archiveDescription, file);
    }

    public UploadResult upload(String accountId, String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        if (file.length() > 0x6400000L) {
            return this.uploadInMultipleParts(accountId, vaultName, archiveDescription, file);
        }
        return this.uploadInSinglePart(accountId, vaultName, archiveDescription, file);
    }

    public void download(String vaultName, String archiveId, File file) throws AmazonServiceException, AmazonClientException {
        this.download(null, vaultName, archiveId, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String accountId, String vaultName, String archiveId, File file) throws AmazonServiceException, AmazonClientException {
        JobStatusMonitor jobStatusMonitor = null;
        GetJobOutputResult jobOutputResult = null;
        try {
            jobStatusMonitor = this.credentialsProvider != null && this.clientConfiguration != null ? new JobStatusMonitor(this.credentialsProvider, this.clientConfiguration) : new JobStatusMonitor(this.sqs, this.sns);
            JobParameters jobParameters = new JobParameters().withArchiveId(archiveId).withType("archive-retrieval").withSNSTopic(jobStatusMonitor.getTopicArn());
            InitiateJobResult archiveRetrievalResult = this.glacier.initiateJob(new InitiateJobRequest().withAccountId(accountId).withVaultName(vaultName).withJobParameters(jobParameters));
            String jobId = archiveRetrievalResult.getJobId();
            jobStatusMonitor.waitForJobToComplete(jobId);
            jobOutputResult = this.glacier.getJobOutput(new GetJobOutputRequest().withAccountId(accountId).withVaultName(vaultName).withJobId(jobId));
        }
        finally {
            if (jobStatusMonitor != null) {
                jobStatusMonitor.shutdown();
            }
        }
        this.downloadJobOutput(jobOutputResult, file);
    }

    private void downloadJobOutput(GetJobOutputResult jobOutputResult, File file) {
        TreeHashInputStream input;
        BufferedOutputStream output = null;
        byte[] buffer = new byte[0x100000];
        try {
            input = new TreeHashInputStream(new BufferedInputStream(jobOutputResult.getBody()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to compute hash for data integrity", e);
        }
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            int bytesRead = 0;
            do {
                if ((bytesRead = input.read(buffer)) <= 0) {
                    break;
                }
                ((OutputStream)output).write(buffer, 0, bytesRead);
            } while (bytesRead > 0);
        }
        catch (IOException e) {
            throw new AmazonClientException("Unable to save archive to disk", e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
            try {
                ((OutputStream)output).close();
            }
            catch (Exception e) {}
            try {
                String clientSideTreeHash = input.getTreeHash();
                String serverSideTreeHash = jobOutputResult.getChecksum();
                if (!clientSideTreeHash.equalsIgnoreCase(serverSideTreeHash)) {
                    throw new AmazonClientException("Client side computed hash doesn't match server side hash; possible data corruption");
                }
            }
            catch (IOException e) {
                throw new AmazonClientException("Error while trying to confirm data integrity for archive download", e);
            }
        }
    }

    private long calculatePartSize(long fileSize) {
        long partSize = 0x100000L;
        int approxNumParts = 1;
        while (partSize * (long)approxNumParts < fileSize && partSize * 2L <= 0x100000000L) {
            partSize *= 2L;
            approxNumParts *= 2;
        }
        return partSize;
    }

    private InputSubstream newInputSubstream(File file, long startingPosition, long length) {
        try {
            return new InputSubstream(new RepeatableFileInputStream(file), startingPosition, length, true);
        }
        catch (FileNotFoundException e) {
            throw new AmazonClientException("Unable to find file '" + file.getAbsolutePath() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadResult uploadInMultipleParts(String accountId, String vaultName, String archiveDescription, File file) {
        long partSize = this.calculatePartSize(file.length());
        String partSizeString = Long.toString(partSize);
        InitiateMultipartUploadResult initiateResult = this.glacier.initiateMultipartUpload(new InitiateMultipartUploadRequest().withAccountId(accountId).withArchiveDescription(archiveDescription).withVaultName(vaultName).withPartSize(partSizeString));
        String uploadId = initiateResult.getUploadId();
        try {
            LinkedList<byte[]> binaryChecksums = new LinkedList<byte[]>();
            for (long currentPosition = 0L; currentPosition < file.length(); currentPosition += partSize) {
                long length = partSize;
                if (currentPosition + partSize > file.length()) {
                    length = file.length() - currentPosition;
                }
                InputSubstream inputSubStream = this.newInputSubstream(file, currentPosition, length);
                String checksum = TreeHashGenerator.calculateTreeHash(inputSubStream);
                byte[] binaryChecksum = BinaryUtils.fromHex(checksum);
                binaryChecksums.add(binaryChecksum);
                try {
                    this.glacier.uploadMultipartPart(new UploadMultipartPartRequest().withAccountId(accountId).withChecksum(checksum).withBody(inputSubStream).withRange("bytes " + currentPosition + "-" + (currentPosition + length - 1L) + "/*").withUploadId(uploadId).withVaultName(vaultName));
                    continue;
                }
                finally {
                    try {
                        ((InputStream)inputSubStream).close();
                    }
                    catch (Exception e) {}
                }
            }
            String checksum = TreeHashGenerator.calculateTreeHash(binaryChecksums);
            String archiveSize = Long.toString(file.length());
            CompleteMultipartUploadResult completeMultipartUploadResult = this.glacier.completeMultipartUpload(new CompleteMultipartUploadRequest().withAccountId(accountId).withArchiveSize(archiveSize).withVaultName(vaultName).withChecksum(checksum).withUploadId(uploadId));
            String artifactId = completeMultipartUploadResult.getArchiveId();
            return new UploadResult(artifactId);
        }
        catch (AmazonClientException e) {
            this.glacier.abortMultipartUpload(new AbortMultipartUploadRequest(accountId, vaultName, uploadId));
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UploadResult uploadInSinglePart(String accountId, String vaultName, String archiveDescription, File file) throws AmazonServiceException, AmazonClientException, FileNotFoundException {
        String checksum = TreeHashGenerator.calculateTreeHash(file);
        RepeatableFileInputStream input = new RepeatableFileInputStream(file);
        try {
            UploadArchiveResult uploadArchiveResult = this.glacier.uploadArchive(new UploadArchiveRequest().withAccountId(accountId).withArchiveDescription(archiveDescription).withVaultName(vaultName).withChecksum(checksum).withBody(input).withContentLength(file.length()));
            String artifactId = uploadArchiveResult.getArchiveId();
            UploadResult uploadResult = new UploadResult(artifactId);
            return uploadResult;
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }
}

