/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.rds.model.OptionConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyOptionGroupRequest
extends AmazonWebServiceRequest {
    private String optionGroupName;
    private List<OptionConfiguration> optionsToInclude;
    private List<String> optionsToRemove;
    private Boolean applyImmediately;

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public ModifyOptionGroupRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public List<OptionConfiguration> getOptionsToInclude() {
        if (this.optionsToInclude == null) {
            this.optionsToInclude = new ArrayList<OptionConfiguration>();
        }
        return this.optionsToInclude;
    }

    public void setOptionsToInclude(Collection<OptionConfiguration> optionsToInclude) {
        if (optionsToInclude == null) {
            this.optionsToInclude = null;
            return;
        }
        ArrayList<OptionConfiguration> optionsToIncludeCopy = new ArrayList<OptionConfiguration>(optionsToInclude.size());
        optionsToIncludeCopy.addAll(optionsToInclude);
        this.optionsToInclude = optionsToIncludeCopy;
    }

    public ModifyOptionGroupRequest withOptionsToInclude(OptionConfiguration ... optionsToInclude) {
        if (this.getOptionsToInclude() == null) {
            this.setOptionsToInclude(new ArrayList<OptionConfiguration>(optionsToInclude.length));
        }
        for (OptionConfiguration value : optionsToInclude) {
            this.getOptionsToInclude().add(value);
        }
        return this;
    }

    public ModifyOptionGroupRequest withOptionsToInclude(Collection<OptionConfiguration> optionsToInclude) {
        if (optionsToInclude == null) {
            this.optionsToInclude = null;
        } else {
            ArrayList<OptionConfiguration> optionsToIncludeCopy = new ArrayList<OptionConfiguration>(optionsToInclude.size());
            optionsToIncludeCopy.addAll(optionsToInclude);
            this.optionsToInclude = optionsToIncludeCopy;
        }
        return this;
    }

    public List<String> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new ArrayList<String>();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<String> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
            return;
        }
        ArrayList<String> optionsToRemoveCopy = new ArrayList<String>(optionsToRemove.size());
        optionsToRemoveCopy.addAll(optionsToRemove);
        this.optionsToRemove = optionsToRemoveCopy;
    }

    public ModifyOptionGroupRequest withOptionsToRemove(String ... optionsToRemove) {
        if (this.getOptionsToRemove() == null) {
            this.setOptionsToRemove(new ArrayList<String>(optionsToRemove.length));
        }
        for (String value : optionsToRemove) {
            this.getOptionsToRemove().add(value);
        }
        return this;
    }

    public ModifyOptionGroupRequest withOptionsToRemove(Collection<String> optionsToRemove) {
        if (optionsToRemove == null) {
            this.optionsToRemove = null;
        } else {
            ArrayList<String> optionsToRemoveCopy = new ArrayList<String>(optionsToRemove.size());
            optionsToRemoveCopy.addAll(optionsToRemove);
            this.optionsToRemove = optionsToRemoveCopy;
        }
        return this;
    }

    public Boolean isApplyImmediately() {
        return this.applyImmediately;
    }

    public void setApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
    }

    public ModifyOptionGroupRequest withApplyImmediately(Boolean applyImmediately) {
        this.applyImmediately = applyImmediately;
        return this;
    }

    public Boolean getApplyImmediately() {
        return this.applyImmediately;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionGroupName != null) {
            sb.append("OptionGroupName: " + this.optionGroupName + ", ");
        }
        if (this.optionsToInclude != null) {
            sb.append("OptionsToInclude: " + this.optionsToInclude + ", ");
        }
        if (this.optionsToRemove != null) {
            sb.append("OptionsToRemove: " + this.optionsToRemove + ", ");
        }
        if (this.applyImmediately != null) {
            sb.append("ApplyImmediately: " + this.applyImmediately + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getOptionsToInclude() == null ? 0 : ((Object)this.getOptionsToInclude()).hashCode());
        hashCode = 31 * hashCode + (this.getOptionsToRemove() == null ? 0 : ((Object)this.getOptionsToRemove()).hashCode());
        hashCode = 31 * hashCode + (this.isApplyImmediately() == null ? 0 : this.isApplyImmediately().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyOptionGroupRequest)) {
            return false;
        }
        ModifyOptionGroupRequest other = (ModifyOptionGroupRequest)obj;
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getOptionsToInclude() == null ^ this.getOptionsToInclude() == null) {
            return false;
        }
        if (other.getOptionsToInclude() != null && !((Object)other.getOptionsToInclude()).equals(this.getOptionsToInclude())) {
            return false;
        }
        if (other.getOptionsToRemove() == null ^ this.getOptionsToRemove() == null) {
            return false;
        }
        if (other.getOptionsToRemove() != null && !((Object)other.getOptionsToRemove()).equals(this.getOptionsToRemove())) {
            return false;
        }
        if (other.isApplyImmediately() == null ^ this.isApplyImmediately() == null) {
            return false;
        }
        return other.isApplyImmediately() == null || other.isApplyImmediately().equals(this.isApplyImmediately());
    }
}

