/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.services.rds.model.AvailabilityZone;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderableDBInstanceOption {
    private String engine;
    private String engineVersion;
    private String dBInstanceClass;
    private String licenseModel;
    private List<AvailabilityZone> availabilityZones;
    private Boolean multiAZCapable;
    private Boolean readReplicaCapable;
    private Boolean vpcCapable;
    private Boolean vpcMultiAZCapable;
    private Boolean vpcReadReplicaCapable;

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public OrderableDBInstanceOption withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public OrderableDBInstanceOption withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public OrderableDBInstanceOption withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public OrderableDBInstanceOption withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public List<AvailabilityZone> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<AvailabilityZone>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        ArrayList<AvailabilityZone> availabilityZonesCopy = new ArrayList<AvailabilityZone>(availabilityZones.size());
        availabilityZonesCopy.addAll(availabilityZones);
        this.availabilityZones = availabilityZonesCopy;
    }

    public OrderableDBInstanceOption withAvailabilityZones(AvailabilityZone ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<AvailabilityZone>(availabilityZones.length));
        }
        for (AvailabilityZone value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public OrderableDBInstanceOption withAvailabilityZones(Collection<AvailabilityZone> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
        } else {
            ArrayList<AvailabilityZone> availabilityZonesCopy = new ArrayList<AvailabilityZone>(availabilityZones.size());
            availabilityZonesCopy.addAll(availabilityZones);
            this.availabilityZones = availabilityZonesCopy;
        }
        return this;
    }

    public Boolean isMultiAZCapable() {
        return this.multiAZCapable;
    }

    public void setMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
    }

    public OrderableDBInstanceOption withMultiAZCapable(Boolean multiAZCapable) {
        this.multiAZCapable = multiAZCapable;
        return this;
    }

    public Boolean getMultiAZCapable() {
        return this.multiAZCapable;
    }

    public Boolean isReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public void setReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
    }

    public OrderableDBInstanceOption withReadReplicaCapable(Boolean readReplicaCapable) {
        this.readReplicaCapable = readReplicaCapable;
        return this;
    }

    public Boolean getReadReplicaCapable() {
        return this.readReplicaCapable;
    }

    public Boolean isVpcCapable() {
        return this.vpcCapable;
    }

    public void setVpcCapable(Boolean vpcCapable) {
        this.vpcCapable = vpcCapable;
    }

    public OrderableDBInstanceOption withVpcCapable(Boolean vpcCapable) {
        this.vpcCapable = vpcCapable;
        return this;
    }

    public Boolean getVpcCapable() {
        return this.vpcCapable;
    }

    public Boolean isVpcMultiAZCapable() {
        return this.vpcMultiAZCapable;
    }

    public void setVpcMultiAZCapable(Boolean vpcMultiAZCapable) {
        this.vpcMultiAZCapable = vpcMultiAZCapable;
    }

    public OrderableDBInstanceOption withVpcMultiAZCapable(Boolean vpcMultiAZCapable) {
        this.vpcMultiAZCapable = vpcMultiAZCapable;
        return this;
    }

    public Boolean getVpcMultiAZCapable() {
        return this.vpcMultiAZCapable;
    }

    public Boolean isVpcReadReplicaCapable() {
        return this.vpcReadReplicaCapable;
    }

    public void setVpcReadReplicaCapable(Boolean vpcReadReplicaCapable) {
        this.vpcReadReplicaCapable = vpcReadReplicaCapable;
    }

    public OrderableDBInstanceOption withVpcReadReplicaCapable(Boolean vpcReadReplicaCapable) {
        this.vpcReadReplicaCapable = vpcReadReplicaCapable;
        return this;
    }

    public Boolean getVpcReadReplicaCapable() {
        return this.vpcReadReplicaCapable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.engine != null) {
            sb.append("Engine: " + this.engine + ", ");
        }
        if (this.engineVersion != null) {
            sb.append("EngineVersion: " + this.engineVersion + ", ");
        }
        if (this.dBInstanceClass != null) {
            sb.append("DBInstanceClass: " + this.dBInstanceClass + ", ");
        }
        if (this.licenseModel != null) {
            sb.append("LicenseModel: " + this.licenseModel + ", ");
        }
        if (this.availabilityZones != null) {
            sb.append("AvailabilityZones: " + this.availabilityZones + ", ");
        }
        if (this.multiAZCapable != null) {
            sb.append("MultiAZCapable: " + this.multiAZCapable + ", ");
        }
        if (this.readReplicaCapable != null) {
            sb.append("ReadReplicaCapable: " + this.readReplicaCapable + ", ");
        }
        if (this.vpcCapable != null) {
            sb.append("VpcCapable: " + this.vpcCapable + ", ");
        }
        if (this.vpcMultiAZCapable != null) {
            sb.append("VpcMultiAZCapable: " + this.vpcMultiAZCapable + ", ");
        }
        if (this.vpcReadReplicaCapable != null) {
            sb.append("VpcReadReplicaCapable: " + this.vpcReadReplicaCapable + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : ((Object)this.getAvailabilityZones()).hashCode());
        hashCode = 31 * hashCode + (this.isMultiAZCapable() == null ? 0 : this.isMultiAZCapable().hashCode());
        hashCode = 31 * hashCode + (this.isReadReplicaCapable() == null ? 0 : this.isReadReplicaCapable().hashCode());
        hashCode = 31 * hashCode + (this.isVpcCapable() == null ? 0 : this.isVpcCapable().hashCode());
        hashCode = 31 * hashCode + (this.isVpcMultiAZCapable() == null ? 0 : this.isVpcMultiAZCapable().hashCode());
        hashCode = 31 * hashCode + (this.isVpcReadReplicaCapable() == null ? 0 : this.isVpcReadReplicaCapable().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrderableDBInstanceOption)) {
            return false;
        }
        OrderableDBInstanceOption other = (OrderableDBInstanceOption)obj;
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !((Object)other.getAvailabilityZones()).equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.isMultiAZCapable() == null ^ this.isMultiAZCapable() == null) {
            return false;
        }
        if (other.isMultiAZCapable() != null && !other.isMultiAZCapable().equals(this.isMultiAZCapable())) {
            return false;
        }
        if (other.isReadReplicaCapable() == null ^ this.isReadReplicaCapable() == null) {
            return false;
        }
        if (other.isReadReplicaCapable() != null && !other.isReadReplicaCapable().equals(this.isReadReplicaCapable())) {
            return false;
        }
        if (other.isVpcCapable() == null ^ this.isVpcCapable() == null) {
            return false;
        }
        if (other.isVpcCapable() != null && !other.isVpcCapable().equals(this.isVpcCapable())) {
            return false;
        }
        if (other.isVpcMultiAZCapable() == null ^ this.isVpcMultiAZCapable() == null) {
            return false;
        }
        if (other.isVpcMultiAZCapable() != null && !other.isVpcMultiAZCapable().equals(this.isVpcMultiAZCapable())) {
            return false;
        }
        if (other.isVpcReadReplicaCapable() == null ^ this.isVpcReadReplicaCapable() == null) {
            return false;
        }
        return other.isVpcReadReplicaCapable() == null || other.isVpcReadReplicaCapable().equals(this.isVpcReadReplicaCapable());
    }
}

