/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleworkflow.model.Decision;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RespondDecisionTaskCompletedRequest
extends AmazonWebServiceRequest {
    private String taskToken;
    private List<Decision> decisions;
    private String executionContext;

    public String getTaskToken() {
        return this.taskToken;
    }

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    public RespondDecisionTaskCompletedRequest withTaskToken(String taskToken) {
        this.taskToken = taskToken;
        return this;
    }

    public List<Decision> getDecisions() {
        if (this.decisions == null) {
            this.decisions = new ArrayList<Decision>();
        }
        return this.decisions;
    }

    public void setDecisions(Collection<Decision> decisions) {
        if (decisions == null) {
            this.decisions = null;
            return;
        }
        ArrayList<Decision> decisionsCopy = new ArrayList<Decision>(decisions.size());
        decisionsCopy.addAll(decisions);
        this.decisions = decisionsCopy;
    }

    public RespondDecisionTaskCompletedRequest withDecisions(Decision ... decisions) {
        if (this.getDecisions() == null) {
            this.setDecisions(new ArrayList<Decision>(decisions.length));
        }
        for (Decision value : decisions) {
            this.getDecisions().add(value);
        }
        return this;
    }

    public RespondDecisionTaskCompletedRequest withDecisions(Collection<Decision> decisions) {
        if (decisions == null) {
            this.decisions = null;
        } else {
            ArrayList<Decision> decisionsCopy = new ArrayList<Decision>(decisions.size());
            decisionsCopy.addAll(decisions);
            this.decisions = decisionsCopy;
        }
        return this;
    }

    public String getExecutionContext() {
        return this.executionContext;
    }

    public void setExecutionContext(String executionContext) {
        this.executionContext = executionContext;
    }

    public RespondDecisionTaskCompletedRequest withExecutionContext(String executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taskToken != null) {
            sb.append("TaskToken: " + this.taskToken + ", ");
        }
        if (this.decisions != null) {
            sb.append("Decisions: " + this.decisions + ", ");
        }
        if (this.executionContext != null) {
            sb.append("ExecutionContext: " + this.executionContext + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskToken() == null ? 0 : this.getTaskToken().hashCode());
        hashCode = 31 * hashCode + (this.getDecisions() == null ? 0 : ((Object)this.getDecisions()).hashCode());
        hashCode = 31 * hashCode + (this.getExecutionContext() == null ? 0 : this.getExecutionContext().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RespondDecisionTaskCompletedRequest)) {
            return false;
        }
        RespondDecisionTaskCompletedRequest other = (RespondDecisionTaskCompletedRequest)obj;
        if (other.getTaskToken() == null ^ this.getTaskToken() == null) {
            return false;
        }
        if (other.getTaskToken() != null && !other.getTaskToken().equals(this.getTaskToken())) {
            return false;
        }
        if (other.getDecisions() == null ^ this.getDecisions() == null) {
            return false;
        }
        if (other.getDecisions() != null && !((Object)other.getDecisions()).equals(this.getDecisions())) {
            return false;
        }
        if (other.getExecutionContext() == null ^ this.getExecutionContext() == null) {
            return false;
        }
        return other.getExecutionContext() == null || other.getExecutionContext().equals(this.getExecutionContext());
    }
}

