/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.storagegateway.AWSStorageGateway;
import com.amazonaws.services.storagegateway.model.ActivateGatewayRequest;
import com.amazonaws.services.storagegateway.model.ActivateGatewayResult;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageRequest;
import com.amazonaws.services.storagegateway.model.AddWorkingStorageResult;
import com.amazonaws.services.storagegateway.model.CreateSnapshotRequest;
import com.amazonaws.services.storagegateway.model.CreateSnapshotResult;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeRequest;
import com.amazonaws.services.storagegateway.model.CreateStorediSCSIVolumeResult;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.DeleteBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.DeleteChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.DeleteChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.DeleteGatewayRequest;
import com.amazonaws.services.storagegateway.model.DeleteGatewayResult;
import com.amazonaws.services.storagegateway.model.DeleteVolumeRequest;
import com.amazonaws.services.storagegateway.model.DeleteVolumeResult;
import com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.DescribeBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.DescribeChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.DescribeChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.DescribeGatewayInformationRequest;
import com.amazonaws.services.storagegateway.model.DescribeGatewayInformationResult;
import com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeRequest;
import com.amazonaws.services.storagegateway.model.DescribeMaintenanceStartTimeResult;
import com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.DescribeSnapshotScheduleResult;
import com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesRequest;
import com.amazonaws.services.storagegateway.model.DescribeStorediSCSIVolumesResult;
import com.amazonaws.services.storagegateway.model.DescribeWorkingStorageRequest;
import com.amazonaws.services.storagegateway.model.DescribeWorkingStorageResult;
import com.amazonaws.services.storagegateway.model.ListGatewaysRequest;
import com.amazonaws.services.storagegateway.model.ListGatewaysResult;
import com.amazonaws.services.storagegateway.model.ListLocalDisksRequest;
import com.amazonaws.services.storagegateway.model.ListLocalDisksResult;
import com.amazonaws.services.storagegateway.model.ListVolumesRequest;
import com.amazonaws.services.storagegateway.model.ListVolumesResult;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayRequest;
import com.amazonaws.services.storagegateway.model.ShutdownGatewayResult;
import com.amazonaws.services.storagegateway.model.StartGatewayRequest;
import com.amazonaws.services.storagegateway.model.StartGatewayResult;
import com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitRequest;
import com.amazonaws.services.storagegateway.model.UpdateBandwidthRateLimitResult;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsRequest;
import com.amazonaws.services.storagegateway.model.UpdateChapCredentialsResult;
import com.amazonaws.services.storagegateway.model.UpdateGatewayInformationRequest;
import com.amazonaws.services.storagegateway.model.UpdateGatewayInformationResult;
import com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowRequest;
import com.amazonaws.services.storagegateway.model.UpdateGatewaySoftwareNowResult;
import com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeRequest;
import com.amazonaws.services.storagegateway.model.UpdateMaintenanceStartTimeResult;
import com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleRequest;
import com.amazonaws.services.storagegateway.model.UpdateSnapshotScheduleResult;
import com.amazonaws.services.storagegateway.model.transform.ActivateGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ActivateGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddWorkingStorageRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.AddWorkingStorageResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateSnapshotRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateSnapshotResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateStorediSCSIVolumeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.CreateStorediSCSIVolumeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteBandwidthRateLimitRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteBandwidthRateLimitResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteChapCredentialsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteChapCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteVolumeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DeleteVolumeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeBandwidthRateLimitRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeBandwidthRateLimitResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeChapCredentialsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeChapCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeGatewayInformationRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeGatewayInformationResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeMaintenanceStartTimeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeMaintenanceStartTimeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeSnapshotScheduleRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeSnapshotScheduleResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeStorediSCSIVolumesRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeStorediSCSIVolumesResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeWorkingStorageRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.DescribeWorkingStorageResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.InternalServerErrorExceptionUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.InvalidGatewayRequestExceptionUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListGatewaysRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListGatewaysResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListLocalDisksRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListLocalDisksResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListVolumesRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ListVolumesResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.ShutdownGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.ShutdownGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.StartGatewayRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.StartGatewayResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateBandwidthRateLimitRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateBandwidthRateLimitResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateChapCredentialsRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateChapCredentialsResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewayInformationRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewayInformationResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewaySoftwareNowRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateGatewaySoftwareNowResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateMaintenanceStartTimeRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateMaintenanceStartTimeResultJsonUnmarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateSnapshotScheduleRequestMarshaller;
import com.amazonaws.services.storagegateway.model.transform.UpdateSnapshotScheduleResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSStorageGatewayClient
extends AmazonWebServiceClient
implements AWSStorageGateway {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSStorageGateway.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AWSStorageGatewayClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSStorageGatewayClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSStorageGatewayClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSStorageGatewayClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new InvalidGatewayRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServerErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("storagegateway.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/storagegateway/request.handlers"));
    }

    @Override
    public DescribeBandwidthRateLimitResult describeBandwidthRateLimit(DescribeBandwidthRateLimitRequest describeBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeBandwidthRateLimitRequest> request = new DescribeBandwidthRateLimitRequestMarshaller().marshall(describeBandwidthRateLimitRequest);
        DescribeBandwidthRateLimitResultJsonUnmarshaller unmarshaller = new DescribeBandwidthRateLimitResultJsonUnmarshaller();
        JsonResponseHandler<DescribeBandwidthRateLimitResult> responseHandler = new JsonResponseHandler<DescribeBandwidthRateLimitResult>(unmarshaller);
        return (DescribeBandwidthRateLimitResult)this.invoke(request, responseHandler);
    }

    @Override
    public ShutdownGatewayResult shutdownGateway(ShutdownGatewayRequest shutdownGatewayRequest) throws AmazonServiceException, AmazonClientException {
        Request<ShutdownGatewayRequest> request = new ShutdownGatewayRequestMarshaller().marshall(shutdownGatewayRequest);
        ShutdownGatewayResultJsonUnmarshaller unmarshaller = new ShutdownGatewayResultJsonUnmarshaller();
        JsonResponseHandler<ShutdownGatewayResult> responseHandler = new JsonResponseHandler<ShutdownGatewayResult>(unmarshaller);
        return (ShutdownGatewayResult)this.invoke(request, responseHandler);
    }

    @Override
    public CreateSnapshotResult createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateSnapshotRequest> request = new CreateSnapshotRequestMarshaller().marshall(createSnapshotRequest);
        CreateSnapshotResultJsonUnmarshaller unmarshaller = new CreateSnapshotResultJsonUnmarshaller();
        JsonResponseHandler<CreateSnapshotResult> responseHandler = new JsonResponseHandler<CreateSnapshotResult>(unmarshaller);
        return (CreateSnapshotResult)this.invoke(request, responseHandler);
    }

    @Override
    public DeleteVolumeResult deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteVolumeRequest> request = new DeleteVolumeRequestMarshaller().marshall(deleteVolumeRequest);
        DeleteVolumeResultJsonUnmarshaller unmarshaller = new DeleteVolumeResultJsonUnmarshaller();
        JsonResponseHandler<DeleteVolumeResult> responseHandler = new JsonResponseHandler<DeleteVolumeResult>(unmarshaller);
        return (DeleteVolumeResult)this.invoke(request, responseHandler);
    }

    @Override
    public UpdateMaintenanceStartTimeResult updateMaintenanceStartTime(UpdateMaintenanceStartTimeRequest updateMaintenanceStartTimeRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateMaintenanceStartTimeRequest> request = new UpdateMaintenanceStartTimeRequestMarshaller().marshall(updateMaintenanceStartTimeRequest);
        UpdateMaintenanceStartTimeResultJsonUnmarshaller unmarshaller = new UpdateMaintenanceStartTimeResultJsonUnmarshaller();
        JsonResponseHandler<UpdateMaintenanceStartTimeResult> responseHandler = new JsonResponseHandler<UpdateMaintenanceStartTimeResult>(unmarshaller);
        return (UpdateMaintenanceStartTimeResult)this.invoke(request, responseHandler);
    }

    @Override
    public DescribeGatewayInformationResult describeGatewayInformation(DescribeGatewayInformationRequest describeGatewayInformationRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeGatewayInformationRequest> request = new DescribeGatewayInformationRequestMarshaller().marshall(describeGatewayInformationRequest);
        DescribeGatewayInformationResultJsonUnmarshaller unmarshaller = new DescribeGatewayInformationResultJsonUnmarshaller();
        JsonResponseHandler<DescribeGatewayInformationResult> responseHandler = new JsonResponseHandler<DescribeGatewayInformationResult>(unmarshaller);
        return (DescribeGatewayInformationResult)this.invoke(request, responseHandler);
    }

    @Override
    public CreateStorediSCSIVolumeResult createStorediSCSIVolume(CreateStorediSCSIVolumeRequest createStorediSCSIVolumeRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateStorediSCSIVolumeRequest> request = new CreateStorediSCSIVolumeRequestMarshaller().marshall(createStorediSCSIVolumeRequest);
        CreateStorediSCSIVolumeResultJsonUnmarshaller unmarshaller = new CreateStorediSCSIVolumeResultJsonUnmarshaller();
        JsonResponseHandler<CreateStorediSCSIVolumeResult> responseHandler = new JsonResponseHandler<CreateStorediSCSIVolumeResult>(unmarshaller);
        return (CreateStorediSCSIVolumeResult)this.invoke(request, responseHandler);
    }

    @Override
    public UpdateChapCredentialsResult updateChapCredentials(UpdateChapCredentialsRequest updateChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateChapCredentialsRequest> request = new UpdateChapCredentialsRequestMarshaller().marshall(updateChapCredentialsRequest);
        UpdateChapCredentialsResultJsonUnmarshaller unmarshaller = new UpdateChapCredentialsResultJsonUnmarshaller();
        JsonResponseHandler<UpdateChapCredentialsResult> responseHandler = new JsonResponseHandler<UpdateChapCredentialsResult>(unmarshaller);
        return (UpdateChapCredentialsResult)this.invoke(request, responseHandler);
    }

    @Override
    public StartGatewayResult startGateway(StartGatewayRequest startGatewayRequest) throws AmazonServiceException, AmazonClientException {
        Request<StartGatewayRequest> request = new StartGatewayRequestMarshaller().marshall(startGatewayRequest);
        StartGatewayResultJsonUnmarshaller unmarshaller = new StartGatewayResultJsonUnmarshaller();
        JsonResponseHandler<StartGatewayResult> responseHandler = new JsonResponseHandler<StartGatewayResult>(unmarshaller);
        return (StartGatewayResult)this.invoke(request, responseHandler);
    }

    @Override
    public DeleteBandwidthRateLimitResult deleteBandwidthRateLimit(DeleteBandwidthRateLimitRequest deleteBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteBandwidthRateLimitRequest> request = new DeleteBandwidthRateLimitRequestMarshaller().marshall(deleteBandwidthRateLimitRequest);
        DeleteBandwidthRateLimitResultJsonUnmarshaller unmarshaller = new DeleteBandwidthRateLimitResultJsonUnmarshaller();
        JsonResponseHandler<DeleteBandwidthRateLimitResult> responseHandler = new JsonResponseHandler<DeleteBandwidthRateLimitResult>(unmarshaller);
        return (DeleteBandwidthRateLimitResult)this.invoke(request, responseHandler);
    }

    @Override
    public UpdateSnapshotScheduleResult updateSnapshotSchedule(UpdateSnapshotScheduleRequest updateSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateSnapshotScheduleRequest> request = new UpdateSnapshotScheduleRequestMarshaller().marshall(updateSnapshotScheduleRequest);
        UpdateSnapshotScheduleResultJsonUnmarshaller unmarshaller = new UpdateSnapshotScheduleResultJsonUnmarshaller();
        JsonResponseHandler<UpdateSnapshotScheduleResult> responseHandler = new JsonResponseHandler<UpdateSnapshotScheduleResult>(unmarshaller);
        return (UpdateSnapshotScheduleResult)this.invoke(request, responseHandler);
    }

    @Override
    public DescribeMaintenanceStartTimeResult describeMaintenanceStartTime(DescribeMaintenanceStartTimeRequest describeMaintenanceStartTimeRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeMaintenanceStartTimeRequest> request = new DescribeMaintenanceStartTimeRequestMarshaller().marshall(describeMaintenanceStartTimeRequest);
        DescribeMaintenanceStartTimeResultJsonUnmarshaller unmarshaller = new DescribeMaintenanceStartTimeResultJsonUnmarshaller();
        JsonResponseHandler<DescribeMaintenanceStartTimeResult> responseHandler = new JsonResponseHandler<DescribeMaintenanceStartTimeResult>(unmarshaller);
        return (DescribeMaintenanceStartTimeResult)this.invoke(request, responseHandler);
    }

    @Override
    public DescribeSnapshotScheduleResult describeSnapshotSchedule(DescribeSnapshotScheduleRequest describeSnapshotScheduleRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeSnapshotScheduleRequest> request = new DescribeSnapshotScheduleRequestMarshaller().marshall(describeSnapshotScheduleRequest);
        DescribeSnapshotScheduleResultJsonUnmarshaller unmarshaller = new DescribeSnapshotScheduleResultJsonUnmarshaller();
        JsonResponseHandler<DescribeSnapshotScheduleResult> responseHandler = new JsonResponseHandler<DescribeSnapshotScheduleResult>(unmarshaller);
        return (DescribeSnapshotScheduleResult)this.invoke(request, responseHandler);
    }

    @Override
    public UpdateBandwidthRateLimitResult updateBandwidthRateLimit(UpdateBandwidthRateLimitRequest updateBandwidthRateLimitRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateBandwidthRateLimitRequest> request = new UpdateBandwidthRateLimitRequestMarshaller().marshall(updateBandwidthRateLimitRequest);
        UpdateBandwidthRateLimitResultJsonUnmarshaller unmarshaller = new UpdateBandwidthRateLimitResultJsonUnmarshaller();
        JsonResponseHandler<UpdateBandwidthRateLimitResult> responseHandler = new JsonResponseHandler<UpdateBandwidthRateLimitResult>(unmarshaller);
        return (UpdateBandwidthRateLimitResult)this.invoke(request, responseHandler);
    }

    @Override
    public DeleteChapCredentialsResult deleteChapCredentials(DeleteChapCredentialsRequest deleteChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteChapCredentialsRequest> request = new DeleteChapCredentialsRequestMarshaller().marshall(deleteChapCredentialsRequest);
        DeleteChapCredentialsResultJsonUnmarshaller unmarshaller = new DeleteChapCredentialsResultJsonUnmarshaller();
        JsonResponseHandler<DeleteChapCredentialsResult> responseHandler = new JsonResponseHandler<DeleteChapCredentialsResult>(unmarshaller);
        return (DeleteChapCredentialsResult)this.invoke(request, responseHandler);
    }

    @Override
    public DescribeStorediSCSIVolumesResult describeStorediSCSIVolumes(DescribeStorediSCSIVolumesRequest describeStorediSCSIVolumesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeStorediSCSIVolumesRequest> request = new DescribeStorediSCSIVolumesRequestMarshaller().marshall(describeStorediSCSIVolumesRequest);
        DescribeStorediSCSIVolumesResultJsonUnmarshaller unmarshaller = new DescribeStorediSCSIVolumesResultJsonUnmarshaller();
        JsonResponseHandler<DescribeStorediSCSIVolumesResult> responseHandler = new JsonResponseHandler<DescribeStorediSCSIVolumesResult>(unmarshaller);
        return (DescribeStorediSCSIVolumesResult)this.invoke(request, responseHandler);
    }

    @Override
    public UpdateGatewayInformationResult updateGatewayInformation(UpdateGatewayInformationRequest updateGatewayInformationRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateGatewayInformationRequest> request = new UpdateGatewayInformationRequestMarshaller().marshall(updateGatewayInformationRequest);
        UpdateGatewayInformationResultJsonUnmarshaller unmarshaller = new UpdateGatewayInformationResultJsonUnmarshaller();
        JsonResponseHandler<UpdateGatewayInformationResult> responseHandler = new JsonResponseHandler<UpdateGatewayInformationResult>(unmarshaller);
        return (UpdateGatewayInformationResult)this.invoke(request, responseHandler);
    }

    @Override
    public DeleteGatewayResult deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteGatewayRequest> request = new DeleteGatewayRequestMarshaller().marshall(deleteGatewayRequest);
        DeleteGatewayResultJsonUnmarshaller unmarshaller = new DeleteGatewayResultJsonUnmarshaller();
        JsonResponseHandler<DeleteGatewayResult> responseHandler = new JsonResponseHandler<DeleteGatewayResult>(unmarshaller);
        return (DeleteGatewayResult)this.invoke(request, responseHandler);
    }

    @Override
    public ListVolumesResult listVolumes(ListVolumesRequest listVolumesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListVolumesRequest> request = new ListVolumesRequestMarshaller().marshall(listVolumesRequest);
        ListVolumesResultJsonUnmarshaller unmarshaller = new ListVolumesResultJsonUnmarshaller();
        JsonResponseHandler<ListVolumesResult> responseHandler = new JsonResponseHandler<ListVolumesResult>(unmarshaller);
        return (ListVolumesResult)this.invoke(request, responseHandler);
    }

    @Override
    public ListLocalDisksResult listLocalDisks(ListLocalDisksRequest listLocalDisksRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListLocalDisksRequest> request = new ListLocalDisksRequestMarshaller().marshall(listLocalDisksRequest);
        ListLocalDisksResultJsonUnmarshaller unmarshaller = new ListLocalDisksResultJsonUnmarshaller();
        JsonResponseHandler<ListLocalDisksResult> responseHandler = new JsonResponseHandler<ListLocalDisksResult>(unmarshaller);
        return (ListLocalDisksResult)this.invoke(request, responseHandler);
    }

    @Override
    public DescribeChapCredentialsResult describeChapCredentials(DescribeChapCredentialsRequest describeChapCredentialsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeChapCredentialsRequest> request = new DescribeChapCredentialsRequestMarshaller().marshall(describeChapCredentialsRequest);
        DescribeChapCredentialsResultJsonUnmarshaller unmarshaller = new DescribeChapCredentialsResultJsonUnmarshaller();
        JsonResponseHandler<DescribeChapCredentialsResult> responseHandler = new JsonResponseHandler<DescribeChapCredentialsResult>(unmarshaller);
        return (DescribeChapCredentialsResult)this.invoke(request, responseHandler);
    }

    @Override
    public UpdateGatewaySoftwareNowResult updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) throws AmazonServiceException, AmazonClientException {
        Request<UpdateGatewaySoftwareNowRequest> request = new UpdateGatewaySoftwareNowRequestMarshaller().marshall(updateGatewaySoftwareNowRequest);
        UpdateGatewaySoftwareNowResultJsonUnmarshaller unmarshaller = new UpdateGatewaySoftwareNowResultJsonUnmarshaller();
        JsonResponseHandler<UpdateGatewaySoftwareNowResult> responseHandler = new JsonResponseHandler<UpdateGatewaySoftwareNowResult>(unmarshaller);
        return (UpdateGatewaySoftwareNowResult)this.invoke(request, responseHandler);
    }

    @Override
    public ListGatewaysResult listGateways(ListGatewaysRequest listGatewaysRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListGatewaysRequest> request = new ListGatewaysRequestMarshaller().marshall(listGatewaysRequest);
        ListGatewaysResultJsonUnmarshaller unmarshaller = new ListGatewaysResultJsonUnmarshaller();
        JsonResponseHandler<ListGatewaysResult> responseHandler = new JsonResponseHandler<ListGatewaysResult>(unmarshaller);
        return (ListGatewaysResult)this.invoke(request, responseHandler);
    }

    @Override
    public DescribeWorkingStorageResult describeWorkingStorage(DescribeWorkingStorageRequest describeWorkingStorageRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeWorkingStorageRequest> request = new DescribeWorkingStorageRequestMarshaller().marshall(describeWorkingStorageRequest);
        DescribeWorkingStorageResultJsonUnmarshaller unmarshaller = new DescribeWorkingStorageResultJsonUnmarshaller();
        JsonResponseHandler<DescribeWorkingStorageResult> responseHandler = new JsonResponseHandler<DescribeWorkingStorageResult>(unmarshaller);
        return (DescribeWorkingStorageResult)this.invoke(request, responseHandler);
    }

    @Override
    public AddWorkingStorageResult addWorkingStorage(AddWorkingStorageRequest addWorkingStorageRequest) throws AmazonServiceException, AmazonClientException {
        Request<AddWorkingStorageRequest> request = new AddWorkingStorageRequestMarshaller().marshall(addWorkingStorageRequest);
        AddWorkingStorageResultJsonUnmarshaller unmarshaller = new AddWorkingStorageResultJsonUnmarshaller();
        JsonResponseHandler<AddWorkingStorageResult> responseHandler = new JsonResponseHandler<AddWorkingStorageResult>(unmarshaller);
        return (AddWorkingStorageResult)this.invoke(request, responseHandler);
    }

    @Override
    public ActivateGatewayResult activateGateway(ActivateGatewayRequest activateGatewayRequest) throws AmazonServiceException, AmazonClientException {
        Request<ActivateGatewayRequest> request = new ActivateGatewayRequestMarshaller().marshall(activateGatewayRequest);
        ActivateGatewayResultJsonUnmarshaller unmarshaller = new ActivateGatewayResultJsonUnmarshaller();
        JsonResponseHandler<ActivateGatewayResult> responseHandler = new JsonResponseHandler<ActivateGatewayResult>(unmarshaller);
        return (ActivateGatewayResult)this.invoke(request, responseHandler);
    }

    @Override
    public ListGatewaysResult listGateways() throws AmazonServiceException, AmazonClientException {
        return this.listGateways(new ListGatewaysRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler) {
        request.setEndpoint(this.endpoint);
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

