/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.SourceConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateConfigurationTemplateRequestMarshaller
implements Marshaller<Request<CreateConfigurationTemplateRequest>, CreateConfigurationTemplateRequest> {
    @Override
    public Request<CreateConfigurationTemplateRequest> marshall(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        DefaultRequest<CreateConfigurationTemplateRequest> request = new DefaultRequest<CreateConfigurationTemplateRequest>(createConfigurationTemplateRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "CreateConfigurationTemplate");
        request.addParameter("Version", "2010-12-01");
        if (createConfigurationTemplateRequest != null && createConfigurationTemplateRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(createConfigurationTemplateRequest.getApplicationName()));
        }
        if (createConfigurationTemplateRequest != null && createConfigurationTemplateRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString(createConfigurationTemplateRequest.getTemplateName()));
        }
        if (createConfigurationTemplateRequest != null && createConfigurationTemplateRequest.getSolutionStackName() != null) {
            request.addParameter("SolutionStackName", StringUtils.fromString(createConfigurationTemplateRequest.getSolutionStackName()));
        }
        if (createConfigurationTemplateRequest != null) {
            SourceConfiguration sourceConfiguration = createConfigurationTemplateRequest.getSourceConfiguration();
            if (sourceConfiguration != null && sourceConfiguration.getApplicationName() != null) {
                request.addParameter("SourceConfiguration.ApplicationName", StringUtils.fromString(sourceConfiguration.getApplicationName()));
            }
            if (sourceConfiguration != null && sourceConfiguration.getTemplateName() != null) {
                request.addParameter("SourceConfiguration.TemplateName", StringUtils.fromString(sourceConfiguration.getTemplateName()));
            }
        }
        if (createConfigurationTemplateRequest != null && createConfigurationTemplateRequest.getEnvironmentId() != null) {
            request.addParameter("EnvironmentId", StringUtils.fromString(createConfigurationTemplateRequest.getEnvironmentId()));
        }
        if (createConfigurationTemplateRequest != null && createConfigurationTemplateRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createConfigurationTemplateRequest.getDescription()));
        }
        if (createConfigurationTemplateRequest != null) {
            List<ConfigurationOptionSetting> optionSettingsList = createConfigurationTemplateRequest.getOptionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue != null && optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString(optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue != null && optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString(optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue != null && optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString(optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

