/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.simpleemail.model.Destination;
import com.amazonaws.services.simpleemail.model.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendEmailRequest
extends AmazonWebServiceRequest {
    private String source;
    private Destination destination;
    private Message message;
    private List<String> replyToAddresses;
    private String returnPath;

    public SendEmailRequest() {
    }

    public SendEmailRequest(String source, Destination destination, Message message) {
        this.source = source;
        this.destination = destination;
        this.message = message;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SendEmailRequest withSource(String source) {
        this.source = source;
        return this;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public SendEmailRequest withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public SendEmailRequest withMessage(Message message) {
        this.message = message;
        return this;
    }

    public List<String> getReplyToAddresses() {
        if (this.replyToAddresses == null) {
            this.replyToAddresses = new ArrayList<String>();
        }
        return this.replyToAddresses;
    }

    public void setReplyToAddresses(Collection<String> replyToAddresses) {
        ArrayList<String> replyToAddressesCopy = new ArrayList<String>();
        if (replyToAddresses != null) {
            replyToAddressesCopy.addAll(replyToAddresses);
        }
        this.replyToAddresses = replyToAddressesCopy;
    }

    public SendEmailRequest withReplyToAddresses(String ... replyToAddresses) {
        if (this.getReplyToAddresses() == null) {
            this.setReplyToAddresses(new ArrayList<String>());
        }
        for (String value : replyToAddresses) {
            this.getReplyToAddresses().add(value);
        }
        return this;
    }

    public SendEmailRequest withReplyToAddresses(Collection<String> replyToAddresses) {
        ArrayList<String> replyToAddressesCopy = new ArrayList<String>();
        if (replyToAddresses != null) {
            replyToAddressesCopy.addAll(replyToAddresses);
        }
        this.replyToAddresses = replyToAddressesCopy;
        return this;
    }

    public String getReturnPath() {
        return this.returnPath;
    }

    public void setReturnPath(String returnPath) {
        this.returnPath = returnPath;
    }

    public SendEmailRequest withReturnPath(String returnPath) {
        this.returnPath = returnPath;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Source: " + this.source + ", ");
        sb.append("Destination: " + this.destination + ", ");
        sb.append("Message: " + this.message + ", ");
        sb.append("ReplyToAddresses: " + this.replyToAddresses + ", ");
        sb.append("ReturnPath: " + this.returnPath + ", ");
        sb.append("}");
        return sb.toString();
    }
}

