/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import com.amazonaws.services.s3.internal.ServerSideEncryptionResult;
import com.amazonaws.transform.Unmarshaller;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSideEncryptionResponseHandler<T extends ServerSideEncryptionResult>
extends S3XmlResponseHandler<T> {
    public ServerSideEncryptionResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        super(responseUnmarshaller);
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        Object awsResponse = super.handle(response);
        ServerSideEncryptionResult result = (ServerSideEncryptionResult)((AmazonWebServiceResponse)awsResponse).getResult();
        if (result != null) {
            result.setServerSideEncryption(response.getHeaders().get("x-amz-server-side-encryption"));
        }
        return awsResponse;
    }
}

