/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model;

import com.amazonaws.services.route53.model.AliasTarget;
import com.amazonaws.services.route53.model.RRType;
import com.amazonaws.services.route53.model.ResourceRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRecordSet {
    private String name;
    private String type;
    private String setIdentifier;
    private Long weight;
    private Long tTL;
    private List<ResourceRecord> resourceRecords;
    private AliasTarget aliasTarget;

    public ResourceRecordSet() {
    }

    public ResourceRecordSet(String name, String type) {
        this.name = name;
        this.type = type;
    }

    public ResourceRecordSet(String name, RRType type) {
        this.name = name;
        this.type = type.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceRecordSet withName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ResourceRecordSet withType(String type) {
        this.type = type;
        return this;
    }

    public void setType(RRType type) {
        this.type = type.toString();
    }

    public ResourceRecordSet withType(RRType type) {
        this.type = type.toString();
        return this;
    }

    public String getSetIdentifier() {
        return this.setIdentifier;
    }

    public void setSetIdentifier(String setIdentifier) {
        this.setIdentifier = setIdentifier;
    }

    public ResourceRecordSet withSetIdentifier(String setIdentifier) {
        this.setIdentifier = setIdentifier;
        return this;
    }

    public Long getWeight() {
        return this.weight;
    }

    public void setWeight(Long weight) {
        this.weight = weight;
    }

    public ResourceRecordSet withWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    public Long getTTL() {
        return this.tTL;
    }

    public void setTTL(Long tTL) {
        this.tTL = tTL;
    }

    public ResourceRecordSet withTTL(Long tTL) {
        this.tTL = tTL;
        return this;
    }

    public List<ResourceRecord> getResourceRecords() {
        if (this.resourceRecords == null) {
            this.resourceRecords = new ArrayList<ResourceRecord>();
        }
        return this.resourceRecords;
    }

    public void setResourceRecords(Collection<ResourceRecord> resourceRecords) {
        ArrayList<ResourceRecord> resourceRecordsCopy = new ArrayList<ResourceRecord>();
        if (resourceRecords != null) {
            resourceRecordsCopy.addAll(resourceRecords);
        }
        this.resourceRecords = resourceRecordsCopy;
    }

    public ResourceRecordSet withResourceRecords(ResourceRecord ... resourceRecords) {
        if (this.getResourceRecords() == null) {
            this.setResourceRecords(new ArrayList<ResourceRecord>());
        }
        for (ResourceRecord value : resourceRecords) {
            this.getResourceRecords().add(value);
        }
        return this;
    }

    public ResourceRecordSet withResourceRecords(Collection<ResourceRecord> resourceRecords) {
        ArrayList<ResourceRecord> resourceRecordsCopy = new ArrayList<ResourceRecord>();
        if (resourceRecords != null) {
            resourceRecordsCopy.addAll(resourceRecords);
        }
        this.resourceRecords = resourceRecordsCopy;
        return this;
    }

    public AliasTarget getAliasTarget() {
        return this.aliasTarget;
    }

    public void setAliasTarget(AliasTarget aliasTarget) {
        this.aliasTarget = aliasTarget;
    }

    public ResourceRecordSet withAliasTarget(AliasTarget aliasTarget) {
        this.aliasTarget = aliasTarget;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Name: " + this.name + ", ");
        sb.append("Type: " + this.type + ", ");
        sb.append("SetIdentifier: " + this.setIdentifier + ", ");
        sb.append("Weight: " + this.weight + ", ");
        sb.append("TTL: " + this.tTL + ", ");
        sb.append("ResourceRecords: " + this.resourceRecords + ", ");
        sb.append("AliasTarget: " + this.aliasTarget + ", ");
        sb.append("}");
        return sb.toString();
    }
}

