/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancing.model.Listener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLoadBalancerRequest
extends AmazonWebServiceRequest {
    private String loadBalancerName;
    private List<Listener> listeners;
    private List<String> availabilityZones;
    private List<String> subnets;
    private List<String> securityGroups;

    public CreateLoadBalancerRequest() {
    }

    public CreateLoadBalancerRequest(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerRequest(String loadBalancerName, List<Listener> listeners, List<String> availabilityZones) {
        this.loadBalancerName = loadBalancerName;
        this.listeners = listeners;
        this.availabilityZones = availabilityZones;
    }

    public String getLoadBalancerName() {
        return this.loadBalancerName;
    }

    public void setLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
    }

    public CreateLoadBalancerRequest withLoadBalancerName(String loadBalancerName) {
        this.loadBalancerName = loadBalancerName;
        return this;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Listener>();
        }
        return this.listeners;
    }

    public void setListeners(Collection<Listener> listeners) {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>();
        if (listeners != null) {
            listenersCopy.addAll(listeners);
        }
        this.listeners = listenersCopy;
    }

    public CreateLoadBalancerRequest withListeners(Listener ... listeners) {
        if (this.getListeners() == null) {
            this.setListeners(new ArrayList<Listener>());
        }
        for (Listener value : listeners) {
            this.getListeners().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withListeners(Collection<Listener> listeners) {
        ArrayList<Listener> listenersCopy = new ArrayList<Listener>();
        if (listeners != null) {
            listenersCopy.addAll(listeners);
        }
        this.listeners = listenersCopy;
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>());
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withAvailabilityZones(Collection<String> availabilityZones) {
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
        return this;
    }

    public List<String> getSubnets() {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        return this.subnets;
    }

    public void setSubnets(Collection<String> subnets) {
        ArrayList<String> subnetsCopy = new ArrayList<String>();
        if (subnets != null) {
            subnetsCopy.addAll(subnets);
        }
        this.subnets = subnetsCopy;
    }

    public CreateLoadBalancerRequest withSubnets(String ... subnets) {
        if (this.getSubnets() == null) {
            this.setSubnets(new ArrayList<String>());
        }
        for (String value : subnets) {
            this.getSubnets().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withSubnets(Collection<String> subnets) {
        ArrayList<String> subnetsCopy = new ArrayList<String>();
        if (subnets != null) {
            subnetsCopy.addAll(subnets);
        }
        this.subnets = subnetsCopy;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        ArrayList<String> securityGroupsCopy = new ArrayList<String>();
        if (securityGroups != null) {
            securityGroupsCopy.addAll(securityGroups);
        }
        this.securityGroups = securityGroupsCopy;
    }

    public CreateLoadBalancerRequest withSecurityGroups(String ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<String>());
        }
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public CreateLoadBalancerRequest withSecurityGroups(Collection<String> securityGroups) {
        ArrayList<String> securityGroupsCopy = new ArrayList<String>();
        if (securityGroups != null) {
            securityGroupsCopy.addAll(securityGroups);
        }
        this.securityGroups = securityGroupsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("LoadBalancerName: " + this.loadBalancerName + ", ");
        sb.append("Listeners: " + this.listeners + ", ");
        sb.append("AvailabilityZones: " + this.availabilityZones + ", ");
        sb.append("Subnets: " + this.subnets + ", ");
        sb.append("SecurityGroups: " + this.securityGroups + ", ");
        sb.append("}");
        return sb.toString();
    }
}

