/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMessageBatchRequest
extends AmazonWebServiceRequest {
    private String queueUrl;
    private List<DeleteMessageBatchRequestEntry> entries;

    public DeleteMessageBatchRequest() {
    }

    public DeleteMessageBatchRequest(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public DeleteMessageBatchRequest(String queueUrl, List<DeleteMessageBatchRequestEntry> entries) {
        this.queueUrl = queueUrl;
        this.entries = entries;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public DeleteMessageBatchRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public List<DeleteMessageBatchRequestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<DeleteMessageBatchRequestEntry>();
        }
        return this.entries;
    }

    public void setEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
        ArrayList<DeleteMessageBatchRequestEntry> entriesCopy = new ArrayList<DeleteMessageBatchRequestEntry>();
        if (entries != null) {
            entriesCopy.addAll(entries);
        }
        this.entries = entriesCopy;
    }

    public DeleteMessageBatchRequest withEntries(DeleteMessageBatchRequestEntry ... entries) {
        if (this.getEntries() == null) {
            this.setEntries(new ArrayList<DeleteMessageBatchRequestEntry>());
        }
        for (DeleteMessageBatchRequestEntry value : entries) {
            this.getEntries().add(value);
        }
        return this;
    }

    public DeleteMessageBatchRequest withEntries(Collection<DeleteMessageBatchRequestEntry> entries) {
        ArrayList<DeleteMessageBatchRequestEntry> entriesCopy = new ArrayList<DeleteMessageBatchRequestEntry>();
        if (entries != null) {
            entriesCopy.addAll(entries);
        }
        this.entries = entriesCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("QueueUrl: " + this.queueUrl + ", ");
        sb.append("Entries: " + this.entries + ", ");
        sb.append("}");
        return sb.toString();
    }
}

